// CSS
import "./common/plugins";
import "../less/pos_invoice.css";
import "../less/tailwind.css";
import "vue3-perfect-scrollbar/dist/vue3-perfect-scrollbar.css";
import "vue3-colorpicker/style.css";

// Vue and other libraries
import * as Vue from "vue";
import * as VueRouter from "vue-router";
import * as Pinia from "pinia";
import axios from "axios";
import * as Vue3ColorPicker from "vue3-colorpicker";

// Composables
import crud from "./common/composable/crud";
import common from "./common/composable/common";
import datatable from "./common/composable/datatable";
import apiAdmin from "./common/composable/apiAdmin";

// Stores
import { useAuthStore } from "./main/store/authStore";
import { useModulesMenuStore } from "./main/store/modulesMenu";

// ============================================================================
// Expose Libraries for Modules (External Dependencies)
// ============================================================================
window.Vue = Vue;
window.VueRouter = VueRouter;
window.Pinia = Pinia;
window.axios = axios;
window.Vue3ColorPicker = Vue3ColorPicker;

// Expose composables for modules
window.__composables = {
    crud,
    common,
    datatable,
    apiAdmin
};

// Expose stores for modules
window.__stores = {
    useAuthStore,
    useModulesMenuStore
};

// ============================================================================
// Module Registry Setup
// ============================================================================
window.__registeredModules = window.__registeredModules || {};
window.registerModule = (name, api) => {
    if (!window.__registeredModules[name]) {
        window.__registeredModules[name] = { loaded: false };
    }
    window.__registeredModules[name].api = api;
    window.__registeredModules[name].loaded = true;
    if (window.__registeredModules[name].resolve) {
        window.__registeredModules[name].resolve(api);
    }
};
window.waitForModuleRegistration = (name, timeout = 10000) => {
    return new Promise((resolve, reject) => {
        if (window.__registeredModules[name]?.loaded) {
            return resolve(window.__registeredModules[name].api);
        }
        if (!window.__registeredModules[name]) {
            window.__registeredModules[name] = { loaded: false };
        }
        window.__registeredModules[name].resolve = resolve;
        setTimeout(() => {
            if (!window.__registeredModules[name]?.loaded) {
                reject(new Error(`Module "${name}" registration timeout`));
            }
        }, timeout);
    });
};