/**
 * AI Components Index
 *
 * Reusable AI components for website generation and management.
 * These components can be used independently or together.
 *
 * Components:
 * - AiDescriptionInput: Input component for business description with AI extraction
 * - AiExtractedDataReview: Review and edit AI-extracted website data
 * - AiPageGeneration: Generate and manage website pages using AI
 * - AiLegalPageGeneration: Generate and manage legal pages (Privacy Policy, Terms, etc.)
 * - AiSectionGeneration: Generate and manage website sections using AI
 * - AiWebsiteWizard: Complete wizard for creating websites with AI
 *
 * Note: AiWizardButton has been moved to @/main/views/websites/AiWizardButton.vue
 *
 * Usage Examples:
 *
 * 1. Using individual components for existing websites:
 *
 *    <AiPageGeneration
 *        :website-xid="websiteXid"
 *        :category="category"
 *        :description="description"
 *        :languages="languages"
 *        @generated="handlePagesGenerated"
 *        @saved="handlePagesSaved"
 *    />
 *
 *    <AiLegalPageGeneration
 *        :website-xid="websiteXid"
 *        :website-name="websiteName"
 *        :category="category"
 *        :description="description"
 *        :languages="languages"
 *        @saved="handleLegalPagesSaved"
 *    />
 *
 * 2. Using the complete wizard:
 *
 *    <AiWebsiteWizard
 *        v-model:open="showWizard"
 *        :categories="categories"
 *        mode="create"
 *        @created="handleWebsiteCreated"
 *    />
 */

import AiDescriptionInput from './AiDescriptionInput.vue';
import AiExtractedDataReview from './AiExtractedDataReview.vue';
import AiPageGeneration from './AiPageGeneration.vue';
import AiLegalPageGeneration from './AiLegalPageGeneration.vue';
import AiSectionGeneration from './AiSectionGeneration.vue';
import AiWebsiteWizard from './AiWebsiteWizard.vue';

export {
    AiDescriptionInput,
    AiExtractedDataReview,
    AiPageGeneration,
    AiLegalPageGeneration,
    AiSectionGeneration,
    AiWebsiteWizard
};
