import { defineAsyncComponent } from "vue";

export default (app) => {
    // Global Components - Register with lazy loading
    app.component("admin-page-filters", defineAsyncComponent(() =>
        import("./common/layouts/AdminPageFilters.vue")
    ));
    app.component("admin-page-table-content", defineAsyncComponent(() =>
        import("./common/layouts/AdminPageTableContent.vue")
    ));
    app.component("admin-layout", defineAsyncComponent(() =>
        import("./common/layouts/AdminLayout.vue")
    ));
    app.component("admin-page-header", defineAsyncComponent(() =>
        import("./common/layouts/AdminPageHeader.vue")
    ));
    app.component("UserAddButton", defineAsyncComponent(() =>
        import("./main/views/staff-members/UserAddButton.vue")
    ));
    app.component("CurrencyAddButton", defineAsyncComponent(() =>
        import("./main/views/common/settings/currency/AddButton.vue")
    ));
    app.component("RoleAddButton", defineAsyncComponent(() =>
        import("./main/views/settings/roles/AddButton.vue")
    ));

    // Common Components
    app.component("Upload", defineAsyncComponent(() =>
        import("./common/core/ui/file/Upload.vue")
    ));
    app.component("ImageUpload", defineAsyncComponent(() =>
        import("./common/core/ui/file/ImageUpload.vue")
    ));
    app.component("FileUpload", defineAsyncComponent(() =>
        import("./common/core/ui/file/FileUpload.vue")
    ));
    app.component("DateRangePicker", defineAsyncComponent(() =>
        import("./common/components/common/calendar/DateRangePicker.vue")
    ));
    app.component("DateTimePicker", defineAsyncComponent(() =>
        import("./common/components/common/calendar/DateTimePicker.vue")
    ));

    app.component("PhoneInput", defineAsyncComponent(() =>
        import("./common/core/ui/PhoneInput.vue")
    ));
    app.component("LeftSidebarHeading", defineAsyncComponent(() =>
        import("./common/components/LeftSidebarHeading.vue")
    ));
    app.component("IconPicker", defineAsyncComponent(() =>
        import("./common/components/IconPicker.vue")
    ));
    app.component("RichTextEditor", defineAsyncComponent(() =>
        import("./common/components/RichTextEditor.vue")
    ));
};
