import { useAuthStore } from "../store/authStore";

export default [
    {
        path: '/',
        component: () => import("../../common/layouts/AdminLayout.vue"),
        children: [
            {
                path: '/admin/dashboard',
                component: () => import("../views/Dashboard.vue"),
                name: 'admin.dashboard.index',
                meta: {
                    requireAuth: true,
                    menuParent: "dashboard",
                    menuKey: route => "dashboard",
                },
            }
        ]
    },
    // Named parent route for dynamic module routes
    {
        path: '/admin',
        name: 'admin',
        component: () => import("../../common/layouts/AdminLayout.vue"),
        children: []
    }
]
