import { createRouter, createWebHistory } from "vue-router";
import { setupRouterGuards } from "../verification";

import AuthRoutes from "./auth";
import DashboardRoutes from "./dashboard";
import SettingRoutes from "./settings";
import StaffMembersRoutes from "./staffMembers";

const appType = window.config.app_type;

// Dynamically import all route.js files from views folder
const viewRouteModules = import.meta.glob('../views/**/route.js', { eager: true });
const dynamicViewRoutes = Object.values(viewRouteModules).flatMap(module => module.default || []);

const router = createRouter({
    history: createWebHistory(),
    routes: [
        {
            path: "",
            redirect: "/admin/login",
        },
        ...AuthRoutes,
        ...DashboardRoutes,
        ...StaffMembersRoutes,
        ...SettingRoutes,
        ...dynamicViewRoutes,
    ],
    scrollBehavior: () => ({ left: 0, top: 0 }),
});

// Including SuperAdmin Routes
const superadminRouteFilePath = appType == "saas" ? "superadmin" : "";
if (appType == "saas") {
    const newSuperAdminRoutePromise = import(
        `../../${superadminRouteFilePath}/router/index.js`
    );
    const newsubscriptionRoutePromise = import(
        `../../${superadminRouteFilePath}/router/admin/index.js`
    );

    Promise.all([newSuperAdminRoutePromise, newsubscriptionRoutePromise]).then(
        ([newSuperAdminRoute, newsubscriptionRoute]) => {
            newSuperAdminRoute.default.forEach((route) =>
                router.addRoute(route)
            );
            newsubscriptionRoute.default.forEach((route) =>
                router.addRoute(route)
            );
        }
    );
}

// Setup all router guards (verification, auth, module loading, error handling)
// All sensitive logic is in the verification module which will be obfuscated
setupRouterGuards(router);

export default router;
