import { useI18n } from "vue-i18n";
import { getUrlByAppType } from "../../../../../common/scripts/functions";

const fields = () => {
    const url = getUrlByAppType("database-backups");
    const { t } = useI18n();

    const columns = [
        {
            title: t("database_backup.file"),
            dataIndex: "name",
        },
        {
            title: t("database_backup.file_type"),
            dataIndex: "type",
            width: 100,
        },
        {
            title: t("database_backup.file_size"),
            dataIndex: "size",
            width: 120,
        },
        {
            title: t("common.action"),
            dataIndex: "action",
            width: 150,
        },
    ];

    return {
        url,
        columns,
    }
}

export default fields;
