import { useI18n } from "vue-i18n";
import { getUrlByAppType } from "../../../../../../common/scripts/functions";

const fields = () => {
    const url = getUrlByAppType("langs?fields=id,xid,name,key,flag_code,is_rtl,enabled");
    const addEditUrl = getUrlByAppType("langs");
    const { t } = useI18n();

    const initData = {
        name: "",
        flag_code: null,
        is_rtl: false,
        enabled: true,
    };

    const columns = [
        {
            title: t("langs.name"),
            dataIndex: "name",
        },
        {
            title: t("langs.is_rtl"),
            dataIndex: "is_rtl",
        },
        {
            title: t("langs.enabled"),
            dataIndex: "enabled",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        },
    ];

    const filterableColumns = [
        {
            key: "name",
            value: t("langs.name")
        },
    ];

    return {
        url,
        addEditUrl,
        initData,
        columns,
        filterableColumns
    }
}

export default fields;
