import { useI18n } from "vue-i18n";

const fields = () => {
    const url = "icon-sets?fields=id,xid,name,prefix,sort_order,is_active,icons_count";
    const addEditUrl = "icon-sets";
    const { t } = useI18n();

    const initData = {
        name: "",
        prefix: "",
        is_active: true,
        icons: [],
    };

    const columns = [
        {
            title: "",
            dataIndex: "drag",
            width: 50,
        },
        {
            title: t("icon_set.name"),
            dataIndex: "name",
        },
        {
            title: t("icon_set.prefix"),
            dataIndex: "prefix",
        },
        {
            title: t("icon_set.icons_count"),
            dataIndex: "icons_count",
            width: 120,
        },
        {
            title: t("icon_set.status"),
            dataIndex: "is_active",
            width: 100,
        },
        {
            title: t("common.action"),
            dataIndex: "action",
            width: 150,
        },
    ];

    const filterableColumns = [
        {
            key: "name",
            value: t("icon_set.name"),
        },
        {
            key: "prefix",
            value: t("icon_set.prefix"),
        },
    ];

    return {
        url,
        addEditUrl,
        initData,
        columns,
        filterableColumns,
    };
};

export default fields;
