import { reactive, ref } from 'vue';
import { useI18n } from "vue-i18n";

const fields = () => {
    const { t } = useI18n();
    const addEditUrl = "staff-members";
    const url = ref("staff-members?fields=id,xid,user_type,name,email,profile_image,profile_image_url,phone,address,status,role_id,x_role_id,role{id,xid,name,display_name},allow_login,created_at");

    const hashableColumns = ['role_id'];

    const initData = {
        name: "",
        email: "",
        profile_image: undefined,
        profile_image_url: undefined,
        role_id: undefined,
        phone: "",
        address: "",
        status: "active",
        allow_login: 1,
        user_type: "users",
        password: "",
    };

    const columns = [{
        title: t("staff_member.name"),
        dataIndex: "name",
        key: "name",
        sorter: true,
    },
    {
        title: t("staff_member.email"),
        dataIndex: "email",
        sorter: true,
    },
    {
        title: t("staff_member.created_at"),
        dataIndex: "created_at",
        sorter: true,
    },
    {
        title: t("staff_member.status"),
        dataIndex: "status",
        key: "status",
    },
    {
        title: t("common.action"),
        dataIndex: "action",
    },
    ];

    const filterableColumns = [{
        key: "name",
        value: t("staff_member.name")
    },
    {
        key: "email",
        value: t("staff_member.email")
    },
    {
        key: "phone",
        value: t("staff_member.phone")
    },
    ];

    const filters = reactive({
        status: undefined,
        user_id: undefined,
    });

    return {
        url,
        addEditUrl,
        initData,
        columns,
        filters,
        filterableColumns,
        hashableColumns
    }
}

export default fields;
