import { useI18n } from "vue-i18n";

const fields = () => {
    const url = "website-categories?fields=id,xid,name,image,image_url,websites_count";
    const addEditUrl = "website-categories";
    const { t } = useI18n();

    const initData = {
        name: '',
        image: null,
        image_url: null,
    };

    const hashableColumns = [];

    const columns = [
        {
            title: t("website_category.name"),
            dataIndex: "name",
        },
        {
            title: t("website_category.websites_count"),
            dataIndex: "websites_count",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        }
    ];

    const filterableColumns = [
        {
            key: "name",
            value: t("website_category.name"),
        }
    ];

    return {
        url,
        addEditUrl,
        initData,
        hashableColumns,
        columns,
        filterableColumns,
    };
};

export default fields;
