import { useI18n } from "vue-i18n";

const fields = () => {
    const url = "website-languages?fields=id,xid,name,key,flag_code,is_rtl,enabled,is_default,website_id,x_website_id";
    const addEditUrl = "website-languages";
    const { t } = useI18n();

    const initData = {
        name: '',
        flag_code: null,
        is_rtl: false,
        enabled: true,
        is_default: false,
        website_id: null,
    };

    const hashableColumns = ['website_id'];

    const columns = [
        {
            title: t("website_language.name"),
            dataIndex: "name",
        },
        {
            title: t("website_language.key"),
            dataIndex: "key",
        },
        {
            title: t("website_language.is_rtl"),
            dataIndex: "is_rtl",
        },
        {
            title: t("website_language.enabled"),
            dataIndex: "enabled",
        },
        {
            title: t("website_language.is_default"),
            dataIndex: "is_default",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        }
    ];

    const filterableColumns = [
        {
            key: "name",
            value: t("website_language.name"),
        },
        {
            key: "key",
            value: t("website_language.key"),
        }
    ];

    return {
        url,
        addEditUrl,
        initData,
        hashableColumns,
        columns,
        filterableColumns,
    };
};

export default fields;
