const fields = () => {
    const url = "website-legal-pages?fields=id,xid,website_id,website_language_id,title,slug,page_url,content,meta_title,meta_description,meta_keywords,show_in_footer,display_order,status";
    const addEditUrl = "website-legal-pages";
    const { t } = window.i18n.global;

    const initData = {
        title: '',
        slug: '',
        content: '',
        meta_title: '',
        meta_description: '',
        meta_keywords: '',
        show_in_footer: true,
        status: 'active',
    };

    const hashableColumns = [];

    const columns = [
        {
            title: "",
            dataIndex: "drag",
            width: 50,
        },
        {
            title: t("website_legal_page.title"),
            dataIndex: "title",
        },
        {
            title: t("website_legal_page.slug"),
            dataIndex: "slug",
        },
        {
            title: t("website_legal_page.page_url"),
            dataIndex: "page_url",
        },
        {
            title: t("website_legal_page.show_in_footer"),
            dataIndex: "show_in_footer",
        },
        {
            title: t("website_legal_page.status"),
            dataIndex: "status",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        }
    ];

    const filterableColumns = [
        {
            key: "title",
            value: t("website_legal_page.title"),
        }
    ];

    return {
        url,
        addEditUrl,
        initData,
        hashableColumns,
        columns,
        filterableColumns,
    };
};

export default fields;
