import { useI18n } from "vue-i18n";

const fields = () => {
    const url = "website-pages?fields=id,xid,page_key,sort_order,website_id,x_website_id&limit=10000";
    const addEditUrl = "website-pages";
    const { t } = useI18n();

    const initData = {
        page_key: '',
        website_id: undefined,
        translations: {},
    };

    const hashableColumns = ['website_id'];

    const columns = [
        {
            title: "",
            dataIndex: "drag",
            width: 50,
        },
        {
            title: t("website_page.name"),
            dataIndex: "name",
        },
        {
            title: t("website_page.page_key"),
            dataIndex: "page_key",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        }
    ];

    const filterableColumns = [
        {
            key: "page_key",
            value: t("website_page.page_key"),
        }
    ];

    return {
        url,
        addEditUrl,
        initData,
        hashableColumns,
        columns,
        filterableColumns,
    };
};

export default fields;
