import { useI18n } from "vue-i18n";

const fields = () => {
    const url = "websites?fields=id,xid,name,slug,website_category_id,x_website_category_id,websiteCategory{id,xid,name},theme_name,theme_primary_color,theme_secondary_color,theme_mode,landing_url,sections_count,is_favourite,is_primary,custom_css,custom_js,use_same_header_across_all_pages,use_same_footer_across_all_pages,websiteLanguages{id,xid,name,key,flag_code,is_rtl,enabled,is_default}";
    const addEditUrl = "websites";
    const { t } = useI18n();

    const initData = {
        name: '',
        slug: '',
        website_category_id: null,
        theme_name: 'tailwind_theme',
        theme_primary_color: '#2563eb',
        theme_secondary_color: null,
        theme_mode: 'light',
        is_primary: false,
        custom_css: '',
        custom_js: '',
        use_same_header_across_all_pages: true,
        use_same_footer_across_all_pages: true,
        languages: [
            {
                name: 'English',
                key: 'en',
                flag_code: 'US',
                is_rtl: false,
                enabled: true,
                is_default: true,
            }
        ],
    };

    const hashableColumns = ['website_category_id'];

    const columns = [
        {
            title: t("website.name"),
            dataIndex: "name",
        },
        {
            title: t("website.slug"),
            dataIndex: "slug",
        },
        {
            title: t("website.category"),
            dataIndex: "website_category",
        },
        {
            title: t("website.theme_name"),
            dataIndex: "theme_name",
        },
        {
            title: t("website.landing_page_url"),
            dataIndex: "landing_url",
        },
        {
            title: t("website.favourite"),
            dataIndex: "is_favourite",
            width: 100,
            align: "center",
        },
        {
            title: t("common.action"),
            dataIndex: "action",
        }
    ];

    const filterableColumns = [
        {
            key: "name",
            value: t("website.name"),
        }
    ];

    return {
        url,
        addEditUrl,
        initData,
        hashableColumns,
        columns,
        filterableColumns,
    };
};

export default fields;
