<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>{{ $title }}</title>

    <style>
        body {
            font-family: {{ $company->use_custom_font && $company->pdfFont && $company->pdfFont->id ? $company->pdfFont->short_name . ', sans-serif' : 'sans-serif' }};
            margin: 0;
            padding: 0;
            font-size: {{ $company->pdf_font_size ?? 14 }}px;
            line-height: {{ $company->pdf_line_height ?? 1.5 }};
            color: #333;
        }

        @@page {
            margin: {{ $margins['top'] ?? '15mm' }} {{ $margins['right'] ?? '15mm' }} {{ $margins['bottom'] ?? '15mm' }} {{ $margins['left'] ?? '15mm' }};
        }

        .content-wrapper {
            width: 100%;
        }

        /* Common utility classes */
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .text-justify { text-align: justify; }

        .font-bold { font-weight: bold; }
        .font-normal { font-weight: normal; }

        /* Company header section */
        .company-header {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid {{ $company->pdf_header_color ?? '#333' }};
        }

        .company-header table {
            width: 100%;
        }

        .company-header td {
            vertical-align: middle;
        }

        .company-logo {
            max-width: 150px;
            max-height: 60px;
        }

        .company-name {
            font-size: {{ ($company->pdf_font_size ?? 14) + 6 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .company-info {
            font-size: {{ ($company->pdf_font_size ?? 14) - 2 }}px;
            color: #666;
        }

        /* Footer section */
        .page-footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: {{ ($company->pdf_font_size ?? 14) - 2 }}px;
            color: #666;
        }
    </style>

    @yield('styles')
</head>

<body>
    <div class="content-wrapper">
        @if($showHeaderFooter ?? false)
            <div class="company-header">
                <table>
                    <tr>
                        <td style="width: 170px;">
                            @if($logoUrl ?? false)
                                <img src="{{ $logoUrl }}" class="company-logo" />
                            @endif
                        </td>
                        <td class="text-right">
                            <div class="company-name">{{ $company->name }}</div>
                            <div class="company-info">
                                @if($company->address){{ $company->address }}<br>@endif
                                @if($company->phone){{ $company->phone }}@endif
                                @if($company->phone && $company->email) | @endif
                                @if($company->email){{ $company->email }}@endif
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        @endif

        @yield('content')
    </div>

</body>

</html>
