@extends('layouts.pdf')

@php
    // Dummy data for preview if actual data is not available
    if (!isset($booking)) {
        $booking = (object) [
            'booking_number' => 'BK-2025-001',
            'booking_date_time' => now(),
        ];
    }

    if (!isset($customer)) {
        $customer = (object) [
            'name' => 'John Doe',
            'phone' => '+91 9876543210',
            'address' => '123, Main Street, City Name, State - 400001',
        ];
    }

    if (!isset($vehicle)) {
        $vehicle = (object) [
            'vehicle_number' => 'MH-12-AB-1234',
            'modal' => 'Honda City 2023',
            'color' => 'White',
        ];
    }

    if (!isset($services)) {
        $services = [
            (object) ['name' => 'Premium Car Wash', 'price' => 500],
            (object) ['name' => 'Interior Cleaning', 'price' => 300],
            (object) ['name' => 'Exterior Polishing', 'price' => 800],
            (object) ['name' => 'Engine Cleaning', 'price' => 400],
        ];
    }

    if (!isset($payment)) {
        $payment = (object) [
            'payment_date' => now(),
            'method' => 'cash',
        ];
    }
@endphp

@section('styles')
    <style>
        .invoice-header {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 10 : 27 }}px;
            font-weight: bold;
            margin: 20px 0;
            text-align: center;
            color: {{ $company->pdf_header_color }};
        }

        .invoice-content {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height : 28 }}px;
        }

        .info-table {
            width: 100%;
            margin-top: 10px;
            border-collapse: collapse;
        }

        .info-table td {
            padding: 8px;
            border: 1px solid #ddd;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
        }

        .info-table td strong {
            font-weight: bold;
        }

        .services-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .services-table th {
            background: {{ $company->pdf_header_color }};
            color: #fff;
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
        }

        .services-table td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
        }

        .total-box {
            margin-top: 15px;
            width: 100%;
        }

        .total-box table {
            width: 45%;
            float: right;
            border-collapse: collapse;
        }

        .total-box td {
            padding: 10px;
            border: 1px solid #ddd;
            font-weight: bold;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 19 }}px;
        }

        .amount-words {
            margin-top: 15px;
            clear: both;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
            font-style: italic;
        }

        .payment-table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        .payment-table td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
        }

        .payment-title {
            font-weight: bold;
            background: #f5f5f5;
        }

        .signature-box {
            margin-top: 80px;
            width: 100%;
        }

        .signature-left {
            width: 50%;
            float: left;
            text-align: left;
        }

        .signature-right {
            width: 50%;
            float: right;
            text-align: right;
        }

        .seal {
            margin-top: 30px;
            border: 1px dashed #333;
            width: 150px;
            text-align: center;
            padding: 10px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 5 : 12 }}px;
        }

        .booking-info {
            text-align: right;
            margin-bottom: 10px;
        }

        .booking-info table {
            float: right;
            border-collapse: collapse;
        }

        .booking-info td {
            padding: 5px 10px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
        }
    </style>
@endsection

@section('content')
    <div class="invoice-content">
        <div class="booking-info">
            <table>
                <tr>
                    <td style="font-weight:bold; white-space:nowrap;">Booking No</td>
                    <td style="padding:0 8px;">:</td>
                    <td style="white-space:nowrap; font-weight:600;">
                        {{ $booking->booking_number }}
                    </td>
                </tr>
                <tr>
                    <td style="font-weight:bold; white-space:nowrap;">Booking Date</td>
                    <td style="padding:0 8px;">:</td>
                    <td style="white-space:nowrap;">
                        {{ \Carbon\Carbon::parse($booking->booking_date_time)->format('d-m-Y h:i A') }}
                    </td>
                </tr>
            </table>
        </div>

        @if ($company->pdf_title_show_in_pdf == 1)
            <div class="invoice-header">CAR WASH TAX INVOICE</div>
        @endif

        <table class="info-table">
            <tr>
                <td width="25%"><strong>Customer Name</strong></td>
                <td width="25%">{{ $customer->name }}</td>
                <td width="25%"><strong>Vehicle No</strong></td>
                <td width="25%">{{ $vehicle->vehicle_number }}</td>
            </tr>
            <tr>
                <td><strong>Phone</strong></td>
                <td>{{ $customer->phone }}</td>
                <td><strong>Vehicle Model</strong></td>
                <td>{{ $vehicle->modal }}</td>
            </tr>
            <tr>
                <td><strong>Address</strong></td>
                <td>{{ $customer->address }}</td>
                <td><strong>Color</strong></td>
                <td>{{ $vehicle->color }}</td>
            </tr>
        </table>

        <table class="services-table">
            <thead>
                <tr>
                    <th width="10%">#</th>
                    <th>Service Name</th>
                    <th width="25%" style="text-align:right">Price (₹)</th>
                </tr>
            </thead>
            <tbody>
                @php $total = 0; @endphp
                @foreach ($services as $index => $service)
                    @php $total += $service->price; @endphp
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $service->name }}</td>
                        <td style="text-align:right">{{ number_format($service->price, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="total-box">
            <table>
                <tr>
                    <td>Grand Total</td>
                    <td style="text-align:right">₹ {{ number_format($total, 2) }}</td>
                </tr>
            </table>
        </div>

        <div class="amount-words">
            <strong>Total (In Words):</strong>
            {{ \Modules\CarWashing\Classes\Common::convert($total) }} Only
        </div>

        @if (!empty($payment))
            <table class="payment-table">
                <tr>
                    <td class="payment-title" colspan="4">Payment Details</td>
                </tr>
                <tr>
                    <td width="25%"><strong>Payment Date</strong></td>
                    <td width="25%">
                        {{ \Carbon\Carbon::parse($payment->payment_date)->format('d-m-Y h:i A') }}
                    </td>
                    <td width="25%"><strong>Payment Mode</strong></td>
                    <td width="25%">{{ strtoupper($payment->method) }}</td>
                </tr>
                <tr>
                    <td><strong>Payment Status</strong></td>
                    <td colspan="3">
                        <span style="color:green;font-weight:bold;">PAID</span>
                    </td>
                </tr>
            </table>
        @endif

        <div class="signature-box">
            <div class="signature-left">
                <div class="seal">Company Seal</div>
            </div>
            <div class="signature-right">
                <strong>For {{ $company->name }}</strong><br><br><br>
                Authorized Signatory
            </div>
        </div>
    </div>
@endsection
