@extends('layouts.pdf')

@section('styles')
    <style>
        .container {
            width: 100%;
            margin: 0 auto;
            padding: 10px;
            box-sizing: border-box;
        }

        .export-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
            margin-top: 20px;
            border: none;
        }

        .export-table th {
            background-color: #f2f2f2;
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
            font-weight: bold;
        }

        .export-table td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
            height: auto;
        }

        .export-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .page-title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
            text-align: center;
        }

        .no-data {
            text-align: center;
            padding: 20px;
            color: #666;
        }
    </style>
@endsection

@section('content')
    <div class="container">
        <div class="page-title">{{ $title }}</div>

        <table class="export-table">
            <thead>
                <tr>
                    <th>#</th>
                    @foreach ($headers as $header)
                        <th>{{ $header }}</th>
                    @endforeach
                </tr>
            </thead>

            <tbody>
                @forelse ($records as $index => $record)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        @foreach ($record as $value)
                            <td>{{ $value }}</td>
                        @endforeach
                    </tr>
                @empty
                    <tr>
                        <td colspan="{{ count($headers) + 1 }}" class="no-data">
                            {{ $noData ?? 'No data available' }}
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
