@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .sample-header {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 8 : 25 }}px;
            font-weight: bold;
            margin-bottom: 20px;
            text-align: center;
        }

        .sample-content {
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height : 28 }}px;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        .info-table th,
        .info-table td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: left;
        }

        .info-table th {
            background-color: {{ $company->pdf_header_color }};
            color: white;
            font-weight: bold;
        }

        .info-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 4 : 21 }}px;
            font-weight: bold;
            margin-top: 30px;
            margin-bottom: 15px;
            color: {{ $company->pdf_header_color }};
        }

        .sample-paragraph {
            margin-bottom: 15px;
            text-align: justify;
        }
    </style>
@endsection

@section('content')
    <div class="sample-header">
        {{ $title }}
    </div>

    <div class="sample-content">
        <div class="section-title">PDF Font Settings Preview</div>

        <p class="sample-paragraph">
            This is a sample PDF document generated using your custom PDF font settings. This document demonstrates how
            your configured settings affect the appearance and layout of PDF documents throughout the application.
        </p>

        <p class="sample-paragraph">
            The font size, line height, spacing, and header color settings you've configured are all applied to this
            document. You can use this preview to ensure your PDF settings produce the desired output before using them in
            production documents.
        </p>

        <div class="section-title">Current PDF Configuration</div>

        <table class="info-table">
            <thead>
                <tr>
                    <th>Setting</th>
                    <th>Value</th>
                </tr>
            </thead>
            <tbody>
                @if ($company->use_custom_font && $company->pdfFont)
                    <tr>
                        <td>Custom Font</td>
                        <td>{{ $company->pdfFont->name }}</td>
                    </tr>
                @endif
                <tr>
                    <td>Font Size</td>
                    <td>{{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px</td>
                </tr>
                <tr>
                    <td>Line Height</td>
                    <td>{{ $company->pdf_line_height ? $company->pdf_line_height : 28 }}px</td>
                </tr>
                <tr>
                    <td>Header Color</td>
                    <td>{{ $company->pdf_header_color }}</td>
                </tr>
                <tr>
                    <td>Left Margin</td>
                    <td>{{ $company->pdf_left_space ? $company->pdf_left_space : 15 }}mm</td>
                </tr>
                <tr>
                    <td>Right Margin</td>
                    <td>{{ $company->pdf_right_space ? $company->pdf_right_space : 15 }}mm</td>
                </tr>
                <tr>
                    <td>Top Margin</td>
                    <td>{{ $company->pdf_top_space ? $company->pdf_top_space : 40 }}mm</td>
                </tr>
                <tr>
                    <td>Bottom Margin</td>
                    <td>{{ $company->pdf_bottom_space ? $company->pdf_bottom_space : 20 }}mm</td>
                </tr>
                <tr>
                    <td>Show Company Name</td>
                    <td>{{ $company->pdf_show_company_name == 1 ? 'Yes' : 'No' }}</td>
                </tr>
                <tr>
                    <td>Show Company Email</td>
                    <td>{{ $company->pdf_show_company_email == 1 ? 'Yes' : 'No' }}</td>
                </tr>
                <tr>
                    <td>Show Company Phone</td>
                    <td>{{ $company->pdf_show_company_phone == 1 ? 'Yes' : 'No' }}</td>
                </tr>
                <tr>
                    <td>Show Company Address</td>
                    <td>{{ $company->pdf_show_company_address == 1 ? 'Yes' : 'No' }}</td>
                </tr>
                <tr>
                    <td>Show Title in PDF</td>
                    <td>{{ $company->pdf_title_show_in_pdf == 1 ? 'Yes' : 'No' }}</td>
                </tr>
            </tbody>
        </table>

        <div class="section-title">Sample Content</div>

        <p class="sample-paragraph">
            <strong>Lorem ipsum dolor sit amet,</strong> consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut
            aliquip ex ea commodo consequat.
        </p>

        <p class="sample-paragraph">
            Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
            Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
        </p>

        <p class="sample-paragraph">
            Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem
            aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.
        </p>

        <div class="section-title">Font Size Variations</div>

        <p class="sample-paragraph" style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;">
            This paragraph uses a smaller font size ({{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px)
            to demonstrate how different font sizes appear in the document.
        </p>

        <p class="sample-paragraph">
            This paragraph uses the default configured font size
            ({{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px) for body text throughout the document.
        </p>

        <p class="sample-paragraph" style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 3 : 20 }}px;">
            This paragraph uses a larger font size ({{ $company->pdf_font_size ? $company->pdf_font_size + 3 : 20 }}px) to
            demonstrate emphasis or important information.
        </p>

        <div class="section-title">Conclusion</div>

        <p class="sample-paragraph">
            This sample document provides a comprehensive preview of your PDF font settings. If you need to make any
            adjustments to the font size, line height, margins, or other settings, you can do so from the PDF Settings
            configuration page and generate a new preview to see the changes.
        </p>

        <p class="sample-paragraph">
            Generated on: <strong>{{ now()->format('F d, Y - h:i A') }}</strong>
        </p>
    </div>
@endsection
