@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .header {
            margin-bottom: 20px;
        }

        .header table {
            width: 100%;
        }

        .doc-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 8 : 24 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .doc-number {
            font-size: {{ $company->pdf_font_size ?? 14 }}px;
            color: #666;
        }

        .company-info {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.4' }};
        }

        .two-col {
            width: 100%;
            margin-bottom: 15px;
        }

        .two-col td {
            width: 50%;
            vertical-align: top;
            padding: 0 10px;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ?? 13 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            border-bottom: 2px solid {{ $company->pdf_header_color ?? '#333' }};
            padding-bottom: 5px;
            margin-bottom: 8px;
        }

        .info-text {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.5' }};
        }

        .delivery-info {
            background: #f0f9ff;
            border: 1px solid #bae6fd;
            padding: 12px;
            margin: 15px 0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .delivery-info table {
            width: 100%;
        }

        .delivery-info td {
            padding: 3px 10px;
        }

        .delivery-info .label {
            color: #0369a1;
            width: 120px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }

        .items-table th {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 10px 8px;
            text-align: left;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #ddd;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table .text-center {
            text-align: center;
        }

        .checkbox {
            width: 16px;
            height: 16px;
            border: 1px solid #999;
            display: inline-block;
        }

        .notes-section {
            margin-top: 20px;
            padding: 15px;
            background: #fefce8;
            border: 1px solid #fde047;
        }

        .notes-title {
            font-weight: bold;
            color: #854d0e;
            margin-bottom: 8px;
        }

        .signature-section {
            margin-top: 25px;
        }

        .signature-section table {
            width: 100%;
        }

        .signature-box {
            border-top: 1px solid #333;
            width: 200px;
            padding-top: 8px;
            text-align: center;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #666;
        }

        .footer-text {
            margin-top: 20px;
            text-align: center;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #666;
        }

        .qr-box {
            padding: 5px;
            border: 1px solid #ddd;
            display: inline-block;
        }
    </style>
@endsection

@section('content')
    <div class="header">
        <table>
            <tr>
                <td>
                    <div class="doc-title">DELIVERY NOTE</div>
                    <div class="doc-number">#DN-{{ $sampleData['delivery_number'] }}</div>
                </td>
                <td style="text-align: right;">
                    <div class="company-info">
                        <strong>{{ $company->name }}</strong><br>
                        @if($company->address){{ $company->address }}<br>@endif
                        @if($company->phone){{ $company->phone }}<br>@endif
                        @if($company->email){{ $company->email }}@endif
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <table class="two-col">
        <tr>
            <td>
                <div class="section-title">Ship To</div>
                <div class="info-text">
                    <strong>{{ $sampleData['customer']['name'] }}</strong><br>
                    {{ $sampleData['customer']['address'] }}<br>
                    Phone: {{ $sampleData['customer']['phone'] }}
                </div>
            </td>
            <td>
                <div class="section-title">Order Reference</div>
                <div class="info-text">
                    <strong>Order #:</strong> {{ $sampleData['order_number'] }}<br>
                    <strong>Order Date:</strong> {{ $sampleData['order_date'] }}<br>
                    <strong>PO Number:</strong> {{ $sampleData['po_number'] }}
                </div>
            </td>
        </tr>
    </table>

    <div class="delivery-info">
        <table>
            <tr>
                <td class="label"><strong>Delivery Date:</strong></td>
                <td>{{ $sampleData['delivery_date'] }}</td>
                <td class="label"><strong>Carrier:</strong></td>
                <td>{{ $sampleData['carrier'] }}</td>
            </tr>
            <tr>
                <td class="label"><strong>Tracking #:</strong></td>
                <td>{{ $sampleData['tracking_number'] }}</td>
                <td class="label"><strong>Packages:</strong></td>
                <td>{{ $sampleData['packages'] }}</td>
            </tr>
        </table>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 30px;">#</th>
                <th>Item Description</th>
                <th class="text-center" style="width: 80px;">Ordered</th>
                <th class="text-center" style="width: 80px;">Shipped</th>
                <th class="text-center" style="width: 60px;">Check</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['items'] as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item['name'] }}</td>
                <td class="text-center">{{ $item['ordered'] }}</td>
                <td class="text-center">{{ $item['shipped'] }}</td>
                <td class="text-center"><span class="checkbox"></span></td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="notes-section">
        <div class="notes-title">Special Instructions</div>
        <div style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;">
            {{ $sampleData['notes'] ?? 'Handle with care. Please inspect items upon receipt and report any damages within 24 hours.' }}
        </div>
    </div>

    <div class="signature-section">
        <table>
            <tr>
                <td style="width: 33%;">
                    <div style="text-align: center;">
                        <div class="qr-box">
                            <barcode code="DN-{{ $sampleData['delivery_number'] }}" type="QR" size="0.6" error="M" />
                        </div>
                    </div>
                </td>
                <td style="width: 33%; text-align: center;">
                    <div style="margin-top: 40px;">
                        <div class="signature-box">Delivered By</div>
                    </div>
                </td>
                <td style="width: 33%; text-align: right;">
                    <div style="margin-top: 40px;">
                        <div class="signature-box" style="margin-left: auto;">Received By</div>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="footer-text">
        Please sign and return a copy of this delivery note as confirmation of receipt.
    </div>
@endsection
