@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .header {
            border-bottom: 3px solid {{ $company->pdf_header_color ?? '#111' }};
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .company-name {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 10 : 26 }}px;
            font-weight: 300;
            color: #111;
            letter-spacing: -1px;
        }

        .invoice-label {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 6 : 20 }}px;
            color: #666;
            font-weight: 300;
            text-transform: uppercase;
            letter-spacing: 3px;
        }

        .two-col {
            width: 100%;
            margin-bottom: 25px;
        }

        .two-col td {
            width: 50%;
            vertical-align: top;
        }

        .label {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #999;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 5px;
        }

        .value {
            font-size: {{ $company->pdf_font_size ?? 13 }}px;
            color: #333;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.5' }};
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        .items-table th {
            text-align: left;
            padding: 12px 0;
            border-bottom: 1px solid #ddd;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #999;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: normal;
        }

        .items-table td {
            padding: 15px 0;
            border-bottom: 1px solid #eee;
            font-size: {{ $company->pdf_font_size ?? 13 }}px;
        }

        .items-table .text-right {
            text-align: right;
        }

        .summary-section {
            width: 100%;
            margin-top: 20px;
        }

        .summary-section td {
            vertical-align: top;
        }

        .bank-col {
            width: 50%;
            padding-right: 30px;
        }

        .totals-col {
            width: 50%;
        }

        .bank-details {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            color: #666;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.6' }};
        }

        .totals-table {
            width: 100%;
        }

        .totals-table td {
            padding: 8px 0;
            font-size: {{ $company->pdf_font_size ?? 13 }}px;
        }

        .totals-table .total-row td {
            padding-top: 15px;
            border-top: 2px solid #111;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 4 : 18 }}px;
            font-weight: 600;
        }

        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            text-align: center;
            color: #999;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
        }

        .qr-section {
            text-align: right;
            margin-top: 10px;
        }
    </style>
@endsection

@section('content')
    <div class="header">
        <table style="width: 100%;">
            <tr>
                <td>
                    <div class="company-name">{{ $company->name }}</div>
                </td>
                <td style="text-align: right;">
                    <div class="invoice-label">Invoice</div>
                </td>
            </tr>
        </table>
    </div>

    <table class="two-col">
        <tr>
            <td>
                <div class="label">From</div>
                <div class="value">
                    {{ $company->name }}<br>
                    @if($company->address){{ $company->address }}<br>@endif
                    @if($company->email){{ $company->email }}<br>@endif
                    @if($company->phone){{ $company->phone }}@endif
                </div>
            </td>
            <td>
                <div class="label">Bill To</div>
                <div class="value">
                    {{ $sampleData['customer']['name'] }}<br>
                    {{ $sampleData['customer']['address'] }}<br>
                    {{ $sampleData['customer']['email'] }}<br>
                    {{ $sampleData['customer']['phone'] }}
                </div>
            </td>
        </tr>
    </table>

    <table class="two-col">
        <tr>
            <td>
                <table style="width: 80%;">
                    <tr>
                        <td class="label" style="width: 100px;">Invoice No.</td>
                        <td class="value">{{ $sampleData['invoice_number'] }}</td>
                    </tr>
                    <tr>
                        <td class="label">Date</td>
                        <td class="value">{{ $sampleData['invoice_date'] }}</td>
                    </tr>
                </table>
            </td>
            <td>
                <table style="width: 80%;">
                    <tr>
                        <td class="label" style="width: 100px;">Due Date</td>
                        <td class="value">{{ $sampleData['due_date'] }}</td>
                    </tr>
                    <tr>
                        <td class="label">Terms</td>
                        <td class="value">Net 30</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <table class="items-table">
        <thead>
            <tr>
                <th>Description</th>
                <th class="text-right" style="width: 60px;">Qty</th>
                <th class="text-right" style="width: 100px;">Rate</th>
                <th class="text-right" style="width: 100px;">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['items'] as $item)
            <tr>
                <td>{{ $item['name'] }}</td>
                <td class="text-right">{{ $item['quantity'] }}</td>
                <td class="text-right">${{ number_format($item['price'], 2) }}</td>
                <td class="text-right">${{ number_format($item['quantity'] * $item['price'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="summary-section">
        <tr>
            <td class="bank-col">
                <div class="label">Payment Information</div>
                <div class="bank-details">
                    Bank: First National Bank<br>
                    Account: {{ $company->name }}<br>
                    Account No: XXXX-XXXX-1234<br>
                    SWIFT: FNBKUS33
                </div>
                <div class="qr-section">
                    <barcode code="{{ $sampleData['invoice_number'] }}" type="QR" size="0.6" error="M" />
                </div>
            </td>
            <td class="totals-col">
                <table class="totals-table">
                    <tr>
                        <td>Subtotal</td>
                        <td class="text-right">${{ number_format($sampleData['subtotal'], 2) }}</td>
                    </tr>
                    <tr>
                        <td>Tax (10%)</td>
                        <td class="text-right">${{ number_format($sampleData['tax'], 2) }}</td>
                    </tr>
                    @if(isset($sampleData['discount']) && $sampleData['discount'] > 0)
                    <tr>
                        <td>Discount</td>
                        <td class="text-right">-${{ number_format($sampleData['discount'], 2) }}</td>
                    </tr>
                    @endif
                    <tr class="total-row">
                        <td>Total</td>
                        <td class="text-right">${{ number_format($sampleData['total'], 2) }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <div class="footer">
        Thank you for your business.
    </div>
@endsection
