@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .header-bar {
            background-color: {{ $company->pdf_header_color ?? '#2563eb' }};
            color: white;
            padding: 15px 20px;
            margin: -15mm -15mm 20px -15mm;
        }

        .header-bar table {
            width: 100%;
        }

        .company-name {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 6 : 20 }}px;
            font-weight: bold;
        }

        .invoice-badge {
            background: rgba(255,255,255,0.2);
            padding: 8px 15px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 4 : 18 }}px;
            font-weight: bold;
        }

        .info-section {
            margin-bottom: 15px;
        }

        .info-box {
            background: #f8fafc;
            padding: 12px;
            border-radius: 4px;
        }

        .info-label {
            color: #64748b;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 3px;
        }

        .info-value {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            color: #1e293b;
        }

        .two-column {
            width: 100%;
        }

        .two-column td {
            width: 50%;
            vertical-align: top;
            padding: 0 8px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table th {
            background-color: #f1f5f9;
            color: #475569;
            padding: 10px 8px;
            text-align: left;
            font-weight: 600;
            border-bottom: 2px solid {{ $company->pdf_header_color ?? '#2563eb' }};
        }

        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #e2e8f0;
        }

        .items-table .text-right {
            text-align: right;
        }

        .items-table .text-center {
            text-align: center;
        }

        .summary-row {
            width: 100%;
            margin-top: 15px;
        }

        .summary-row td {
            vertical-align: top;
        }

        .bank-section {
            width: 55%;
            padding-right: 20px;
        }

        .totals-section {
            width: 45%;
        }

        .bank-card {
            border: 1px solid #e2e8f0;
            padding: 12px;
            border-radius: 6px;
        }

        .bank-title {
            font-weight: 600;
            color: {{ $company->pdf_header_color ?? '#2563eb' }};
            margin-bottom: 8px;
            font-size: {{ $company->pdf_font_size ?? 13 }}px;
        }

        .bank-info {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #475569;
        }

        .bank-info p {
            margin: 4px 0;
        }

        .totals-table {
            width: 100%;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .totals-table td {
            padding: 6px 0;
        }

        .totals-table .total-row {
            background: {{ $company->pdf_header_color ?? '#2563eb' }};
            color: white;
        }

        .totals-table .total-row td {
            padding: 10px 8px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 16 }}px;
            font-weight: bold;
        }

        .qr-box {
            text-align: center;
            padding: 8px;
            background: #f8fafc;
            border-radius: 4px;
        }

        .footer-text {
            text-align: center;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
            color: #64748b;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
        }
    </style>
@endsection

@section('content')
    <div class="header-bar">
        <table>
            <tr>
                <td>
                    <div class="company-name">{{ $company->name }}</div>
                    <div style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 3 : 11 }}px; opacity: 0.9; margin-top: 3px;">
                        @if($company->address){{ $company->address }}@endif
                    </div>
                </td>
                <td style="text-align: right;">
                    <div class="invoice-badge">INVOICE</div>
                </td>
            </tr>
        </table>
    </div>

    <table class="two-column" style="margin-bottom: 15px;">
        <tr>
            <td>
                <div class="info-box">
                    <div class="info-label">Bill To</div>
                    <div class="info-value">
                        <strong>{{ $sampleData['customer']['name'] }}</strong><br>
                        {{ $sampleData['customer']['address'] }}<br>
                        {{ $sampleData['customer']['phone'] }}<br>
                        {{ $sampleData['customer']['email'] }}
                    </div>
                </div>
            </td>
            <td>
                <div class="info-box">
                    <table style="width: 100%; font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;">
                        <tr>
                            <td class="info-label" style="width: 80px;">Invoice #</td>
                            <td class="info-value"><strong>{{ $sampleData['invoice_number'] }}</strong></td>
                        </tr>
                        <tr>
                            <td class="info-label">Date</td>
                            <td class="info-value">{{ $sampleData['invoice_date'] }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Due Date</td>
                            <td class="info-value">{{ $sampleData['due_date'] }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Status</td>
                            <td class="info-value"><span style="color: #dc2626; font-weight: 600;">UNPAID</span></td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
    </table>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 30px;">#</th>
                <th>Item Description</th>
                <th class="text-center" style="width: 60px;">Qty</th>
                <th class="text-right" style="width: 90px;">Rate</th>
                <th class="text-right" style="width: 100px;">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['items'] as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item['name'] }}</td>
                <td class="text-center">{{ $item['quantity'] }}</td>
                <td class="text-right">${{ number_format($item['price'], 2) }}</td>
                <td class="text-right">${{ number_format($item['quantity'] * $item['price'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="summary-row">
        <tr>
            <td class="bank-section">
                <div class="bank-card">
                    <div class="bank-title">Payment Details</div>
                    <div class="bank-info">
                        <p><strong>Bank:</strong> First National Bank</p>
                        <p><strong>Account:</strong> {{ $company->name }}</p>
                        <p><strong>Account #:</strong> XXXX-XXXX-1234</p>
                        <p><strong>Routing:</strong> 021000021</p>
                    </div>
                </div>
                <div class="qr-box" style="margin-top: 10px;">
                    <barcode code="{{ $sampleData['invoice_number'] }}" type="QR" size="0.7" error="M" />
                    <div style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 4 : 10 }}px; color: #64748b; margin-top: 5px;">Scan to pay</div>
                </div>
            </td>
            <td class="totals-section">
                <table class="totals-table">
                    <tr>
                        <td>Subtotal</td>
                        <td style="text-align: right;">${{ number_format($sampleData['subtotal'], 2) }}</td>
                    </tr>
                    <tr>
                        <td>Tax (10%)</td>
                        <td style="text-align: right;">${{ number_format($sampleData['tax'], 2) }}</td>
                    </tr>
                    @if(isset($sampleData['discount']) && $sampleData['discount'] > 0)
                    <tr>
                        <td>Discount</td>
                        <td style="text-align: right;">-${{ number_format($sampleData['discount'], 2) }}</td>
                    </tr>
                    @endif
                    <tr class="total-row">
                        <td>Total Due</td>
                        <td style="text-align: right;">${{ number_format($sampleData['total'], 2) }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <div class="footer-text">
        Thank you for your business! Payment is due within 30 days.<br>
        {{ $company->email ?? '' }} | {{ $company->phone ?? '' }}
    </div>
@endsection
