@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .invoice-header {
            margin-bottom: 15px;
        }

        .invoice-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 8 : 24 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .invoice-number {
            font-size: {{ $company->pdf_font_size ?? 14 }}px;
            color: #666;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 1 : 15 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            margin-bottom: 5px;
            padding-bottom: 3px;
            border-bottom: 1px solid {{ $company->pdf_header_color ?? '#333' }};
        }

        .info-text {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.4' }};
            color: #444;
        }

        .info-text strong {
            color: #222;
        }

        .two-column {
            width: 100%;
        }

        .two-column td {
            width: 50%;
            vertical-align: top;
            padding: 0 5px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table th {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 8px 6px;
            text-align: left;
            font-weight: bold;
        }

        .items-table td {
            padding: 8px 6px;
            border-bottom: 1px solid #ddd;
        }

        .items-table .text-right {
            text-align: right;
        }

        .items-table .text-center {
            text-align: center;
        }

        .summary-section {
            width: 100%;
            margin-top: 15px;
        }

        .summary-section td {
            vertical-align: top;
        }

        .bank-details {
            width: 55%;
            padding-right: 15px;
        }

        .totals-column {
            width: 45%;
        }

        .bank-box {
            background-color: #f8f9fa;
            padding: 10px;
            border-left: 3px solid {{ $company->pdf_header_color ?? '#333' }};
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .bank-box p {
            margin: 3px 0;
        }

        .totals-table {
            width: 100%;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .totals-table td {
            padding: 5px 0;
        }

        .totals-table .label {
            text-align: left;
        }

        .totals-table .value {
            text-align: right;
            font-weight: bold;
        }

        .totals-table .grand-total td {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 16 }}px;
            color: {{ $company->pdf_header_color ?? '#333' }};
            border-top: 2px solid {{ $company->pdf_header_color ?? '#333' }};
            padding-top: 8px;
        }

        .footer-note {
            margin-top: 15px;
            text-align: center;
            color: #666;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }

        .qr-code {
            padding: 5px;
            border: 1px solid #ddd;
            background: #fff;
            display: inline-block;
        }

        .date-info {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            margin: 8px 0;
        }

        .date-info td {
            padding: 2px 0;
        }

        .date-info .label {
            color: #666;
            width: 90px;
        }
    </style>
@endsection

@section('content')
    <div class="invoice-header">
        <table class="two-column">
            <tr>
                <td>
                    <div class="invoice-title">INVOICE</div>
                    <div class="invoice-number">#{{ $sampleData['invoice_number'] }}</div>
                </td>
                <td style="text-align: right;">
                    <div class="qr-code">
                        <barcode code="{{ $sampleData['invoice_number'] }}" type="QR" size="0.8" error="M" />
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <table class="two-column">
        <tr>
            <td>
                <div class="section-title">From</div>
                <div class="info-text">
                    <strong>{{ $company->name }}</strong><br>
                    @if($company->address){{ $company->address }}<br>@endif
                    @if($company->phone)Phone: {{ $company->phone }}<br>@endif
                    @if($company->email)Email: {{ $company->email }}@endif
                </div>
            </td>
            <td>
                <div class="section-title">Bill To</div>
                <div class="info-text">
                    <strong>{{ $sampleData['customer']['name'] }}</strong><br>
                    {{ $sampleData['customer']['address'] }}<br>
                    Phone: {{ $sampleData['customer']['phone'] }}<br>
                    Email: {{ $sampleData['customer']['email'] }}
                </div>
            </td>
        </tr>
    </table>

    <table class="date-info" style="width: 100%; margin-top: 10px;">
        <tr>
            <td class="label">Invoice Date:</td>
            <td style="width: 120px;">{{ $sampleData['invoice_date'] }}</td>
            <td class="label">Due Date:</td>
            <td style="width: 120px;">{{ $sampleData['due_date'] }}</td>
            <td class="label">Status:</td>
            <td><strong style="color: #dc3545;">Unpaid</strong></td>
        </tr>
    </table>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 30px;">#</th>
                <th>Description</th>
                <th class="text-center" style="width: 50px;">Qty</th>
                <th class="text-right" style="width: 80px;">Price</th>
                <th class="text-right" style="width: 90px;">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['items'] as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item['name'] }}</td>
                <td class="text-center">{{ $item['quantity'] }}</td>
                <td class="text-right">${{ number_format($item['price'], 2) }}</td>
                <td class="text-right">${{ number_format($item['quantity'] * $item['price'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="summary-section">
        <tr>
            <td class="bank-details">
                <div class="section-title">Payment Information</div>
                <div class="bank-box">
                    <p><strong>Bank:</strong> First National Bank</p>
                    <p><strong>Account Name:</strong> {{ $company->name }}</p>
                    <p><strong>Account No:</strong> XXXX-XXXX-1234</p>
                    <p><strong>SWIFT:</strong> FNBKUS33</p>
                </div>
            </td>
            <td class="totals-column">
                <table class="totals-table">
                    <tr>
                        <td class="label">Subtotal:</td>
                        <td class="value">${{ number_format($sampleData['subtotal'], 2) }}</td>
                    </tr>
                    <tr>
                        <td class="label">Tax (10%):</td>
                        <td class="value">${{ number_format($sampleData['tax'], 2) }}</td>
                    </tr>
                    @if(isset($sampleData['discount']) && $sampleData['discount'] > 0)
                    <tr>
                        <td class="label">Discount:</td>
                        <td class="value">-${{ number_format($sampleData['discount'], 2) }}</td>
                    </tr>
                    @endif
                    <tr class="grand-total">
                        <td class="label"><strong>Total:</strong></td>
                        <td class="value"><strong>${{ number_format($sampleData['total'], 2) }}</strong></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <div class="footer-note">
        <p>Thank you for your business! | Payment due within 30 days</p>
        <p>Questions? Contact us at {{ $company->email ?? 'support@company.com' }}</p>
    </div>
@endsection
