@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .po-header {
            background: linear-gradient(135deg, {{ $company->pdf_header_color ?? '#1e40af' }} 0%, {{ $company->pdf_header_color ?? '#1e40af' }}dd 100%);
            color: white;
            padding: 20px;
            margin: -15mm -15mm 20px -15mm;
        }

        .po-header table {
            width: 100%;
        }

        .po-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 10 : 26 }}px;
            font-weight: bold;
            letter-spacing: 2px;
        }

        .po-number {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 16 }}px;
            opacity: 0.9;
            margin-top: 5px;
        }

        .company-logo-area {
            text-align: right;
        }

        .company-name-header {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 4 : 18 }}px;
            font-weight: bold;
        }

        .two-col {
            width: 100%;
            margin-bottom: 20px;
        }

        .two-col td {
            width: 50%;
            vertical-align: top;
            padding: 0 10px;
        }

        .info-card {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            padding: 15px;
            height: 100%;
        }

        .card-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            color: {{ $company->pdf_header_color ?? '#1e40af' }};
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 2px solid {{ $company->pdf_header_color ?? '#1e40af' }};
        }

        .card-content {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.6' }};
        }

        .po-details {
            background: #eff6ff;
            border: 1px solid #bfdbfe;
            padding: 12px 15px;
            margin-bottom: 15px;
        }

        .po-details table {
            width: 100%;
        }

        .po-details td {
            padding: 4px 15px 4px 0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .po-details .label {
            color: #1e40af;
            font-weight: 600;
            width: 100px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }

        .items-table th {
            background-color: {{ $company->pdf_header_color ?? '#1e40af' }};
            color: white;
            padding: 10px 8px;
            text-align: left;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #e2e8f0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .items-table tr:nth-child(even) {
            background-color: #f8fafc;
        }

        .items-table .text-right {
            text-align: right;
        }

        .items-table .text-center {
            text-align: center;
        }

        .summary-section {
            width: 100%;
            margin-top: 15px;
        }

        .summary-section td {
            vertical-align: top;
        }

        .terms-col {
            width: 55%;
            padding-right: 20px;
        }

        .totals-col {
            width: 45%;
        }

        .terms-box {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #475569;
            line-height: {{ $company->pdf_line_height ? $company->pdf_line_height . 'px' : '1.6' }};
        }

        .terms-box h4 {
            color: {{ $company->pdf_header_color ?? '#1e40af' }};
            margin: 0 0 8px 0;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .terms-box ol {
            margin: 0;
            padding-left: 20px;
        }

        .terms-box li {
            margin-bottom: 5px;
        }

        .totals-table {
            width: 100%;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
        }

        .totals-table td {
            padding: 8px 12px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 12 }}px;
        }

        .totals-table .total-row {
            background: {{ $company->pdf_header_color ?? '#1e40af' }};
            color: white;
            font-weight: bold;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 1 : 15 }}px;
        }

        .authorization {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
        }

        .signature-line {
            border-bottom: 1px solid #333;
            width: 200px;
            margin-top: 40px;
            padding-bottom: 5px;
        }

        .signature-label {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 11 }}px;
            color: #666;
            margin-top: 5px;
        }

        .qr-box {
            text-align: center;
            padding: 10px;
        }
    </style>
@endsection

@section('content')
    <div class="po-header">
        <table>
            <tr>
                <td>
                    <div class="po-title">PURCHASE ORDER</div>
                    <div class="po-number">PO# {{ $sampleData['po_number'] }}</div>
                </td>
                <td class="company-logo-area">
                    <div class="company-name-header">{{ $company->name }}</div>
                    <div style="font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 3 : 11 }}px; opacity: 0.9;">
                        @if($company->address){{ $company->address }}@endif
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <table class="two-col">
        <tr>
            <td>
                <div class="info-card">
                    <div class="card-title">Vendor</div>
                    <div class="card-content">
                        <strong>{{ $sampleData['vendor']['name'] }}</strong><br>
                        {{ $sampleData['vendor']['address'] }}<br>
                        Phone: {{ $sampleData['vendor']['phone'] }}<br>
                        Email: {{ $sampleData['vendor']['email'] }}
                    </div>
                </div>
            </td>
            <td>
                <div class="info-card">
                    <div class="card-title">Ship To</div>
                    <div class="card-content">
                        <strong>{{ $company->name }}</strong><br>
                        @if($company->address){{ $company->address }}<br>@endif
                        @if($company->phone)Phone: {{ $company->phone }}<br>@endif
                        @if($company->email)Email: {{ $company->email }}@endif
                    </div>
                </div>
            </td>
        </tr>
    </table>

    <div class="po-details">
        <table>
            <tr>
                <td class="label">PO Date:</td>
                <td>{{ $sampleData['date'] }}</td>
                <td class="label">Required By:</td>
                <td>{{ $sampleData['required_date'] }}</td>
            </tr>
            <tr>
                <td class="label">Payment:</td>
                <td>{{ $sampleData['payment_terms'] }}</td>
                <td class="label">Shipping:</td>
                <td>{{ $sampleData['shipping_method'] }}</td>
            </tr>
        </table>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 30px;">#</th>
                <th>Item Description</th>
                <th class="text-center" style="width: 70px;">Qty</th>
                <th class="text-right" style="width: 90px;">Unit Price</th>
                <th class="text-right" style="width: 100px;">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['items'] as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item['name'] }}</td>
                <td class="text-center">{{ $item['quantity'] }}</td>
                <td class="text-right">${{ number_format($item['price'], 2) }}</td>
                <td class="text-right">${{ number_format($item['quantity'] * $item['price'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="summary-section">
        <tr>
            <td class="terms-col">
                <div class="terms-box">
                    <h4>Terms & Conditions</h4>
                    <ol>
                        <li>Please include PO number on all invoices and correspondence.</li>
                        <li>Deliver goods as per specifications mentioned above.</li>
                        <li>Any deviation from the order must be approved in writing.</li>
                        <li>Invoice will be processed after goods receipt verification.</li>
                    </ol>
                </div>
                <div class="qr-box">
                    <barcode code="PO-{{ $sampleData['po_number'] }}" type="QR" size="0.6" error="M" />
                </div>
            </td>
            <td class="totals-col">
                <table class="totals-table">
                    <tr>
                        <td>Subtotal</td>
                        <td style="text-align: right;">${{ number_format($sampleData['subtotal'], 2) }}</td>
                    </tr>
                    <tr>
                        <td>Shipping</td>
                        <td style="text-align: right;">${{ number_format($sampleData['shipping'], 2) }}</td>
                    </tr>
                    <tr>
                        <td>Tax ({{ $sampleData['tax_percent'] }}%)</td>
                        <td style="text-align: right;">${{ number_format($sampleData['tax'], 2) }}</td>
                    </tr>
                    <tr class="total-row">
                        <td>Grand Total</td>
                        <td style="text-align: right;">${{ number_format($sampleData['total'], 2) }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <div class="authorization">
        <table style="width: 100%;">
            <tr>
                <td style="width: 50%;">
                    <div class="signature-line"></div>
                    <div class="signature-label">Authorized Signature</div>
                </td>
                <td style="width: 50%; text-align: right;">
                    <div class="signature-line" style="margin-left: auto;"></div>
                    <div class="signature-label" style="text-align: right;">Date</div>
                </td>
            </tr>
        </table>
    </div>
@endsection
