@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .quotation-header {
            margin-bottom: 30px;
            border-bottom: 3px solid {{ $company->pdf_header_color ?? '#333' }};
            padding-bottom: 20px;
        }

        .quotation-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 12 : 29 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .quotation-number {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
            color: #666;
            margin-top: 5px;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 19 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            margin-bottom: 15px;
            margin-top: 25px;
        }

        .info-box {
            background-color: #f8f9fa;
            padding: 15px;
            border-left: 4px solid {{ $company->pdf_header_color ?? '#333' }};
            margin-bottom: 20px;
        }

        .info-box p {
            margin: 5px 0;
        }

        .two-column {
            width: 100%;
        }

        .two-column td {
            width: 50%;
            vertical-align: top;
        }

        .details-table {
            width: 100%;
        }

        .details-table td {
            padding: 5px 0;
        }

        .details-table .label {
            color: #666;
            width: 100px;
        }

        .services-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        .services-table th {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 12px 10px;
            text-align: left;
        }

        .services-table td {
            padding: 12px 10px;
            border-bottom: 1px solid #eee;
        }

        .services-table tr:hover {
            background-color: #f5f5f5;
        }

        .services-table .text-right {
            text-align: right;
        }

        .totals-box {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 20px;
            margin-top: 20px;
            width: 300px;
            margin-left: auto;
        }

        .totals-box table {
            width: 100%;
        }

        .totals-box td {
            padding: 8px 0;
        }

        .totals-box .grand-total {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 6 : 23 }}px;
            font-weight: bold;
            border-top: 1px solid rgba(255,255,255,0.3);
            padding-top: 15px;
            margin-top: 10px;
        }

        .validity-box {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            padding: 15px;
            margin-top: 30px;
            text-align: center;
        }

        .terms-section {
            margin-top: 30px;
        }

        .terms-list {
            padding-left: 20px;
        }

        .terms-list li {
            margin-bottom: 8px;
            color: #555;
        }

        .signature-section {
            margin-top: 40px;
        }

        .signature-box {
            border-top: 1px solid #333;
            width: 200px;
            padding-top: 10px;
            text-align: center;
        }

        .qr-section {
            text-align: center;
            margin-top: 20px;
        }

        .acceptance-section {
            margin-top: 30px;
            padding: 20px;
            border: 2px dashed #ddd;
        }
    </style>
@endsection

@section('content')
    <div class="quotation-header">
        <table class="two-column">
            <tr>
                <td>
                    <div class="quotation-title">Quotation</div>
                    <div class="quotation-number">Reference: QT-{{ $sampleData['quotation_number'] }}</div>
                </td>
                <td style="text-align: right;">
                    <barcode code="QT-{{ $sampleData['quotation_number'] }}" type="QR" size="1" error="M" />
                </td>
            </tr>
        </table>
    </div>

    <table class="two-column">
        <tr>
            <td>
                <div class="section-title" style="margin-top: 0;">From</div>
                <div class="info-box">
                    <p><strong>{{ $company->name }}</strong></p>
                    @if($company->address)
                    <p>{{ $company->address }}</p>
                    @endif
                    @if($company->phone)
                    <p>Phone: {{ $company->phone }}</p>
                    @endif
                    @if($company->email)
                    <p>Email: {{ $company->email }}</p>
                    @endif
                </div>
            </td>
            <td>
                <div class="section-title" style="margin-top: 0;">To</div>
                <div class="info-box">
                    <p><strong>{{ $sampleData['customer']['name'] }}</strong></p>
                    <p>{{ $sampleData['customer']['company'] }}</p>
                    <p>{{ $sampleData['customer']['address'] }}</p>
                    <p>Phone: {{ $sampleData['customer']['phone'] }}</p>
                    <p>Email: {{ $sampleData['customer']['email'] }}</p>
                </div>
            </td>
        </tr>
    </table>

    <table class="two-column" style="margin: 20px 0;">
        <tr>
            <td>
                <table class="details-table">
                    <tr>
                        <td class="label">Date:</td>
                        <td><strong>{{ $sampleData['date'] }}</strong></td>
                    </tr>
                    <tr>
                        <td class="label">Valid Until:</td>
                        <td><strong>{{ $sampleData['valid_until'] }}</strong></td>
                    </tr>
                </table>
            </td>
            <td>
                <table class="details-table">
                    <tr>
                        <td class="label">Project:</td>
                        <td><strong>{{ $sampleData['project_name'] }}</strong></td>
                    </tr>
                    <tr>
                        <td class="label">Prepared By:</td>
                        <td><strong>{{ $sampleData['prepared_by'] }}</strong></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <div class="section-title">Services & Products</div>
    <table class="services-table">
        <thead>
            <tr>
                <th style="width: 40px;">#</th>
                <th>Description</th>
                <th class="text-right" style="width: 80px;">Qty</th>
                <th class="text-right" style="width: 100px;">Rate</th>
                <th class="text-right" style="width: 120px;">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['services'] as $index => $service)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>
                    <strong>{{ $service['name'] }}</strong>
                    @if(isset($service['description']))
                    <br><small style="color: #666;">{{ $service['description'] }}</small>
                    @endif
                </td>
                <td class="text-right">{{ $service['quantity'] }}</td>
                <td class="text-right">${{ number_format($service['rate'], 2) }}</td>
                <td class="text-right">${{ number_format($service['quantity'] * $service['rate'], 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals-box">
        <table>
            <tr>
                <td>Subtotal:</td>
                <td style="text-align: right;">${{ number_format($sampleData['subtotal'], 2) }}</td>
            </tr>
            <tr>
                <td>Discount ({{ $sampleData['discount_percent'] }}%):</td>
                <td style="text-align: right;">-${{ number_format($sampleData['discount'], 2) }}</td>
            </tr>
            <tr>
                <td>Tax ({{ $sampleData['tax_percent'] }}%):</td>
                <td style="text-align: right;">${{ number_format($sampleData['tax'], 2) }}</td>
            </tr>
            <tr class="grand-total">
                <td>Total:</td>
                <td style="text-align: right;">${{ number_format($sampleData['total'], 2) }}</td>
            </tr>
        </table>
    </div>

    <div class="validity-box">
        <strong>This quotation is valid for 30 days from the date of issue.</strong>
        <br>Prices are subject to change after the validity period.
    </div>

    <div class="terms-section">
        <div class="section-title">Terms & Conditions</div>
        <ol class="terms-list">
            <li>Payment terms: 50% advance, 50% upon completion.</li>
            <li>Delivery timeline will be confirmed upon order confirmation.</li>
            <li>Prices are exclusive of any additional taxes unless otherwise stated.</li>
            <li>Any changes to the scope of work may result in additional charges.</li>
            <li>This quotation is subject to our standard terms and conditions.</li>
        </ol>
    </div>

    <div class="acceptance-section">
        <div class="section-title" style="margin-top: 0;">Acceptance</div>
        <p>I/We accept the above quotation and agree to the terms and conditions stated.</p>
        <table class="two-column" style="margin-top: 30px;">
            <tr>
                <td>
                    <div class="signature-box">
                        <small>Customer Signature & Date</small>
                    </div>
                </td>
                <td style="text-align: right;">
                    <div class="signature-box" style="margin-left: auto;">
                        <small>Authorized Signature</small>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div style="text-align: center; margin-top: 30px; color: #666; font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 12 }}px;">
        <p>Generated on: {{ now()->format('F d, Y - h:i A') }}</p>
    </div>
@endsection
