@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .receipt-container {
            max-width: 100%;
            margin: 0 auto;
        }

        .receipt-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px dashed {{ $company->pdf_header_color ?? '#333' }};
        }

        .receipt-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 12 : 29 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            text-transform: uppercase;
        }

        .receipt-subtitle {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
            color: #666;
            margin-top: 5px;
        }

        .company-info {
            text-align: center;
            margin-bottom: 20px;
        }

        .company-info h3 {
            margin: 0;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .company-info p {
            margin: 3px 0;
            color: #666;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
        }

        .receipt-info {
            background-color: #f8f9fa;
            padding: 15px;
            margin-bottom: 20px;
        }

        .receipt-info table {
            width: 100%;
        }

        .receipt-info td {
            padding: 5px 10px;
        }

        .receipt-info .label {
            color: #666;
            width: 120px;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 19 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            margin: 20px 0 10px 0;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .items-table th {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 10px;
            text-align: left;
        }

        .items-table td {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }

        .items-table .text-right {
            text-align: right;
        }

        .payment-summary {
            width: 350px;
            margin-left: auto;
        }

        .payment-summary table {
            width: 100%;
        }

        .payment-summary td {
            padding: 8px 0;
        }

        .payment-summary .label {
            color: #666;
        }

        .payment-summary .value {
            text-align: right;
            font-weight: bold;
        }

        .payment-summary .total-row {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 4 : 21 }}px;
            color: {{ $company->pdf_header_color ?? '#333' }};
            border-top: 2px solid {{ $company->pdf_header_color ?? '#333' }};
            padding-top: 10px;
        }

        .paid-stamp {
            text-align: center;
            margin: 30px 0;
        }

        .paid-stamp span {
            display: inline-block;
            padding: 15px 40px;
            border: 3px solid #28a745;
            color: #28a745;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 8 : 25 }}px;
            font-weight: bold;
            text-transform: uppercase;
            transform: rotate(-5deg);
        }

        .payment-method {
            background-color: #e8f5e9;
            border: 1px solid #28a745;
            padding: 15px;
            margin: 20px 0;
        }

        .payment-method table {
            width: 100%;
        }

        .payment-method td {
            padding: 5px;
        }

        .qr-section {
            text-align: center;
            margin: 30px 0;
            padding: 20px;
            border: 1px dashed #ddd;
        }

        .qr-section p {
            margin-top: 10px;
            color: #666;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
        }

        .footer-section {
            margin-top: 30px;
            text-align: center;
            padding-top: 20px;
            border-top: 2px dashed {{ $company->pdf_header_color ?? '#333' }};
        }

        .footer-section p {
            margin: 5px 0;
            color: #666;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
        }

        .two-column {
            width: 100%;
        }

        .two-column td {
            width: 50%;
            vertical-align: top;
        }
    </style>
@endsection

@section('content')
    <div class="receipt-container">
        <div class="receipt-header">
            <div class="receipt-title">Payment Receipt</div>
            <div class="receipt-subtitle">Receipt #{{ $sampleData['receipt_number'] }}</div>
        </div>

        <div class="company-info">
            <h3>{{ $company->name }}</h3>
            @if($company->address)
            <p>{{ $company->address }}</p>
            @endif
            @if($company->phone)
            <p>Phone: {{ $company->phone }}</p>
            @endif
            @if($company->email)
            <p>Email: {{ $company->email }}</p>
            @endif
        </div>

        <div class="receipt-info">
            <table class="two-column">
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td class="label">Date:</td>
                                <td><strong>{{ $sampleData['date'] }}</strong></td>
                            </tr>
                            <tr>
                                <td class="label">Time:</td>
                                <td>{{ $sampleData['time'] }}</td>
                            </tr>
                            <tr>
                                <td class="label">Cashier:</td>
                                <td>{{ $sampleData['cashier'] }}</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table>
                            <tr>
                                <td class="label">Customer:</td>
                                <td><strong>{{ $sampleData['customer']['name'] }}</strong></td>
                            </tr>
                            <tr>
                                <td class="label">Phone:</td>
                                <td>{{ $sampleData['customer']['phone'] }}</td>
                            </tr>
                            <tr>
                                <td class="label">Email:</td>
                                <td>{{ $sampleData['customer']['email'] }}</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <div class="section-title">Items Purchased</div>
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 40px;">#</th>
                    <th>Item Description</th>
                    <th class="text-right" style="width: 60px;">Qty</th>
                    <th class="text-right" style="width: 100px;">Price</th>
                    <th class="text-right" style="width: 100px;">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sampleData['items'] as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item['name'] }}</td>
                    <td class="text-right">{{ $item['quantity'] }}</td>
                    <td class="text-right">${{ number_format($item['price'], 2) }}</td>
                    <td class="text-right">${{ number_format($item['quantity'] * $item['price'], 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="payment-summary">
            <table>
                <tr>
                    <td class="label">Subtotal:</td>
                    <td class="value">${{ number_format($sampleData['subtotal'], 2) }}</td>
                </tr>
                <tr>
                    <td class="label">Tax ({{ $sampleData['tax_percent'] }}%):</td>
                    <td class="value">${{ number_format($sampleData['tax'], 2) }}</td>
                </tr>
                @if(isset($sampleData['discount']) && $sampleData['discount'] > 0)
                <tr>
                    <td class="label">Discount:</td>
                    <td class="value">-${{ number_format($sampleData['discount'], 2) }}</td>
                </tr>
                @endif
                <tr class="total-row">
                    <td class="label">Total Paid:</td>
                    <td class="value">${{ number_format($sampleData['total'], 2) }}</td>
                </tr>
            </table>
        </div>

        <div class="paid-stamp">
            <span>PAID</span>
        </div>

        <div class="payment-method">
            <table class="two-column">
                <tr>
                    <td>
                        <strong>Payment Method:</strong> {{ $sampleData['payment_method'] }}
                    </td>
                    <td style="text-align: right;">
                        <strong>Transaction ID:</strong> {{ $sampleData['transaction_id'] }}
                    </td>
                </tr>
            </table>
        </div>

        <div class="qr-section">
            <barcode code="RCP-{{ $sampleData['receipt_number'] }}" type="QR" size="1.2" error="M" />
            <p>Scan to verify this receipt</p>
        </div>

        <div class="footer-section">
            <p><strong>Thank you for your purchase!</strong></p>
            <p>Please keep this receipt for your records.</p>
            <p>For returns or exchanges, please present this receipt within 30 days.</p>
            <p style="margin-top: 15px; font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 12 }}px;">Generated on: {{ now()->format('F d, Y - h:i A') }}</p>
        </div>
    </div>
@endsection
