@extends('layouts.pdf-sample')

@section('styles')
    <style>
        .report-header {
            margin-bottom: 30px;
            border-bottom: 3px solid {{ $company->pdf_header_color ?? '#333' }};
            padding-bottom: 20px;
        }

        .report-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 10 : 27 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .report-subtitle {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size : 17 }}px;
            color: #666;
            margin-top: 5px;
        }

        .report-meta {
            margin-top: 10px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
            color: #888;
        }

        .section-title {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 2 : 19 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
            margin-top: 25px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 1px solid #ddd;
        }

        .summary-cards {
            width: 100%;
            margin-bottom: 25px;
        }

        .summary-cards td {
            width: 25%;
            padding: 5px;
        }

        .summary-card {
            background-color: #f8f9fa;
            padding: 15px;
            text-align: center;
            border-left: 4px solid {{ $company->pdf_header_color ?? '#333' }};
        }

        .summary-card.success {
            border-left-color: #28a745;
        }

        .summary-card.warning {
            border-left-color: #ffc107;
        }

        .summary-card.danger {
            border-left-color: #dc3545;
        }

        .summary-card.info {
            border-left-color: #17a2b8;
        }

        .summary-card .value {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size + 8 : 25 }}px;
            font-weight: bold;
            color: {{ $company->pdf_header_color ?? '#333' }};
        }

        .summary-card .label {
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
            color: #666;
            margin-top: 5px;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .data-table th {
            background-color: {{ $company->pdf_header_color ?? '#333' }};
            color: white;
            padding: 10px;
            text-align: left;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 16 }}px;
        }

        .data-table td {
            padding: 10px;
            border-bottom: 1px solid #eee;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 1 : 16 }}px;
        }

        .data-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .data-table .text-right {
            text-align: right;
        }

        .data-table .text-center {
            text-align: center;
        }

        .status-badge {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 3px;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 12 }}px;
            font-weight: bold;
        }

        .status-completed {
            background-color: #d4edda;
            color: #155724;
        }

        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }

        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
        }

        .two-column {
            width: 100%;
        }

        .two-column td {
            width: 50%;
            vertical-align: top;
            padding: 10px;
        }

        .chart-placeholder {
            background-color: #f8f9fa;
            border: 1px dashed #ddd;
            padding: 40px;
            text-align: center;
            color: #666;
        }

        .insights-box {
            background-color: #e7f3ff;
            border-left: 4px solid #0066cc;
            padding: 15px;
            margin: 20px 0;
        }

        .insights-box h4 {
            color: #0066cc;
            margin: 0 0 10px 0;
        }

        .insights-box ul {
            margin: 0;
            padding-left: 20px;
        }

        .insights-box li {
            margin-bottom: 5px;
        }

        .footer-section {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: {{ $company->pdf_font_size ? $company->pdf_font_size - 2 : 15 }}px;
        }

        .qr-section {
            text-align: right;
            margin-bottom: 20px;
        }

        .trend-up {
            color: #28a745;
        }

        .trend-down {
            color: #dc3545;
        }
    </style>
@endsection

@section('content')
    <table class="two-column" style="margin-bottom: 0;">
        <tr>
            <td style="padding: 0;">
                <div class="report-header" style="border-bottom: none; margin-bottom: 0; padding-bottom: 0;">
                    <div class="report-title">{{ $sampleData['report_title'] }}</div>
                    <div class="report-subtitle">{{ $company->name }}</div>
                    <div class="report-meta">
                        Report Period: {{ $sampleData['period_start'] }} - {{ $sampleData['period_end'] }}
                        <br>Generated by: {{ $sampleData['generated_by'] }}
                    </div>
                </div>
            </td>
            <td style="text-align: right; padding: 0;">
                <div class="qr-section">
                    <barcode code="RPT-{{ $sampleData['report_id'] }}" type="QR" size="1" error="M" />
                </div>
            </td>
        </tr>
    </table>
    <div style="border-bottom: 3px solid {{ $company->pdf_header_color ?? '#333' }}; margin-bottom: 20px;"></div>

    <div class="section-title" style="margin-top: 0;">Executive Summary</div>
    <table class="summary-cards">
        <tr>
            <td>
                <div class="summary-card success">
                    <div class="value">${{ number_format($sampleData['total_revenue'], 0) }}</div>
                    <div class="label">Total Revenue</div>
                </div>
            </td>
            <td>
                <div class="summary-card info">
                    <div class="value">{{ $sampleData['total_orders'] }}</div>
                    <div class="label">Total Orders</div>
                </div>
            </td>
            <td>
                <div class="summary-card warning">
                    <div class="value">{{ $sampleData['new_customers'] }}</div>
                    <div class="label">New Customers</div>
                </div>
            </td>
            <td>
                <div class="summary-card">
                    <div class="value">{{ $sampleData['avg_order_value'] }}</div>
                    <div class="label">Avg Order Value</div>
                </div>
            </td>
        </tr>
    </table>

    <div class="insights-box">
        <h4>Key Insights</h4>
        <ul>
            @foreach($sampleData['insights'] as $insight)
            <li>{{ $insight }}</li>
            @endforeach
        </ul>
    </div>

    <div class="section-title">Top Performing Products</div>
    <table class="data-table">
        <thead>
            <tr>
                <th style="width: 40px;">#</th>
                <th>Product Name</th>
                <th class="text-center">Units Sold</th>
                <th class="text-right">Revenue</th>
                <th class="text-center">Trend</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['top_products'] as $index => $product)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $product['name'] }}</td>
                <td class="text-center">{{ $product['units'] }}</td>
                <td class="text-right">${{ number_format($product['revenue'], 2) }}</td>
                <td class="text-center">
                    @if($product['trend'] > 0)
                    <span class="trend-up">+{{ $product['trend'] }}%</span>
                    @else
                    <span class="trend-down">{{ $product['trend'] }}%</span>
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="section-title">Recent Orders</div>
    <table class="data-table">
        <thead>
            <tr>
                <th>Order ID</th>
                <th>Customer</th>
                <th>Date</th>
                <th class="text-right">Amount</th>
                <th class="text-center">Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sampleData['recent_orders'] as $order)
            <tr>
                <td>#{{ $order['id'] }}</td>
                <td>{{ $order['customer'] }}</td>
                <td>{{ $order['date'] }}</td>
                <td class="text-right">${{ number_format($order['amount'], 2) }}</td>
                <td class="text-center">
                    @if($order['status'] == 'Completed')
                    <span class="status-badge status-completed">{{ $order['status'] }}</span>
                    @elseif($order['status'] == 'Pending')
                    <span class="status-badge status-pending">{{ $order['status'] }}</span>
                    @else
                    <span class="status-badge status-cancelled">{{ $order['status'] }}</span>
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="two-column">
        <tr>
            <td>
                <div class="section-title">Revenue by Category</div>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Category</th>
                            <th class="text-right">Revenue</th>
                            <th class="text-right">%</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sampleData['revenue_by_category'] as $category)
                        <tr>
                            <td>{{ $category['name'] }}</td>
                            <td class="text-right">${{ number_format($category['revenue'], 2) }}</td>
                            <td class="text-right">{{ $category['percentage'] }}%</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </td>
            <td>
                <div class="section-title">Sales by Region</div>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Region</th>
                            <th class="text-right">Sales</th>
                            <th class="text-right">%</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sampleData['sales_by_region'] as $region)
                        <tr>
                            <td>{{ $region['name'] }}</td>
                            <td class="text-right">${{ number_format($region['sales'], 2) }}</td>
                            <td class="text-right">{{ $region['percentage'] }}%</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </td>
        </tr>
    </table>

    <div class="footer-section">
        <p><strong>{{ $company->name }}</strong> - Confidential Business Report</p>
        <p>This report is auto-generated. For questions, contact {{ $company->email ?? 'reports@company.com' }}</p>
        <p style="margin-top: 10px;">Generated on: {{ now()->format('F d, Y - h:i A') }}</p>
    </div>
@endsection
