<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->items = $items;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'About Us',
            'title' => 'Your Trusted Partner for Quality Service',
            'subtitle' => 'We\'ve been delivering excellence since 2010',
            'description' => 'We are dedicated to providing exceptional service with a commitment to quality, reliability, and customer satisfaction. Our team of experienced professionals works tirelessly to exceed your expectations.',
            'image' => 'https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=600&h=400&fit=crop',
            'show_stats' => true,
            'years_experience' => '15+',
            'happy_customers' => '10,000+',
            'projects_completed' => '5,000+',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="about" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            {{-- Image Column --}}
            @if(!empty($section['image']))
            <div class="scroll-animate" data-animation="fade-right">
                <div class="about-image-wrapper relative z-10">
                    <img src="{{ $section['image'] }}" alt="{{ $section['title'] }}" class="rounded-xl shadow-2xl w-full h-auto object-cover">
                </div>
            </div>
            @endif

            {{-- Content Column --}}
            <div class="scroll-animate {{ !empty($section['image']) ? '' : 'lg:col-span-2 max-w-3xl mx-auto text-center' }}" data-animation="fade-left">
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                <h2 class="section-title text-left {{ !empty($section['image']) ? '' : '!text-center' }}">
                    {{ $section['title'] }}
                </h2>

                @if(!empty($section['subtitle']))
                <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-4">
                    {{ $section['subtitle'] }}
                </p>
                @endif

                @if(!empty($section['description']))
                <div class="prose prose-lg dark:prose-invert max-w-none text-gray-600 dark:text-gray-300 mb-8">
                    {!! $section['description'] !!}
                </div>
                @endif

                {{-- Stats --}}
                @if(!empty($section['show_stats']))
                <div class="grid grid-cols-3 gap-4 mt-8">
                    @if(!empty($section['years_experience']))
                    <div class="about-stat-card bg-white dark:bg-gray-800 rounded-xl p-4 text-center shadow-lg border border-gray-100 dark:border-gray-700">
                        <div class="text-2xl md:text-3xl font-bold text-primary-600 dark:text-primary-400">
                            {{ $section['years_experience'] }}
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">{{ __('Years Experience') }}</div>
                    </div>
                    @endif
                    @if(!empty($section['happy_customers']))
                    <div class="about-stat-card bg-white dark:bg-gray-800 rounded-xl p-4 text-center shadow-lg border border-gray-100 dark:border-gray-700">
                        <div class="text-2xl md:text-3xl font-bold text-primary-600 dark:text-primary-400">
                            {{ $section['happy_customers'] }}
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">{{ __('Happy Customers') }}</div>
                    </div>
                    @endif
                    @if(!empty($section['projects_completed']))
                    <div class="about-stat-card bg-white dark:bg-gray-800 rounded-xl p-4 text-center shadow-lg border border-gray-100 dark:border-gray-700">
                        <div class="text-2xl md:text-3xl font-bold text-primary-600 dark:text-primary-400">
                            {{ $section['projects_completed'] }}
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">{{ __('Projects Done') }}</div>
                    </div>
                    @endif
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<style>
    .about-image-wrapper {
        position: relative;
    }
    .about-image-wrapper::before {
        content: '';
        position: absolute;
        top: 1rem;
        left: 1rem;
        right: -1rem;
        bottom: -1rem;
        border: 3px solid var(--color-primary-500);
        border-radius: 0.75rem;
        z-index: -1;
    }
    [dir="rtl"] .about-image-wrapper::before {
        left: -1rem;
        right: 1rem;
    }
    .about-stat-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .about-stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
    }
</style>
</div>
