<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultFeatures = [['icon' => 'heroicons:bolt', 'title' => 'Fast & Easy', 'description' => 'Book services in just a few taps'], ['icon' => 'heroicons:bell-alert', 'title' => 'Real-time Updates', 'description' => 'Track your order status live'], ['icon' => 'heroicons:shield-check', 'title' => 'Secure Payments', 'description' => 'Multiple payment options available'], ['icon' => 'heroicons:gift', 'title' => 'Exclusive Offers', 'description' => 'App-only deals and discounts']];

        $this->section = array_merge(
            [
                'badge' => 'Mobile App',
                'title' => 'Download Our App Today',
                'subtitle' => 'Experience convenience at your fingertips',
                'description' => 'Get instant access to all our services right from your smartphone. Available on iOS and Android.',
                'app_image_url' => 'https://www.expertappdevs.com/sitebucket/portfolio/20220329062908-about-image-001.png',
                'cta_buttons' => [['icon' => 'mdi:apple', 'url' => '#', 'text_top' => 'Download on the', 'text_main' => 'App Store'], ['icon' => 'mdi:google-play', 'url' => '#', 'text_top' => 'Get it on', 'text_main' => 'Google Play']],
                'qr_code' => null,
                'qr_label' => 'Scan to Download',
                'qr_description' => 'Point your camera at the QR code to download the app instantly',
                'app_stats' => [['icon' => 'lucide:download', 'value' => '500K+', 'label' => 'Downloads'], ['icon' => 'lucide:star', 'value' => '4.8', 'label' => 'App Rating'], ['icon' => 'lucide:users', 'value' => '100K+', 'label' => 'Happy Users']],
                'trusted_users' => [
                    'enabled' => true,
                    'title' => 'Trusted by %count% users',
                    'subtitle' => 'Join thousands of satisfied customers',
                    'avatars' => [],
                ],
                'features' => [],
            ],
            $section,
        );

        $features = $this->section['features'] ?? ($items ?? $defaultFeatures);

        $this->items = array_map(function ($feature) {
            return [
                'icon' => $feature['icon'] ?? 'heroicons:check',
                'title' => $feature['title'] ?? ($feature['text'] ?? ''),
                'description' => $feature['description'] ?? '',
            ];
        }, $features);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Centered Section */
        .app-centered-section {
            position: relative;
            overflow: hidden;
        }

        /* Decorative Ring */
        .app-deco-ring {
            position: absolute;
            border: 2px solid;
            border-radius: 50%;
            opacity: 0.1;
        }

        .app-deco-ring-1 {
            width: 400px;
            height: 400px;
            top: -100px;
            left: -100px;
            border-color: var(--color-primary-500);
        }

        .app-deco-ring-2 {
            width: 300px;
            height: 300px;
            bottom: -50px;
            right: -50px;
            border-color: var(--color-secondary-500);
        }

        .app-deco-ring-3 {
            width: 200px;
            height: 200px;
            top: 40%;
            right: 10%;
            border-color: var(--color-primary-400);
            border-style: dashed;
        }

        /* Dot Pattern */
        .app-dot-pattern {
            position: absolute;
            width: 150px;
            height: 150px;
            background-image: radial-gradient(circle, var(--color-primary-300) 1.5px, transparent 1.5px);
            background-size: 20px 20px;
            opacity: 0.3;
        }

        .dark .app-dot-pattern {
            opacity: 0.15;
        }

        .app-dot-pattern-1 {
            top: 10%;
            right: 5%;
        }

        .app-dot-pattern-2 {
            bottom: 10%;
            left: 5%;
        }

        /* Phone Container */
        .app-phone-container {
            position: relative;
            display: inline-block;
        }

        /* Phone Shadow Ring */
        .app-phone-shadow {
            position: absolute;
            inset: -20px;
            background: linear-gradient(180deg, var(--color-primary-200) 0%, transparent 100%);
            border-radius: 50%;
            opacity: 0.5;
            filter: blur(40px);
        }

        .dark .app-phone-shadow {
            background: linear-gradient(180deg, var(--color-primary-800) 0%, transparent 100%);
            opacity: 0.3;
        }

        /* Phone Mockup */
        .app-centered-mockup {
            position: relative;
            z-index: 1;
            transition: transform 0.5s ease;
        }

        .app-centered-mockup:hover {
            transform: translateY(-10px);
        }

        /* Store Buttons */
        .store-btn-primary {
            background: var(--color-primary-600);
            color: white;
            transition: all 0.3s ease;
        }

        .store-btn-primary:hover {
            background: var(--color-primary-700);
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -5px rgba(var(--color-primary-500-rgb), 0.4);
        }

        .store-btn-secondary {
            background: var(--color-secondary-600);
            color: white;
            transition: all 0.3s ease;
        }

        .store-btn-secondary:hover {
            background: var(--color-secondary-700);
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -5px rgba(var(--color-secondary-500-rgb), 0.4);
        }

        /* Feature Card */
        .app-feature-card {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            padding: 1.25rem 1rem;
            background: white;
            border: 1px solid var(--color-gray-200);
            border-radius: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .dark .app-feature-card {
            background: #1f2937 !important;
            border-color: #374151 !important;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .app-feature-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }

        .dark .app-feature-card:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .app-feature-icon-box {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            border-radius: 12px;
            margin-bottom: 0.75rem;
            box-shadow: 0 4px 12px rgba(var(--color-primary-500-rgb), 0.3);
        }

        .dark .app-feature-icon-box {
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700)) !important;
            box-shadow: 0 4px 12px rgba(var(--color-primary-500-rgb), 0.2);
        }

        .app-feature-icon {
            width: 24px;
            height: 24px;
            color: #ffffff !important;
        }

        .dark .app-feature-icon {
            color: #ffffff !important;
        }

        .app-feature-title {
            font-weight: 600;
            font-size: 0.9375rem;
            color: #111827;
            margin-bottom: 0.25rem;
        }

        .dark .app-feature-title {
            color: #ffffff !important;
        }

        .app-feature-desc {
            font-size: 0.8125rem;
            color: #6b7280;
            line-height: 1.4;
        }

        .dark .app-feature-desc {
            color: #9ca3af !important;
        }

        /* QR Code */
        .app-centered-qr {
            display: inline-flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem 1.5rem;
            background: white;
            border-radius: 16px;
            border: 1px solid var(--color-gray-200);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }

        .dark .app-centered-qr {
            background: #1f2937 !important;
            border-color: #374151 !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .app-centered-qr-image {
            background: white;
            padding: 6px;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .app-centered-qr-title {
            font-weight: 600;
            font-size: 0.9375rem;
            color: #111827;
        }

        .dark .app-centered-qr-title {
            color: #ffffff !important;
        }

        .app-centered-qr-desc {
            font-size: 0.8125rem;
            color: #6b7280;
        }

        .dark .app-centered-qr-desc {
            color: #9ca3af !important;
        }

        /* Trusted Users */
        .app-centered-trusted {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1.25rem;
            background: white;
            border-radius: 50px;
            border: 1px solid var(--color-gray-200);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }

        .dark .app-centered-trusted {
            background: #1f2937 !important;
            border-color: #374151 !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .app-centered-trusted-text {
            font-size: 0.875rem;
            font-weight: 500;
            color: #111827;
        }

        .dark .app-centered-trusted-text {
            color: #ffffff !important;
        }

        .app-centered-trusted-sub {
            font-size: 0.75rem;
            color: #6b7280;
        }

        .dark .app-centered-trusted-sub {
            color: #9ca3af !important;
        }

        /* Stats */
        .app-stat-box {
            text-align: center;
            padding: 1rem;
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            border: 1px solid var(--color-gray-100);
            transition: all 0.3s ease;
        }

        .dark .app-stat-box {
            background: #1f2937 !important;
            border-color: #374151 !important;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        }

        .app-stat-box:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
        }

        .dark .app-stat-box:hover {
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3);
        }

        .app-stat-value {
            color: #111827;
        }

        .dark .app-stat-value {
            color: #ffffff !important;
        }

        .app-stat-label {
            color: #6b7280;
        }

        .dark .app-stat-label {
            color: #9ca3af !important;
        }
    </style>


    <section id="app-download"
        class="app-centered-section section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Decorative Elements --}}
        <div class="app-deco-ring app-deco-ring-1"></div>
        <div class="app-deco-ring app-deco-ring-2"></div>
        <div class="app-deco-ring app-deco-ring-3"></div>
        <div class="app-dot-pattern app-dot-pattern-1"></div>
        <div class="app-dot-pattern app-dot-pattern-2"></div>

        <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            {{-- Header --}}
            <div class="scroll-animate mb-8" data-animation="fade-up">
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                <h2 class="section-title">{{ $section['title'] }}</h2>

                @if (!empty($section['subtitle']))
                    <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-3">
                        {{ $section['subtitle'] }}
                    </p>
                @endif

                @if (!empty($section['description']))
                    <p class="text-gray-600 dark:text-gray-300 max-w-2xl mx-auto mb-6">
                        {!! strip_tags($section['description']) !!}
                    </p>
                @endif
            </div>

            {{-- Phone Mockup --}}
            <div class="scroll-animate mb-8" data-animation="fade-up">
                @php $appImageUrl = $section['app_image_url'] ?? $section['app_image'] ?? null; @endphp
                <div class="app-phone-container mx-auto">
                    <div class="app-phone-shadow"></div>
                    @if ($appImageUrl)
                        <div class="app-centered-mockup">
                            <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}"
                                class="max-w-[200px] sm:max-w-[240px] w-full h-auto drop-shadow-2xl rounded-3xl mx-auto"
                                loading="lazy">
                        </div>
                    @else
                        <div
                            class="app-centered-mockup bg-gradient-to-br from-primary-500 to-primary-700 rounded-[2rem] p-3 max-w-[200px] sm:max-w-[240px] mx-auto shadow-2xl">
                            <div
                                class="bg-white dark:bg-gray-800 rounded-[1.5rem] aspect-[9/19] flex items-center justify-center">
                                <x-icon icon="heroicons:device-phone-mobile"
                                    class="w-12 h-12 text-gray-300 dark:text-gray-600" />
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Download Buttons --}}
            @php
                $ctaButtons = $section['cta_buttons'] ?? [];
                if (empty($ctaButtons) && (!empty($section['app_store_url']) || !empty($section['play_store_url']))) {
                    $ctaButtons = [];
                    if (!empty($section['app_store_url'])) {
                        $ctaButtons[] = [
                            'icon' => 'mdi:apple',
                            'url' => $section['app_store_url'],
                            'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                            'text_main' => $section['app_store_text_main'] ?? 'App Store',
                        ];
                    }
                    if (!empty($section['play_store_url'])) {
                        $ctaButtons[] = [
                            'icon' => 'mdi:google-play',
                            'url' => $section['play_store_url'],
                            'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                            'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                        ];
                    }
                }
            @endphp
            @if (count($ctaButtons) > 0)
                <div class="scroll-animate flex flex-wrap justify-center gap-4 mb-8" data-animation="fade-up">
                    @foreach ($ctaButtons as $index => $button)
                        @if (!empty($button['url']))
                            <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                class="{{ $index === 0 ? 'store-btn-primary' : 'store-btn-secondary' }} inline-flex items-center gap-3 px-5 py-3 rounded-xl shadow-lg">
                                <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                    class="w-7 h-7" />
                                <div class="text-left">
                                    <div class="text-xs opacity-80">{{ $button['text_top'] ?? '' }}</div>
                                    <div class="text-base font-semibold -mt-0.5">{{ $button['text_main'] ?? '' }}</div>
                                </div>
                            </a>
                        @endif
                    @endforeach
                </div>
            @endif

            {{-- Features as Cards --}}
            @if (count($items) > 0)
                <div class="scroll-animate grid grid-cols-2 sm:grid-cols-4 gap-4 mb-8 max-w-3xl mx-auto"
                    data-animation="fade-up">
                    @foreach ($items as $feature)
                        <div class="app-feature-card">
                            <div class="app-feature-icon-box">
                                <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}" class="app-feature-icon" />
                            </div>
                            <div class="app-feature-title">{{ $feature['title'] ?? '' }}</div>
                            @if (!empty($feature['description']))
                                <div class="app-feature-desc">{{ $feature['description'] }}</div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif

            {{-- Stats --}}
            @php $appStats = $section['app_stats'] ?? []; @endphp
            @if (count($appStats) > 0)
                <div class="scroll-animate grid grid-cols-{{ count($appStats) }} gap-4 max-w-lg mx-auto mb-8"
                    data-animation="fade-up">
                    @foreach ($appStats as $stat)
                        <div class="app-stat-box">
                            <div class="flex items-center justify-center gap-1 mb-1">
                                @if (!empty($stat['icon']))
                                    <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5 text-primary-500" />
                                @endif
                                <span class="app-stat-value text-xl font-bold">{{ $stat['value'] ?? '' }}</span>
                            </div>
                            <div class="app-stat-label text-xs">{{ $stat['label'] ?? '' }}</div>
                        </div>
                    @endforeach
                </div>
            @endif

            {{-- Trusted Users --}}
            @php
                $trustedUsers = $section['trusted_users'] ?? [];
                $trustedUsersEnabled = $trustedUsers['enabled'] ?? false;
                $userAvatars = $trustedUsers['avatars'] ?? [];
                $trustedUsersCount = count($userAvatars) > 0 ? number_format(count($userAvatars) * 1000) : '10,000+';
                $trustedTitle = $trustedUsers['title'] ?? 'Trusted by %count% users';
                $trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
                $trustedSubtitle = $trustedUsers['subtitle'] ?? 'Join thousands of satisfied customers';
            @endphp
            @if ($trustedUsersEnabled)
                <div class="scroll-animate flex justify-center mb-8" data-animation="fade-up">
                    <div class="app-centered-trusted">
                        {{-- Avatar Stack --}}
                        @if (count($userAvatars) > 0)
                            <div class="flex -space-x-2">
                                @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                    @php
                                        $avatarUrl = is_array($avatar)
                                            ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                            : $avatar;
                                        $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                    @endphp
                                    @if ($avatarUrl)
                                        <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                            title="{{ $avatarName }}"
                                            class="w-8 h-8 rounded-full border-2 border-white dark:border-gray-700 object-cover"
                                            loading="lazy">
                                    @endif
                                @endforeach
                            </div>
                        @endif

                        {{-- Trusted Text --}}
                        <div class="text-left">
                            <p class="app-centered-trusted-text">{{ $trustedTitle }}</p>
                            <p class="app-centered-trusted-sub">{{ $trustedSubtitle }}</p>
                        </div>
                    </div>
                </div>
            @endif

            {{-- QR Code --}}
            @php $qrCodeUrl = $section['qr_code_url'] ?? $section['qr_code'] ?? null; @endphp
            @if ($qrCodeUrl)
                <div class="scroll-animate flex justify-center" data-animation="fade-up">
                    <div class="app-centered-qr">
                        <div class="app-centered-qr-image flex-shrink-0">
                            <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-16 h-16 object-contain"
                                loading="lazy">
                        </div>
                        <div class="text-left">
                            <p class="app-centered-qr-title">{{ $section['qr_label'] ?? 'Scan to Download' }}</p>
                            <p class="app-centered-qr-desc">
                                {{ $section['qr_description'] ?? 'Point your camera at the QR code' }}</p>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
</div>
