<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default app features
        $defaultFeatures = [['icon' => 'heroicons:bolt', 'title' => 'Fast & Easy', 'description' => 'Book services in just a few taps'], ['icon' => 'heroicons:bell-alert', 'title' => 'Real-time Updates', 'description' => 'Track your order status live'], ['icon' => 'heroicons:shield-check', 'title' => 'Secure Payments', 'description' => 'Multiple payment options available'], ['icon' => 'heroicons:gift', 'title' => 'Exclusive Offers', 'description' => 'App-only deals and discounts']];

        $this->section = array_merge(
            [
                'badge' => 'Mobile App',
                'title' => 'Download Our App Today',
                'subtitle' => 'Experience convenience at your fingertips',
                'description' => 'Get instant access to all our services right from your smartphone. Available on iOS and Android.',
                'app_image_url' => 'https://www.expertappdevs.com/sitebucket/portfolio/20220329062908-about-image-001.png',
                'cta_buttons' => [['icon' => 'mdi:apple', 'url' => '#', 'text_top' => 'Download on the', 'text_main' => 'App Store'], ['icon' => 'mdi:google-play', 'url' => '#', 'text_top' => 'Get it on', 'text_main' => 'Google Play']],
                'qr_code' => null,
                'qr_label' => 'Scan to Download',
                'qr_description' => 'Point your camera at the QR code to download the app instantly',
                'app_stats' => [['icon' => 'lucide:download', 'value' => '500K+', 'label' => 'Downloads'], ['icon' => 'lucide:star', 'value' => '4.8', 'label' => 'App Rating'], ['icon' => 'lucide:users', 'value' => '100K+', 'label' => 'Happy Users']],
                'trusted_users' => [
                    'enabled' => true,
                    'title' => 'Trusted by %count% users',
                    'subtitle' => 'Join thousands of satisfied customers',
                    'avatars' => [],
                ],
                'features' => [],
            ],
            $section,
        );

        // Get features from section content or use items parameter or use defaults
        // Features can come from: section['features'], $items parameter, or defaults
        $features = $this->section['features'] ?? ($items ?? $defaultFeatures);

        // Normalize features - map 'text' to 'title' if needed (for database format compatibility)
        $this->items = array_map(function ($feature) {
            return [
                'icon' => $feature['icon'] ?? 'heroicons:check',
                'title' => $feature['title'] ?? ($feature['text'] ?? ''),
                'description' => $feature['description'] ?? '',
            ];
        }, $features);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Modern App Download Section Styles */
        .app-download-section {
            position: relative;
            overflow: hidden;
        }

        /* Gradient Mesh Background */
        .app-download-bg {
            position: absolute;
            inset: 0;
            background:
                radial-gradient(ellipse 80% 50% at 20% 40%, rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.15) 0%, transparent 50%),
                radial-gradient(ellipse 60% 40% at 80% 60%, rgba(var(--color-secondary-500-rgb, 168, 85, 247), 0.12) 0%, transparent 50%);
            pointer-events: none;
        }

        .dark .app-download-bg {
            background:
                radial-gradient(ellipse 80% 50% at 20% 40%, rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.1) 0%, transparent 50%),
                radial-gradient(ellipse 60% 40% at 80% 60%, rgba(var(--color-secondary-500-rgb, 168, 85, 247), 0.08) 0%, transparent 50%);
        }

        /* Floating Shapes */
        .app-floating-shapes {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }

        .app-shape {
            position: absolute;
            border-radius: 50%;
            opacity: 0.6;
            animation: float-shape 20s ease-in-out infinite;
        }

        .app-shape-1 {
            width: 300px;
            height: 300px;
            background: linear-gradient(135deg, rgba(var(--color-primary-400-rgb, 129, 140, 248), 0.2), rgba(var(--color-primary-600-rgb, 79, 70, 229), 0.1));
            top: -100px;
            right: -50px;
            animation-delay: 0s;
            filter: blur(40px);
        }

        .app-shape-2 {
            width: 200px;
            height: 200px;
            background: linear-gradient(135deg, rgba(var(--color-secondary-400-rgb, 192, 132, 252), 0.15), rgba(var(--color-secondary-600-rgb, 147, 51, 234), 0.08));
            bottom: -50px;
            left: 10%;
            animation-delay: -5s;
            filter: blur(30px);
        }

        .app-shape-3 {
            width: 150px;
            height: 150px;
            background: linear-gradient(135deg, rgba(var(--color-primary-300-rgb, 165, 180, 252), 0.2), transparent);
            top: 40%;
            left: -30px;
            animation-delay: -10s;
            filter: blur(25px);
        }

        @keyframes float-shape {

            0%,
            100% {
                transform: translate(0, 0) rotate(0deg);
            }

            25% {
                transform: translate(10px, -20px) rotate(5deg);
            }

            50% {
                transform: translate(-5px, 10px) rotate(-3deg);
            }

            75% {
                transform: translate(15px, 5px) rotate(3deg);
            }
        }

        /* Grid Pattern Overlay */
        .app-grid-pattern {
            position: absolute;
            inset: 0;
            background-image:
                linear-gradient(rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.03) 1px, transparent 1px);
            background-size: 40px 40px;
            pointer-events: none;
        }

        .dark .app-grid-pattern {
            background-image:
                linear-gradient(rgba(255, 255, 255, 0.02) 1px, transparent 1px),
                linear-gradient(90deg, rgba(255, 255, 255, 0.02) 1px, transparent 1px);
        }

        /* Decorative Dots */
        .app-dots-pattern {
            position: absolute;
            width: 120px;
            height: 120px;
            background-image: radial-gradient(circle, rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.3) 2px, transparent 2px);
            background-size: 16px 16px;
            opacity: 0.5;
        }

        .app-dots-1 {
            top: 20%;
            right: 5%;
        }

        .app-dots-2 {
            bottom: 15%;
            left: 3%;
            transform: rotate(45deg);
        }

        /* Phone Mockup Container */
        .app-mockup-container {
            position: relative;
        }

        /* Glow Ring Behind Phone */
        .app-mockup-glow {
            position: absolute;
            inset: -20px;
            background: conic-gradient(from 0deg,
                    rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.3),
                    rgba(var(--color-secondary-500-rgb, 168, 85, 247), 0.2),
                    rgba(var(--color-primary-400-rgb, 129, 140, 248), 0.3),
                    rgba(var(--color-secondary-400-rgb, 192, 132, 252), 0.2),
                    rgba(var(--color-primary-500-rgb, 99, 102, 241), 0.3));
            border-radius: 50%;
            filter: blur(60px);
            opacity: 0.6;
            animation: glow-rotate 10s linear infinite;
        }

        @keyframes glow-rotate {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        .app-mockup {
            position: relative;
            z-index: 1;
            transform: perspective(1000px) rotateY(-5deg);
            transition: transform 0.5s ease;
        }

        .app-mockup:hover {
            transform: perspective(1000px) rotateY(0deg) scale(1.02);
        }

        [dir="rtl"] .app-mockup {
            transform: perspective(1000px) rotateY(5deg);
        }

        [dir="rtl"] .app-mockup:hover {
            transform: perspective(1000px) rotateY(0deg) scale(1.02);
        }

        /* Floating Elements Around Phone */
        .app-floating-elements {
            position: absolute;
            inset: -40px;
            pointer-events: none;
        }

        .app-float-icon {
            position: absolute;
            width: 48px;
            height: 48px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1), 0 0 0 1px rgba(255, 255, 255, 0.1);
            animation: float-icon 4s ease-in-out infinite;
            backdrop-filter: blur(10px);
        }

        .dark .app-float-icon {
            background: rgba(31, 41, 55, 0.9);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3), 0 0 0 1px rgba(255, 255, 255, 0.05);
        }

        .app-float-icon-1 {
            top: 15%;
            right: -20px;
            animation-delay: 0s;
        }

        .app-float-icon-2 {
            bottom: 25%;
            left: -25px;
            animation-delay: -1.5s;
        }

        .app-float-icon-3 {
            top: 50%;
            right: -30px;
            animation-delay: -3s;
        }

        @keyframes float-icon {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        /* Glassmorphism Card for Stats */
        .app-stats-card {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 16px;
            padding: 1rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
        }

        .dark .app-stats-card {
            background: rgba(31, 41, 55, 0.7);
            border-color: rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
        }

        /* Store Buttons with Gradient Border */
        .store-button {
            position: relative;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            overflow: hidden;
        }

        .store-button::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), transparent);
            pointer-events: none;
        }

        .store-button:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 15px 30px -5px rgba(0, 0, 0, 0.25);
        }

        .store-button-primary {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-700));
            color: white;
        }

        .store-button-primary:hover {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-600));
        }

        .store-button-secondary {
            background: linear-gradient(135deg, var(--color-secondary-500), var(--color-secondary-700));
            color: white;
        }

        .store-button-secondary:hover {
            background: linear-gradient(135deg, var(--color-secondary-400), var(--color-secondary-600));
        }

        /* Feature Icon */
        .app-feature-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .app-feature-icon svg {
            color: white;
        }

        /* QR Code Card */
        .qr-code-simple {
            background: white;
            border-radius: 12px;
            padding: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        .dark .qr-code-simple {
            background: #ffffff;
            border-color: rgba(0, 0, 0, 0.1);
        }

        /* Decorative Line */
        .app-decorative-line {
            position: relative;
            width: 60px;
            height: 4px;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            border-radius: 2px;
            margin-bottom: 0.75rem;
        }
    </style>

    <section id="app-download"
        class="app-download-section section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Decorations --}}
        <div class="app-download-bg"></div>
        <div class="app-grid-pattern"></div>
        <div class="app-floating-shapes">
            <div class="app-shape app-shape-1"></div>
            <div class="app-shape app-shape-2"></div>
            <div class="app-shape app-shape-3"></div>
        </div>
        <div class="app-dots-pattern app-dots-1"></div>
        <div class="app-dots-pattern app-dots-2"></div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
                {{-- Content Column --}}
                <div class="scroll-animate" data-animation="fade-right">
                    {{-- Badge (same as original) --}}
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                    {{-- Decorative Line --}}
                    <div class="app-decorative-line"></div>

                    {{-- Title --}}
                    <h2 class="section-title text-left">{{ $section['title'] }}</h2>

                    @if (!empty($section['subtitle']))
                        <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-3">
                            {{ $section['subtitle'] }}
                        </p>
                    @endif

                    @if (!empty($section['description']))
                        <div class="prose prose-lg dark:prose-invert max-w-none text-gray-600 dark:text-gray-300 mb-6">
                            {!! $section['description'] !!}
                        </div>
                    @endif

                    {{-- App Features --}}
                    @if (count($items) > 0)
                        <div class="space-y-3 mb-6">
                            @foreach ($items as $feature)
                                <div class="flex items-start gap-4">
                                    <div class="app-feature-icon">
                                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}"
                                            class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 dark:text-white">
                                            {{ $feature['title'] ?? '' }}</h4>
                                        @if (!empty($feature['description']))
                                            <p class="text-gray-600 dark:text-gray-400 text-sm">
                                                {{ $feature['description'] }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Download Buttons --}}
                    @php
                        $ctaButtons = $section['cta_buttons'] ?? [];
                        // Fallback for backwards compatibility with old format
                        if (
                            empty($ctaButtons) &&
                            (!empty($section['app_store_url']) || !empty($section['play_store_url']))
                        ) {
                            $ctaButtons = [];
                            if (!empty($section['app_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:apple',
                                    'url' => $section['app_store_url'],
                                    'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                                    'text_main' => $section['app_store_text_main'] ?? 'App Store',
                                ];
                            }
                            if (!empty($section['play_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:google-play',
                                    'url' => $section['play_store_url'],
                                    'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                                    'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                                ];
                            }
                        }
                    @endphp
                    @if (count($ctaButtons) > 0)
                        <div class="flex flex-wrap gap-4">
                            @foreach ($ctaButtons as $index => $button)
                                @if (!empty($button['url']))
                                    <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                        class="store-button {{ $index === 0 ? 'store-button-primary' : 'store-button-secondary' }} inline-flex items-center gap-3 px-6 py-3 rounded-xl shadow-lg">
                                        <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                            class="w-8 h-8" />
                                        <div class="text-left">
                                            <div class="text-xs opacity-80">{{ $button['text_top'] ?? '' }}</div>
                                            <div class="text-lg font-semibold -mt-1">{{ $button['text_main'] ?? '' }}
                                            </div>
                                        </div>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif

                    {{-- App Stats & Social Proof --}}
                    @php
                        $appStats = $section['app_stats'] ?? [];
                    @endphp
                    <div class="mt-6 space-y-4">
                        {{-- Stats Grid with Glassmorphism --}}
                        @if (count($appStats) > 0)
                            <div class="app-stats-card">
                                <div
                                    class="grid grid-cols-{{ count($appStats) }} gap-4 divide-x divide-gray-200/50 dark:divide-gray-700/50">
                                    @foreach ($appStats as $stat)
                                        <div class="text-center px-2">
                                            <div class="flex items-center justify-center gap-1">
                                                @if (!empty($stat['icon']))
                                                    <x-icon icon="{{ $stat['icon'] }}"
                                                        class="w-5 h-5 text-primary-500" />
                                                @endif
                                                <span
                                                    class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stat['value'] ?? '' }}</span>
                                            </div>
                                            <div class="text-xs text-gray-600 dark:text-gray-400 mt-1">
                                                {{ $stat['label'] ?? '' }}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        {{-- Trusted Users with Avatars --}}
                        @php
                            // Get trusted_users config (new nested format or fallback to old format)
                            $trustedUsers = $section['trusted_users'] ?? [];
                            $trustedUsersEnabled = $trustedUsers['enabled'] ?? true;

                            // Get avatars from nested format or fallback to old user_avatars format
                            $userAvatars = $trustedUsers['avatars'] ?? ($section['user_avatars'] ?? []);
                            // Default avatars if none provided (using repeater format with image and name)
                            if (empty($userAvatars)) {
                                $userAvatars = [
                                    ['image' => 'https://i.pravatar.cc/100?img=1', 'name' => 'User 1'],
                                    ['image' => 'https://i.pravatar.cc/100?img=2', 'name' => 'User 2'],
                                    ['image' => 'https://i.pravatar.cc/100?img=3', 'name' => 'User 3'],
                                    ['image' => 'https://i.pravatar.cc/100?img=4', 'name' => 'User 4'],
                                    ['image' => 'https://i.pravatar.cc/100?img=5', 'name' => 'User 5'],
                                ];
                            }
                            // Get trusted users count from app_stats (last item) or fallback
                            $trustedUsersCount = '100K+';
                            if (!empty($appStats)) {
                                // Find the users stat (typically last one) or use the last stat's value
    $lastStat = end($appStats);
    $trustedUsersCount = $lastStat['value'] ?? $trustedUsersCount;
}
// Get trusted users title and replace %count% placeholder (new nested format or old format)
$trustedTitle =
    $trustedUsers['title'] ??
    ($section['trusted_users_title'] ?? 'Trusted by %count% users');
$trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
// Get subtitle from nested format or old format
$trustedSubtitle =
    $trustedUsers['subtitle'] ??
    ($section['trusted_users_subtitle'] ?? 'Join thousands of satisfied customers');
                        @endphp
                        @if ($trustedUsersEnabled)
                            <div class="flex items-center gap-3">
                                {{-- Avatar Stack --}}
                                <div class="flex -space-x-2">
                                    @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                        @php
                                            // Handle both repeater format (array with image/image_url) and simple URL string
                                            $avatarUrl = is_array($avatar)
                                                ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                                : $avatar;
                                            $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                        @endphp
                                        @if ($avatarUrl)
                                            <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                                title="{{ $avatarName }}"
                                                class="w-10 h-10 rounded-full border-2 border-white dark:border-gray-800 object-cover"
                                                loading="lazy">
                                        @endif
                                    @endforeach
                                </div>

                                {{-- Trusted Text --}}
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $trustedTitle }}
                                    </p>
                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                        {{ $trustedSubtitle }}
                                    </p>
                                </div>
                            </div>
                        @endif

                        {{-- QR Code (Optional - Clean Design) --}}
                        @php
                            $qrCodeUrl = $section['qr_code_url'] ?? ($section['qr_code'] ?? null);
                        @endphp
                        @if ($qrCodeUrl)
                            <div class="flex items-center gap-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                                {{-- QR Code Image --}}
                                <div class="qr-code-simple flex-shrink-0">
                                    <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-20 h-20 object-contain"
                                        loading="lazy">
                                </div>

                                {{-- QR Code Text --}}
                                <div>
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $section['qr_label'] ?? 'Scan to Download' }}
                                    </p>
                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                        {{ $section['qr_description'] ?? 'Quick access with your camera' }}
                                    </p>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                {{-- App Image Column with Enhanced Effects --}}
                <div class="scroll-animate flex justify-center lg:justify-end" data-animation="fade-left">
                    @php
                        $appImageUrl = $section['app_image_url'] ?? ($section['app_image'] ?? null);
                    @endphp
                    <div class="app-mockup-container">
                        {{-- Animated Glow Ring --}}
                        <div class="app-mockup-glow"></div>

                        {{-- Floating Icons Around Phone --}}
                        <div class="app-floating-elements hidden lg:block">
                            <div class="app-float-icon app-float-icon-1">
                                <x-icon icon="heroicons:bell" class="w-6 h-6 text-primary-500" />
                            </div>
                            <div class="app-float-icon app-float-icon-2">
                                <x-icon icon="heroicons:heart" class="w-6 h-6 text-rose-500" />
                            </div>
                            <div class="app-float-icon app-float-icon-3">
                                <x-icon icon="heroicons:star" class="w-6 h-6 text-amber-500" />
                            </div>
                        </div>

                        @if ($appImageUrl)
                            <div class="app-mockup">
                                <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}"
                                    class="max-w-sm w-full h-auto drop-shadow-2xl rounded-3xl" loading="lazy">
                            </div>
                        @else
                            <div
                                class="app-mockup bg-gradient-to-br from-primary-500 via-primary-600 to-secondary-600 rounded-[2.5rem] p-4 max-w-xs w-full shadow-2xl">
                                <div
                                    class="bg-white dark:bg-gray-800 rounded-[2rem] aspect-[9/19] flex items-center justify-center overflow-hidden">
                                    {{-- Placeholder App Screen --}}
                                    <div
                                        class="w-full h-full bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-800 dark:to-gray-900 flex flex-col">
                                        {{-- Status Bar --}}
                                        <div class="h-8 bg-primary-500 flex items-center justify-center">
                                            <div class="w-20 h-1 bg-white/30 rounded-full"></div>
                                        </div>
                                        {{-- Content Area --}}
                                        <div class="flex-1 p-4 flex flex-col items-center justify-center gap-4">
                                            <div
                                                class="w-16 h-16 rounded-2xl bg-gradient-to-br from-primary-400 to-primary-600 flex items-center justify-center shadow-lg">
                                                <x-icon icon="heroicons:device-phone-mobile"
                                                    class="w-8 h-8 text-white" />
                                            </div>
                                            <div class="space-y-2 w-full">
                                                <div
                                                    class="h-3 bg-gray-200 dark:bg-gray-700 rounded-full w-3/4 mx-auto">
                                                </div>
                                                <div
                                                    class="h-3 bg-gray-200 dark:bg-gray-700 rounded-full w-1/2 mx-auto">
                                                </div>
                                            </div>
                                        </div>
                                        {{-- Bottom Navigation --}}
                                        <div
                                            class="h-14 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 flex items-center justify-around px-6">
                                            <div class="w-6 h-6 rounded-full bg-gray-200 dark:bg-gray-700"></div>
                                            <div class="w-6 h-6 rounded-full bg-primary-500"></div>
                                            <div class="w-6 h-6 rounded-full bg-gray-200 dark:bg-gray-700"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
