<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultFeatures = [['icon' => 'heroicons:bolt', 'title' => 'Fast & Easy', 'description' => 'Book services in just a few taps'], ['icon' => 'heroicons:bell-alert', 'title' => 'Real-time Updates', 'description' => 'Track your order status live'], ['icon' => 'heroicons:shield-check', 'title' => 'Secure Payments', 'description' => 'Multiple payment options available'], ['icon' => 'heroicons:gift', 'title' => 'Exclusive Offers', 'description' => 'App-only deals and discounts']];

        $this->section = array_merge(
            [
                'badge' => 'Mobile App',
                'title' => 'Download Our App Today',
                'subtitle' => 'Experience convenience at your fingertips',
                'description' => 'Get instant access to all our services right from your smartphone. Available on iOS and Android.',
                'app_image_url' => 'https://www.expertappdevs.com/sitebucket/portfolio/20220329062908-about-image-001.png',
                'cta_buttons' => [['icon' => 'mdi:apple', 'url' => '#', 'text_top' => 'Download on the', 'text_main' => 'App Store'], ['icon' => 'mdi:google-play', 'url' => '#', 'text_top' => 'Get it on', 'text_main' => 'Google Play']],
                'qr_code' => null,
                'qr_label' => 'Scan to Download',
                'qr_description' => 'Point your camera at the QR code to download the app instantly',
                'app_stats' => [['icon' => 'lucide:download', 'value' => '500K+', 'label' => 'Downloads'], ['icon' => 'lucide:star', 'value' => '4.8', 'label' => 'App Rating'], ['icon' => 'lucide:users', 'value' => '100K+', 'label' => 'Happy Users']],
                'trusted_users' => [
                    'enabled' => true,
                    'title' => 'Trusted by %count% users',
                    'subtitle' => 'Join thousands of satisfied customers',
                    'avatars' => [],
                ],
                'features' => [],
            ],
            $section,
        );

        $features = $this->section['features'] ?? ($items ?? $defaultFeatures);

        $this->items = array_map(function ($feature) {
            return [
                'icon' => $feature['icon'] ?? 'heroicons:check',
                'title' => $feature['title'] ?? ($feature['text'] ?? ''),
                'description' => $feature['description'] ?? '',
            ];
        }, $features);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Minimal Section */
        .app-minimal-section {
            position: relative;
        }

        /* Subtle Line Decoration */
        .app-minimal-line {
            position: absolute;
            background: linear-gradient(90deg, transparent, var(--color-primary-200), transparent);
            height: 1px;
            width: 100%;
            top: 0;
        }

        .dark .app-minimal-line {
            background: linear-gradient(90deg, transparent, var(--color-primary-800), transparent);
        }

        /* Phone Frame */
        .app-minimal-phone {
            position: relative;
            background: linear-gradient(180deg, #f3f4f6 0%, #e5e7eb 100%);
            border-radius: 40px;
            padding: 8px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
        }

        .dark .app-minimal-phone {
            background: linear-gradient(180deg, #374151 0%, #1f2937 100%) !important;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.4);
        }

        .app-minimal-phone-inner {
            background: white;
            border-radius: 32px;
            overflow: hidden;
        }

        .dark .app-minimal-phone-inner {
            background: #111827 !important;
        }

        /* Floating Effect */
        .app-minimal-float {
            animation: minimal-float 6s ease-in-out infinite;
        }

        @keyframes minimal-float {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-15px);
            }
        }

        /* Store Button */
        .store-minimal {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.875rem 1.5rem;
            border-radius: 12px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .store-minimal-primary {
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
            color: white;
            box-shadow: 0 4px 15px rgba(var(--color-primary-500-rgb), 0.3);
        }

        .dark .store-minimal-primary {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            box-shadow: 0 4px 15px rgba(var(--color-primary-500-rgb), 0.2);
        }

        .store-minimal-primary:hover {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(var(--color-primary-500-rgb), 0.4);
        }

        .dark .store-minimal-primary:hover {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-500));
        }

        .store-minimal-secondary {
            background: transparent;
            color: var(--color-gray-700);
            border: 2px solid var(--color-gray-300);
        }

        .dark .store-minimal-secondary {
            color: var(--color-gray-200);
            border-color: var(--color-gray-600);
            background: var(--color-gray-800);
        }

        .store-minimal-secondary:hover {
            border-color: var(--color-primary-500);
            color: var(--color-primary-600);
            background: var(--color-primary-50);
            transform: translateY(-2px);
        }

        .dark .store-minimal-secondary:hover {
            border-color: var(--color-primary-400);
            color: var(--color-primary-400);
            background: var(--color-gray-700);
        }

        /* Feature Icon */
        .app-minimal-feature {
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
        }

        .app-minimal-feature-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .app-minimal-feature-icon svg {
            color: white;
        }

        /* Stats */
        .app-minimal-stat {
            text-align: center;
            padding: 0 1rem;
        }

        .app-minimal-stat:not(:last-child) {
            border-right: 1px solid var(--color-gray-200);
        }

        .dark .app-minimal-stat:not(:last-child) {
            border-color: var(--color-gray-700);
        }

        /* QR Code */
        .app-minimal-qr {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: var(--color-gray-100);
            border-radius: 16px;
            border: 1px solid var(--color-gray-200);
        }

        .dark .app-minimal-qr {
            background: #1f2937 !important;
            border-color: #374151 !important;
        }

        .app-minimal-qr-image {
            background: white;
            padding: 6px;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .dark .app-minimal-qr-image {
            background: white;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .app-minimal-qr-title {
            color: var(--color-gray-900) !important;
        }

        .dark .app-minimal-qr-title {
            color: #ffffff !important;
        }

        .app-minimal-qr-desc {
            color: var(--color-gray-500) !important;
        }

        .dark .app-minimal-qr-desc {
            color: #d1d5db !important;
        }
    </style>


    <section id="app-download"
        class="app-minimal-section section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="app-minimal-line"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
                {{-- Content Column --}}
                <div class="scroll-animate order-2 lg:order-1" data-animation="fade-right">
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                    <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                        {{ $section['title'] }}
                    </h2>

                    @if (!empty($section['subtitle']))
                        <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-3">
                            {{ $section['subtitle'] }}
                        </p>
                    @endif

                    @if (!empty($section['description']))
                        <p class="text-gray-600 dark:text-gray-300 mb-6">
                            {!! strip_tags($section['description']) !!}
                        </p>
                    @endif

                    {{-- App Features --}}
                    @if (count($items) > 0)
                        <div class="grid sm:grid-cols-2 gap-4 mb-6">
                            @foreach ($items as $feature)
                                <div class="app-minimal-feature">
                                    <div class="app-minimal-feature-icon">
                                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}"
                                            class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 dark:text-white">
                                            {{ $feature['title'] ?? '' }}</h4>
                                        @if (!empty($feature['description']))
                                            <p class="text-gray-600 dark:text-gray-400 text-sm">
                                                {{ $feature['description'] }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Download Buttons --}}
                    @php
                        $ctaButtons = $section['cta_buttons'] ?? [];
                        if (
                            empty($ctaButtons) &&
                            (!empty($section['app_store_url']) || !empty($section['play_store_url']))
                        ) {
                            $ctaButtons = [];
                            if (!empty($section['app_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:apple',
                                    'url' => $section['app_store_url'],
                                    'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                                    'text_main' => $section['app_store_text_main'] ?? 'App Store',
                                ];
                            }
                            if (!empty($section['play_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:google-play',
                                    'url' => $section['play_store_url'],
                                    'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                                    'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                                ];
                            }
                        }
                    @endphp
                    @if (count($ctaButtons) > 0)
                        <div class="flex flex-wrap gap-3 mb-6">
                            @foreach ($ctaButtons as $index => $button)
                                @if (!empty($button['url']))
                                    <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                        class="store-minimal {{ $index === 0 ? 'store-minimal-primary' : 'store-minimal-secondary' }}">
                                        <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                            class="w-6 h-6" />
                                        <div class="text-left">
                                            <div class="text-[10px] opacity-60 leading-tight">
                                                {{ $button['text_top'] ?? '' }}</div>
                                            <div class="text-sm font-semibold leading-tight">
                                                {{ $button['text_main'] ?? '' }}</div>
                                        </div>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif

                    {{-- Stats Row --}}
                    @php $appStats = $section['app_stats'] ?? []; @endphp
                    @if (count($appStats) > 0)
                        <div class="flex mb-6">
                            @foreach ($appStats as $stat)
                                <div class="app-minimal-stat">
                                    <div class="flex items-center justify-center gap-1">
                                        @if (!empty($stat['icon']))
                                            <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5 text-primary-500" />
                                        @endif
                                        <span
                                            class="text-xl font-bold text-gray-900 dark:text-white">{{ $stat['value'] ?? '' }}</span>
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">{{ $stat['label'] ?? '' }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Trusted Users --}}
                    @php
                        $trustedUsers = $section['trusted_users'] ?? [];
                        $trustedUsersEnabled = $trustedUsers['enabled'] ?? true;
                        $userAvatars = $trustedUsers['avatars'] ?? ($section['user_avatars'] ?? []);
                        if (empty($userAvatars)) {
                            $userAvatars = [
                                ['image' => 'https://i.pravatar.cc/100?img=1', 'name' => 'User 1'],
                                ['image' => 'https://i.pravatar.cc/100?img=2', 'name' => 'User 2'],
                                ['image' => 'https://i.pravatar.cc/100?img=3', 'name' => 'User 3'],
                                ['image' => 'https://i.pravatar.cc/100?img=4', 'name' => 'User 4'],
                                ['image' => 'https://i.pravatar.cc/100?img=5', 'name' => 'User 5'],
                            ];
                        }
                        $trustedUsersCount = '100K+';
                        if (!empty($appStats)) {
                            $lastStat = end($appStats);
                            $trustedUsersCount = $lastStat['value'] ?? $trustedUsersCount;
                        }
                        $trustedTitle =
                            $trustedUsers['title'] ?? ($section['trusted_users_title'] ?? 'Trusted by %count% users');
                        $trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
                        $trustedSubtitle =
                            $trustedUsers['subtitle'] ??
                            ($section['trusted_users_subtitle'] ?? 'Join thousands of satisfied customers');
                    @endphp
                    @if ($trustedUsersEnabled)
                        <div class="flex items-center gap-3 mb-6">
                            <div class="flex -space-x-2">
                                @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                    @php
                                        $avatarUrl = is_array($avatar)
                                            ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                            : $avatar;
                                        $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                    @endphp
                                    @if ($avatarUrl)
                                        <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                            title="{{ $avatarName }}"
                                            class="w-10 h-10 rounded-full border-2 border-white dark:border-gray-800 object-cover"
                                            loading="lazy">
                                    @endif
                                @endforeach
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">{{ $trustedTitle }}</p>
                                <p class="text-xs text-gray-600 dark:text-gray-400">{{ $trustedSubtitle }}</p>
                            </div>
                        </div>
                    @endif

                    {{-- QR Code --}}
                    @php $qrCodeUrl = $section['qr_code_url'] ?? $section['qr_code'] ?? null; @endphp
                    @if ($qrCodeUrl)
                        <div class="app-minimal-qr">
                            <div class="app-minimal-qr-image flex-shrink-0">
                                <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-14 h-14 object-contain"
                                    loading="lazy">
                            </div>
                            <div>
                                <p class="app-minimal-qr-title text-sm font-semibold">
                                    {{ $section['qr_label'] ?? 'Scan to Download' }}</p>
                                <p class="app-minimal-qr-desc text-xs">
                                    {{ $section['qr_description'] ?? 'Point your camera' }}</p>
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Phone Column --}}
                <div class="scroll-animate flex justify-center order-1 lg:order-2" data-animation="fade-left">
                    @php $appImageUrl = $section['app_image_url'] ?? $section['app_image'] ?? null; @endphp

                    <div class="app-minimal-float">
                        @if ($appImageUrl)
                            <div class="app-minimal-phone max-w-[260px]">
                                <div class="app-minimal-phone-inner">
                                    <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}" class="w-full h-auto"
                                        loading="lazy">
                                </div>
                            </div>
                        @else
                            <div class="app-minimal-phone max-w-[260px]">
                                <div class="app-minimal-phone-inner aspect-[9/19] flex items-center justify-center">
                                    <x-icon icon="heroicons:device-phone-mobile"
                                        class="w-16 h-16 text-gray-300 dark:text-gray-600" />
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
