<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default comparison items
        $defaultItems = [
            ['feature' => 'Quality Guarantee', 'us' => true, 'others' => false, 'icon' => 'heroicons:shield-check'],
            ['feature' => '24/7 Support', 'us' => true, 'others' => false, 'icon' => 'heroicons:phone'],
            ['feature' => 'Free Consultation', 'us' => true, 'others' => false, 'icon' => 'heroicons:chat-bubble-left-right'],
            ['feature' => 'Same Day Service', 'us' => true, 'others' => false, 'icon' => 'heroicons:clock'],
            ['feature' => 'Transparent Pricing', 'us' => true, 'others' => true, 'icon' => 'heroicons:currency-dollar'],
            ['feature' => 'Money Back Guarantee', 'us' => true, 'others' => false, 'icon' => 'heroicons:arrow-path'],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge([
            'title' => 'Why Choose Us',
            'subtitle' => 'See how we compare to the competition',
            'badge' => 'Comparison',
            'us_label' => 'Us',
            'others_label' => 'Others',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="comparison" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
            @if(!empty($section['badge']))
            <span class="badge badge-primary mb-4">
                {{ $section['badge'] }}
            </span>
            @endif

            <h2 class="section-title">
                {{ $section['title'] }}
            </h2>

            @if(!empty($section['subtitle']))
            <p class="section-subtitle">
                {{ $section['subtitle'] }}
            </p>
            @endif
        </div>

        <!-- Comparison Table -->
        @if(count($items) > 0)
        <div class="max-w-4xl mx-auto scroll-animate" data-animation="fade-up">
            <div class="bg-white dark:bg-gray-700 rounded-2xl shadow-xl border border-gray-100 dark:border-gray-600 overflow-hidden">
                <table class="comparison-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left p-6 text-gray-900 dark:text-white font-semibold">
                                {{ __('Feature') }}
                            </th>
                            <th class="comparison-us p-6 text-center min-w-[140px]">
                                <span class="inline-flex items-center gap-2 text-primary-600 dark:text-primary-400 font-bold">
                                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M12 2L15.09 8.26L22 9.27L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9.27L8.91 8.26L12 2Z"/>
                                    </svg>
                                    {{ $section['us_label'] ?? __('Us') }}
                                </span>
                            </th>
                            <th class="p-6 text-center min-w-[140px] text-gray-500 dark:text-gray-400 font-semibold">
                                {{ $section['others_label'] ?? __('Others') }}
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($items as $index => $item)
                        <tr class="comparison-row">
                            <td class="p-5">
                                <div class="flex items-center gap-3">
                                    @if(!empty($item['icon']))
                                    <x-icon icon="{{ $item['icon'] }}" class="w-5 h-5 text-gray-400" />
                                    @endif
                                    <span class="text-gray-900 dark:text-white font-medium">{{ $item['feature'] ?? '' }}</span>
                                </div>
                            </td>
                            <td class="comparison-us p-5 text-center">
                                @if(isset($item['us']) && $item['us'])
                                    @if(is_string($item['us']) && $item['us'] !== 'true' && $item['us'] !== '1')
                                    <span class="text-primary-600 dark:text-primary-400 font-semibold">{{ $item['us'] }}</span>
                                    @else
                                    <svg class="w-6 h-6 mx-auto check-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    @endif
                                @else
                                <svg class="w-6 h-6 mx-auto x-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                                @endif
                            </td>
                            <td class="p-5 text-center">
                                @if(isset($item['others']) && $item['others'])
                                    @if(is_string($item['others']) && $item['others'] !== 'true' && $item['others'] !== '1')
                                    <span class="text-gray-600 dark:text-gray-300">{{ $item['others'] }}</span>
                                    @else
                                    <svg class="w-6 h-6 mx-auto check-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    @endif
                                @else
                                <svg class="w-6 h-6 mx-auto x-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    </div>
</section>

<style>
    .comparison-table {
        border-collapse: separate;
        border-spacing: 0;
    }
    .comparison-table th,
    .comparison-table td {
        border-bottom: 1px solid var(--color-gray-200);
    }
    .dark .comparison-table th,
    .dark .comparison-table td {
        border-color: var(--color-gray-600);
    }
    .comparison-table tr:last-child td {
        border-bottom: none;
    }
    .comparison-us {
        background: linear-gradient(to bottom, var(--color-primary-50), transparent);
        position: relative;
    }
    .dark .comparison-us {
        background: linear-gradient(to bottom, var(--color-primary-900), transparent);
    }
    .comparison-us::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--color-primary-500);
        border-radius: 4px 4px 0 0;
    }
    .check-icon {
        color: #10b981;
    }
    .x-icon {
        color: #ef4444;
    }
    .comparison-row {
        transition: background-color 0.2s ease;
    }
    .comparison-row:hover {
        background-color: var(--color-gray-50);
    }
    .dark .comparison-row:hover {
        background-color: var(--color-gray-700);
    }
</style>
</div>
