<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge(
            [
                'badge' => 'Contact Us',
                'title' => 'Get In Touch',
                'subtitle' => 'Have questions? We\'re here to help. Reach out to us through any of the channels below.',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => '',
                'google_map_link_url' => '',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section id="contact"
    class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 lg:gap-16">
            {{-- Left Side - Contact Info --}}
            <div>
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                <h2 class="section-title text-left">{{ $section['title'] }}</h2>
                <p class="text-gray-600 dark:text-gray-400 mb-8">{{ $section['subtitle'] }}</p>

                <div class="space-y-6">
                    {{-- Phone --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:phone" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">{{ $section['info_phone_label'] }}
                            </h3>
                            <a href="tel:{{ $company['phone'] }}"
                                class="text-gray-600 dark:text-gray-400 hover:text-primary-600 transition-colors">
                                {{ $company['phone'] }}
                            </a>
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:envelope" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">{{ $section['info_email_label'] }}
                            </h3>
                            <a href="mailto:{{ $company['email'] }}"
                                class="text-gray-600 dark:text-gray-400 hover:text-primary-600 transition-colors">
                                {{ $company['email'] }}
                            </a>
                        </div>
                    </div>

                    {{-- Address --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:map-pin" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                {{ $section['info_address_label'] }}</h3>
                            <p class="text-gray-600 dark:text-gray-400">{{ $company['address'] }}</p>
                        </div>
                    </div>

                    {{-- Hours --}}
                    <div class="flex items-start gap-4">
                        <div
                            class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:clock" class="w-6 h-6 text-primary-600" />
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900 dark:text-white">{{ $section['info_hours_label'] }}
                            </h3>
                            <p class="text-gray-600 dark:text-gray-400">{{ $company['hours'] }}</p>
                        </div>
                    </div>
                </div>

                {{-- Social Links --}}
                @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                    <div class="mt-8">
                        <p class="font-semibold text-gray-900 dark:text-white mb-4">
                            {{ $section['info_follow_us_label'] }}</p>
                        <div class="flex gap-4">
                            @foreach ($social as $key => $link)
                                @if ($key !== 'show_icon' && is_array($link))
                                    <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                        class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center hover:bg-primary-600 hover:text-white transition-all duration-300">
                                        <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            {{-- Right Side - Google Map --}}
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl overflow-hidden shadow-lg border border-gray-100 dark:border-gray-700 flex flex-col">
                {{-- Map Embed --}}
                <div class="relative w-full h-[400px] lg:flex-1 lg:min-h-[450px]">
                    <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
                        class="absolute inset-0">
                    </iframe>
                </div>

                {{-- Map Footer with Open in Maps link --}}
                <div class="p-4 border-t border-gray-100 dark:border-gray-700 bg-gray-50 dark:bg-gray-800/50 flex-shrink-0">
                    <a href="{{ $section['google_map_link_url'] }}"
                        target="_blank"
                        class="inline-flex items-center gap-2 text-primary-600 hover:text-primary-700 text-sm font-medium transition-colors">
                        <x-icon icon="heroicons:arrow-top-right-on-square" class="w-4 h-4" />
                        {{ $section['open_in_maps_text'] }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
