<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge(
            [
                'badge' => 'Contact Us',
                'title' => 'Get In Touch',
                'subtitle' => 'Have questions? We\'re here to help. Reach out to us through any of the channels below.',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => '',
                'google_map_link_url' => '',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

{{-- Contact Section 6: Modern Glassmorphism with Wave Pattern --}}
<section id="contact"
    class="section relative overflow-hidden {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>

    {{-- Background with Gradient Mesh --}}
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        {{-- Gradient Mesh --}}
        <div class="absolute top-0 left-0 w-full h-full">
            <div class="absolute top-[-20%] left-[-10%] w-[60%] h-[60%] bg-primary-500/20 rounded-full blur-[120px]"></div>
            <div class="absolute bottom-[-20%] right-[-10%] w-[60%] h-[60%] bg-secondary-500/20 rounded-full blur-[120px]"></div>
            <div class="absolute top-[40%] left-[60%] w-[40%] h-[40%] bg-primary-400/10 rounded-full blur-[100px]"></div>
        </div>
        {{-- Wave Pattern --}}
        <svg class="absolute bottom-0 left-0 w-full opacity-5 dark:opacity-10" viewBox="0 0 1440 320" preserveAspectRatio="none">
            <path class="fill-primary-600" d="M0,192L48,197.3C96,203,192,213,288,229.3C384,245,480,267,576,250.7C672,235,768,181,864,181.3C960,181,1056,235,1152,234.7C1248,235,1344,181,1392,154.7L1440,128L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path>
        </svg>
        {{-- Floating Geometric Shapes --}}
        <div class="absolute top-20 right-20 w-20 h-20 border-2 border-primary-300/30 dark:border-primary-700/30 rounded-2xl rotate-12" style="animation: floatRotate 10s ease-in-out infinite;"></div>
        <div class="absolute bottom-40 left-20 w-16 h-16 bg-secondary-400/10 dark:bg-secondary-600/10 rounded-full" style="animation: floatRotate 8s ease-in-out infinite reverse;"></div>
        <div class="absolute top-1/3 left-1/4 w-3 h-3 bg-primary-500 rounded-full opacity-40" style="animation: pulse 3s ease-in-out infinite;"></div>
        <div class="absolute top-2/3 right-1/3 w-4 h-4 bg-secondary-500 rounded-full opacity-30" style="animation: pulse 4s ease-in-out infinite;"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Header with Icon Strip --}}
        <div class="text-center mb-16">
            {{-- Icon Strip --}}
            <div class="flex justify-center gap-3 mb-8">
                <div class="w-12 h-12 rounded-2xl bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl shadow-lg border border-white/50 dark:border-gray-700/50 flex items-center justify-center">
                    <x-icon icon="heroicons:phone" class="w-6 h-6 text-primary-600" />
                </div>
                <div class="w-12 h-12 rounded-2xl bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl shadow-lg border border-white/50 dark:border-gray-700/50 flex items-center justify-center">
                    <x-icon icon="heroicons:envelope" class="w-6 h-6 text-secondary-600" />
                </div>
                <div class="w-12 h-12 rounded-2xl bg-gradient-to-br from-primary-500 to-secondary-500 shadow-lg flex items-center justify-center">
                    <x-icon icon="heroicons:map-pin" class="w-6 h-6 text-white" />
                </div>
                <div class="w-12 h-12 rounded-2xl bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl shadow-lg border border-white/50 dark:border-gray-700/50 flex items-center justify-center">
                    <x-icon icon="heroicons:clock" class="w-6 h-6 text-primary-600" />
                </div>
            </div>
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle max-w-2xl mx-auto">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Main Content - Glassmorphism Cards --}}
        <div class="grid lg:grid-cols-5 gap-6 lg:gap-8">
            {{-- Left: Contact Info Cards --}}
            <div class="lg:col-span-2 space-y-4">
                {{-- Phone --}}
                <a href="tel:{{ $company['phone'] }}"
                    class="group block bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-2xl p-5 shadow-xl shadow-gray-900/5 dark:shadow-black/20 border border-white/50 dark:border-gray-700/50 hover:shadow-2xl hover:shadow-primary-500/10 transition-all duration-500 hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <div class="relative">
                            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-primary-500 to-primary-600 flex items-center justify-center shadow-lg shadow-primary-500/30 group-hover:scale-110 transition-transform duration-500">
                                <x-icon icon="heroicons:phone" class="w-7 h-7 text-white" />
                            </div>
                            <div class="absolute -top-1 -right-1 w-4 h-4 rounded-full bg-green-500 border-2 border-white dark:border-gray-800"></div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">{{ $section['info_phone_label'] }}</p>
                            <p class="font-bold text-gray-900 dark:text-white text-lg group-hover:text-primary-600 dark:group-hover:text-primary-400 transition-colors">{{ $company['phone'] }}</p>
                        </div>
                        <x-icon icon="heroicons:chevron-right" class="w-5 h-5 text-gray-400 group-hover:text-primary-500 group-hover:translate-x-1 transition-all" />
                    </div>
                </a>

                {{-- Email --}}
                <a href="mailto:{{ $company['email'] }}"
                    class="group block bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-2xl p-5 shadow-xl shadow-gray-900/5 dark:shadow-black/20 border border-white/50 dark:border-gray-700/50 hover:shadow-2xl hover:shadow-secondary-500/10 transition-all duration-500 hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-secondary-500 to-secondary-600 flex items-center justify-center shadow-lg shadow-secondary-500/30 group-hover:scale-110 transition-transform duration-500">
                            <x-icon icon="heroicons:envelope" class="w-7 h-7 text-white" />
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">{{ $section['info_email_label'] }}</p>
                            <p class="font-bold text-gray-900 dark:text-white text-lg group-hover:text-secondary-600 dark:group-hover:text-secondary-400 transition-colors truncate">{{ $company['email'] }}</p>
                        </div>
                        <x-icon icon="heroicons:chevron-right" class="w-5 h-5 text-gray-400 group-hover:text-secondary-500 group-hover:translate-x-1 transition-all flex-shrink-0" />
                    </div>
                </a>

                {{-- Address --}}
                <div class="bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-2xl p-5 shadow-xl shadow-gray-900/5 dark:shadow-black/20 border border-white/50 dark:border-gray-700/50">
                    <div class="flex items-start gap-4">
                        <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-primary-500 to-secondary-500 flex items-center justify-center shadow-lg flex-shrink-0">
                            <x-icon icon="heroicons:map-pin" class="w-7 h-7 text-white" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">{{ $section['info_address_label'] }}</p>
                            <p class="font-semibold text-gray-900 dark:text-white">{{ $company['address'] }}</p>
                        </div>
                    </div>
                </div>

                {{-- Hours --}}
                <div class="bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-2xl p-5 shadow-xl shadow-gray-900/5 dark:shadow-black/20 border border-white/50 dark:border-gray-700/50">
                    <div class="flex items-start gap-4">
                        <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-secondary-500 to-primary-500 flex items-center justify-center shadow-lg flex-shrink-0">
                            <x-icon icon="heroicons:clock" class="w-7 h-7 text-white" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">{{ $section['info_hours_label'] }}</p>
                            <p class="font-semibold text-gray-900 dark:text-white">{{ $company['hours'] }}</p>
                        </div>
                    </div>
                </div>

                {{-- Social Links --}}
                @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                    <div class="bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-2xl p-5 shadow-xl shadow-gray-900/5 dark:shadow-black/20 border border-white/50 dark:border-gray-700/50">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">{{ $section['info_follow_us_label'] }}</p>
                        <div class="flex gap-3">
                            @foreach ($social as $key => $link)
                                @if ($key !== 'show_icon' && is_array($link))
                                    <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                        class="w-11 h-11 rounded-xl bg-gray-100 dark:bg-gray-700/50 flex items-center justify-center text-gray-600 dark:text-gray-400 hover:bg-gradient-to-br hover:from-primary-500 hover:to-secondary-500 hover:text-white transition-all duration-300 hover:scale-110 hover:shadow-lg">
                                        <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            {{-- Right: Map --}}
            <div class="lg:col-span-3">
                <div class="bg-white/70 dark:bg-gray-800/70 backdrop-blur-xl rounded-3xl overflow-hidden shadow-2xl shadow-gray-900/10 dark:shadow-black/30 border border-white/50 dark:border-gray-700/50 h-full min-h-[500px] flex flex-col">
                    {{-- Map Header --}}
                    <div class="p-5 border-b border-gray-100 dark:border-gray-700/50 flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="flex gap-1.5">
                                <div class="w-3 h-3 rounded-full bg-red-500"></div>
                                <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                                <div class="w-3 h-3 rounded-full bg-green-500"></div>
                            </div>
                            <span class="text-sm text-gray-500 dark:text-gray-400 font-medium">Location Map</span>
                        </div>
                        <a href="{{ $section['google_map_link_url'] }}" target="_blank"
                            class="inline-flex items-center gap-2 text-primary-600 hover:text-primary-700 text-sm font-medium transition-colors">
                            <x-icon icon="heroicons:arrow-top-right-on-square" class="w-4 h-4" />
                            {{ $section['open_in_maps_text'] }}
                        </a>
                    </div>
                    {{-- Map --}}
                    <div class="relative flex-1 min-h-[400px]">
                        <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
                            class="absolute inset-0">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @keyframes floatRotate {
            0%, 100% { transform: translateY(0) rotate(12deg); }
            50% { transform: translateY(-15px) rotate(18deg); }
        }
        @keyframes pulse {
            0%, 100% { opacity: 0.3; transform: scale(1); }
            50% { opacity: 0.6; transform: scale(1.2); }
        }
    </style>
</section>
