<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge(
            [
                'badge' => 'Contact Us',
                'title' => 'Get In Touch',
                'subtitle' => 'Have questions? We\'re here to help. Reach out to us through any of the channels below.',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => '',
                'google_map_link_url' => '',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

{{-- Contact Section 5: Full-width Map with Floating Overlay Cards --}}
<section id="contact" class="section relative"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>

    {{-- Full-width Map Background --}}
    <div class="absolute inset-0 z-0">
        <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
        </iframe>
        {{-- Dark Overlay --}}
        <div class="absolute inset-0 bg-gradient-to-b from-gray-900/80 via-gray-900/60 to-gray-900/80"></div>
    </div>

    {{-- Content --}}
    <div class="relative z-10 py-20 lg:py-28">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header --}}
            <div class="text-center mb-12">
                <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/10 backdrop-blur-md text-white text-sm font-medium mb-6 border border-white/20">
                    <x-icon icon="heroicons:map-pin" class="w-4 h-4" />
                    {{ $section['badge'] }}
                </span>
                <h2 class="text-4xl lg:text-5xl font-bold text-white mb-4">{{ $section['title'] }}</h2>
                <p class="text-gray-300 text-lg max-w-2xl mx-auto">{{ $section['subtitle'] }}</p>
            </div>

            {{-- Contact Cards - Bento Grid Style --}}
            <div class="grid lg:grid-cols-12 gap-4 lg:gap-6">
                {{-- Main Info Card --}}
                <div class="lg:col-span-5 bg-white/10 backdrop-blur-xl rounded-3xl p-8 border border-white/20 shadow-2xl">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="w-12 h-12 rounded-2xl bg-gradient-to-br from-primary-500 to-secondary-500 flex items-center justify-center">
                            <x-icon icon="heroicons:building-office-2" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <h3 class="text-white font-bold text-xl">{{ $section['info_address_label'] }}</h3>
                            <p class="text-gray-400 text-sm">Visit our location</p>
                        </div>
                    </div>
                    <p class="text-white/90 text-lg mb-6 leading-relaxed">{{ $company['address'] }}</p>

                    <a href="{{ $section['google_map_link_url'] }}" target="_blank"
                        class="inline-flex items-center gap-2 w-full justify-center px-6 py-4 bg-white text-gray-900 font-semibold rounded-2xl hover:bg-primary-50 transition-all duration-300 group">
                        <x-icon icon="heroicons:arrow-top-right-on-square" class="w-5 h-5 group-hover:translate-x-0.5 group-hover:-translate-y-0.5 transition-transform" />
                        {{ $section['open_in_maps_text'] }}
                    </a>

                    {{-- Social Links --}}
                    @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                        <div class="mt-8 pt-8 border-t border-white/10">
                            <p class="text-gray-400 text-sm mb-4">{{ $section['info_follow_us_label'] }}</p>
                            <div class="flex gap-3">
                                @foreach ($social as $key => $link)
                                    @if ($key !== 'show_icon' && is_array($link))
                                        <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                            class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center text-white hover:bg-white hover:text-primary-600 transition-all duration-300">
                                            <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                        </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Right Column --}}
                <div class="lg:col-span-7 grid sm:grid-cols-2 gap-4 lg:gap-6">
                    {{-- Phone Card --}}
                    <a href="tel:{{ $company['phone'] }}"
                        class="group bg-white/10 backdrop-blur-xl rounded-3xl p-6 border border-white/20 hover:bg-white/20 transition-all duration-300 hover:scale-[1.02]">
                        <div class="w-14 h-14 rounded-2xl bg-primary-500/20 flex items-center justify-center mb-5 group-hover:bg-primary-500 transition-colors duration-300">
                            <x-icon icon="heroicons:phone" class="w-7 h-7 text-primary-400 group-hover:text-white transition-colors duration-300" />
                        </div>
                        <p class="text-gray-400 text-sm mb-2">{{ $section['info_phone_label'] }}</p>
                        <p class="text-white font-bold text-xl group-hover:text-primary-300 transition-colors">{{ $company['phone'] }}</p>
                        <div class="mt-4 flex items-center gap-2 text-primary-400 text-sm font-medium opacity-0 group-hover:opacity-100 transition-opacity">
                            <span>Call now</span>
                            <x-icon icon="heroicons:arrow-right" class="w-4 h-4" />
                        </div>
                    </a>

                    {{-- Email Card --}}
                    <a href="mailto:{{ $company['email'] }}"
                        class="group bg-white/10 backdrop-blur-xl rounded-3xl p-6 border border-white/20 hover:bg-white/20 transition-all duration-300 hover:scale-[1.02]">
                        <div class="w-14 h-14 rounded-2xl bg-secondary-500/20 flex items-center justify-center mb-5 group-hover:bg-secondary-500 transition-colors duration-300">
                            <x-icon icon="heroicons:envelope" class="w-7 h-7 text-secondary-400 group-hover:text-white transition-colors duration-300" />
                        </div>
                        <p class="text-gray-400 text-sm mb-2">{{ $section['info_email_label'] }}</p>
                        <p class="text-white font-bold text-lg group-hover:text-secondary-300 transition-colors truncate">{{ $company['email'] }}</p>
                        <div class="mt-4 flex items-center gap-2 text-secondary-400 text-sm font-medium opacity-0 group-hover:opacity-100 transition-opacity">
                            <span>Send email</span>
                            <x-icon icon="heroicons:arrow-right" class="w-4 h-4" />
                        </div>
                    </a>

                    {{-- Hours Card - Full Width --}}
                    <div class="sm:col-span-2 bg-gradient-to-r from-primary-600/90 to-secondary-600/90 backdrop-blur-xl rounded-3xl p-6 border border-white/20 relative overflow-hidden">
                        {{-- Decorative Elements --}}
                        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-1/2 translate-x-1/2"></div>
                        <div class="absolute bottom-0 left-0 w-24 h-24 bg-white/10 rounded-full translate-y-1/2 -translate-x-1/2"></div>

                        <div class="relative z-10 flex flex-col sm:flex-row items-start sm:items-center gap-6">
                            <div class="w-16 h-16 rounded-2xl bg-white/20 flex items-center justify-center flex-shrink-0">
                                <x-icon icon="heroicons:clock" class="w-8 h-8 text-white" />
                            </div>
                            <div class="flex-1">
                                <p class="text-white/70 text-sm mb-1">{{ $section['info_hours_label'] }}</p>
                                <p class="text-white font-bold text-xl">{{ $company['hours'] }}</p>
                            </div>
                            <div class="hidden sm:flex items-center gap-2 text-white/80">
                                <span class="w-3 h-3 rounded-full bg-green-400 animate-pulse"></span>
                                <span class="text-sm font-medium">Open Now</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
