<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge(
            [
                'badge' => 'Contact Us',
                'title' => 'Get In Touch',
                'subtitle' => 'Have questions? We\'re here to help. Reach out to us through any of the channels below.',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => '',
                'google_map_link_url' => '',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

{{-- Contact Section 4: Minimal Centered Design with Hexagon Pattern --}}
<section id="contact"
    class="section relative overflow-hidden {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>

    {{-- Background Pattern --}}
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        {{-- Hexagon Pattern --}}
        <svg class="absolute inset-0 w-full h-full opacity-[0.03] dark:opacity-[0.05]" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <pattern id="hexagons" width="50" height="43.4" patternUnits="userSpaceOnUse" patternTransform="scale(2)">
                    <polygon class="fill-primary-600" points="24.8,22 37.3,29.2 37.3,43.7 24.8,50.9 12.3,43.7 12.3,29.2" transform="translate(-12,-22)"/>
                    <polygon class="fill-primary-600" points="24.8,22 37.3,29.2 37.3,43.7 24.8,50.9 12.3,43.7 12.3,29.2" transform="translate(13,-0.2)"/>
                </pattern>
            </defs>
            <rect width="100%" height="100%" fill="url(#hexagons)"/>
        </svg>
        {{-- Gradient Orbs --}}
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-primary-500/5 rounded-full blur-3xl"></div>
        <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-secondary-500/5 rounded-full blur-3xl"></div>
    </div>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Header --}}
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-br from-primary-500 to-secondary-500 mb-6 shadow-lg shadow-primary-500/25">
                <x-icon icon="heroicons:chat-bubble-left-right" class="w-8 h-8 text-white" />
            </div>
            <h2 class="text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4">{{ $section['title'] }}</h2>
            <p class="text-gray-600 dark:text-gray-400 text-lg max-w-2xl mx-auto">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Contact Info - Horizontal Layout --}}
        <div class="grid sm:grid-cols-2 gap-4 mb-12">
            {{-- Phone --}}
            <a href="tel:{{ $company['phone'] }}"
                class="group relative bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-sm hover:shadow-xl transition-all duration-500 border border-gray-100 dark:border-gray-700 overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-r from-primary-500 to-primary-600 translate-y-full group-hover:translate-y-0 transition-transform duration-500"></div>
                <div class="relative z-10 flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-primary-100 dark:bg-primary-900/30 group-hover:bg-white/20 flex items-center justify-center transition-colors duration-500">
                        <x-icon icon="heroicons:phone" class="w-6 h-6 text-primary-600 group-hover:text-white transition-colors duration-500" />
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 group-hover:text-white/70 transition-colors duration-500">{{ $section['info_phone_label'] }}</p>
                        <p class="font-semibold text-gray-900 dark:text-white group-hover:text-white transition-colors duration-500">{{ $company['phone'] }}</p>
                    </div>
                </div>
            </a>

            {{-- Email --}}
            <a href="mailto:{{ $company['email'] }}"
                class="group relative bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-sm hover:shadow-xl transition-all duration-500 border border-gray-100 dark:border-gray-700 overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-r from-secondary-500 to-secondary-600 translate-y-full group-hover:translate-y-0 transition-transform duration-500"></div>
                <div class="relative z-10 flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-secondary-100 dark:bg-secondary-900/30 group-hover:bg-white/20 flex items-center justify-center transition-colors duration-500">
                        <x-icon icon="heroicons:envelope" class="w-6 h-6 text-secondary-600 group-hover:text-white transition-colors duration-500" />
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="text-sm text-gray-500 dark:text-gray-400 group-hover:text-white/70 transition-colors duration-500">{{ $section['info_email_label'] }}</p>
                        <p class="font-semibold text-gray-900 dark:text-white group-hover:text-white transition-colors duration-500 truncate">{{ $company['email'] }}</p>
                    </div>
                </div>
            </a>

            {{-- Address --}}
            <div class="group relative bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
                <div class="relative z-10 flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary-100 to-secondary-100 dark:from-primary-900/30 dark:to-secondary-900/30 flex items-center justify-center">
                        <x-icon icon="heroicons:map-pin" class="w-6 h-6 text-primary-600" />
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">{{ $section['info_address_label'] }}</p>
                        <p class="font-semibold text-gray-900 dark:text-white">{{ $company['address'] }}</p>
                    </div>
                </div>
            </div>

            {{-- Hours --}}
            <div class="group relative bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
                <div class="relative z-10 flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-secondary-100 to-primary-100 dark:from-secondary-900/30 dark:to-primary-900/30 flex items-center justify-center">
                        <x-icon icon="heroicons:clock" class="w-6 h-6 text-secondary-600" />
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">{{ $section['info_hours_label'] }}</p>
                        <p class="font-semibold text-gray-900 dark:text-white">{{ $company['hours'] }}</p>
                    </div>
                </div>
            </div>
        </div>

        {{-- Map Section --}}
        <div class="relative rounded-3xl overflow-hidden shadow-2xl shadow-gray-900/10 dark:shadow-black/30">
            {{-- Decorative Corner Elements --}}
            <div class="absolute -top-2 -left-2 w-16 h-16 border-t-4 border-l-4 border-primary-500 rounded-tl-3xl z-20"></div>
            <div class="absolute -bottom-2 -right-2 w-16 h-16 border-b-4 border-r-4 border-secondary-500 rounded-br-3xl z-20"></div>

            <div class="relative w-full h-[400px]">
                <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
                    allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>

            {{-- Map Footer --}}
            <div class="bg-white dark:bg-gray-800 p-5 flex flex-col sm:flex-row items-center justify-between gap-4">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-primary-500 to-secondary-500 flex items-center justify-center">
                        <x-icon icon="heroicons:map-pin" class="w-5 h-5 text-white" />
                    </div>
                    <span class="text-gray-600 dark:text-gray-400 text-sm">{{ $company['address'] }}</span>
                </div>
                <a href="{{ $section['google_map_link_url'] }}" target="_blank"
                    class="inline-flex items-center gap-2 px-5 py-2.5 bg-gradient-to-r from-primary-600 to-secondary-600 hover:from-primary-700 hover:to-secondary-700 text-white text-sm font-medium rounded-xl transition-all duration-300 shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40">
                    <x-icon icon="heroicons:arrow-top-right-on-square" class="w-4 h-4" />
                    {{ $section['open_in_maps_text'] }}
                </a>
            </div>
        </div>

        {{-- Social Links --}}
        @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
            <div class="mt-12 text-center">
                <p class="text-gray-500 dark:text-gray-400 text-sm mb-5">{{ $section['info_follow_us_label'] }}</p>
                <div class="flex justify-center gap-3">
                    @foreach ($social as $key => $link)
                        @if ($key !== 'show_icon' && is_array($link))
                            <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                class="w-11 h-11 rounded-xl bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 flex items-center justify-center text-gray-600 dark:text-gray-400 hover:bg-gradient-to-br hover:from-primary-500 hover:to-secondary-500 hover:text-white hover:border-transparent hover:scale-110 transition-all duration-300 shadow-sm">
                                <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                            </a>
                        @endif
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</section>
