<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'title' => 'Ready to Get Started?',
            'subtitle' => 'Join thousands of happy customers.',
            'primary_button' => 'Schedule Your First Pickup',
            'secondary_button' => 'Call Us Now',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section class="py-20 gradient-hero relative overflow-hidden" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="absolute inset-0 overflow-hidden">
        <div class="floating-element w-64 h-64 bg-white -top-32 -right-32 animate-float"></div>
        <div class="floating-element w-48 h-48 bg-white bottom-0 left-1/4 animate-float delay-300"></div>
    </div>

    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl sm:text-4xl font-bold text-white mb-6">{{ $section['title'] }}</h2>
        <p class="text-xl text-white/90 mb-8">{{ $section['subtitle'] }}</p>
        <div class="flex flex-wrap justify-center gap-4">
            <a href="#contact" class="btn btn-white">
                {{ $section['primary_button'] }}
            </a>
            <a href="tel:{{ $company['phone'] }}" class="btn btn-outline-white">
                <x-icon icon="heroicons:phone" class="w-5 h-5 mr-2" />
                {{ $section['secondary_button'] }}
            </a>
        </div>
    </div>
</section>
