<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [
            ['question' => 'How does the pickup and delivery work?', 'answer' => 'Simply schedule a pickup through our website or app. Our driver will arrive at your chosen time slot.'],
            ['question' => 'What if my clothes get damaged?', 'answer' => 'We take utmost care of your garments. In the rare case of damage, we have comprehensive insurance.'],
            ['question' => 'Do you use eco-friendly products?', 'answer' => 'Yes! We use biodegradable, eco-friendly detergents that are gentle on both your clothes and the environment.'],
            ['question' => 'What areas do you serve?', 'answer' => 'We currently serve the entire Washville metropolitan area including downtown and suburbs.'],
            ['question' => 'Can I specify washing instructions?', 'answer' => 'Absolutely! You can add special instructions for each order.'],
            ['question' => 'What payment methods do you accept?', 'answer' => 'We accept all major credit cards, debit cards, and digital wallets.'],
        ];

        $this->section = array_merge([
            'badge' => 'FAQ',
            'title' => 'Frequently Asked Questions',
            'subtitle' => 'Find answers to common questions.',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section id="faq" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- FAQ Accordion --}}
        <div class="space-y-0">
            @foreach ($items as $index => $faq)
                <div class="scroll-animate faq-item {{ $index === 0 ? 'active' : '' }}">
                    <div class="faq-question">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white pr-8">
                            {{ $faq['question'] }}</h3>
                        <x-icon icon="heroicons:chevron-down" class="faq-icon w-5 h-5 text-gray-500 flex-shrink-0" />
                    </div>
                    <div class="faq-answer">
                        <p class="text-gray-600 dark:text-gray-400">{{ $faq['answer'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
