<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->section = $section;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [
            ['icon' => 'heroicons:leaf', 'title' => 'Eco-Friendly', 'description' => '100% biodegradable detergents.'],
            ['icon' => 'heroicons:clock', 'title' => 'On-Time Delivery', 'description' => 'Guaranteed delivery within promised timeframe.'],
            ['icon' => 'heroicons:shield-check', 'title' => 'Fully Insured', 'description' => 'Your garments are protected.'],
            ['icon' => 'heroicons:heart', 'title' => 'Care & Quality', 'description' => 'Every item treated with attention.'],
        ];
    }

    public function getPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    public function getDefaultPaddingClasses(): string
    {
        $classes = [];
        if ($this->paddingTop === null) {
            $classes[] = 'pt-12';
        }
        if ($this->paddingBottom === null) {
            $classes[] = 'pb-12';
        }
        return implode(' ', $classes);
    }
};
?>

<div>
<section class="features-overlap-section {{ $isWhiteBackground ? 'features-overlap-white' : 'features-overlap-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Waves --}}
    <div class="features-overlap-waves">
        <svg class="features-overlap-wave" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z"></path>
        </svg>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-overlap-container">
            @foreach ($items as $index => $feature)
                <div class="features-overlap-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms; --overlap-index: {{ $index }}">
                    <div class="features-overlap-card">
                        {{-- Gradient Bar --}}
                        <div class="features-overlap-bar"></div>

                        {{-- Icon Badge --}}
                        <div class="features-overlap-badge">
                            <div class="features-overlap-icon">
                                <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-5 h-5" />
                            </div>
                        </div>

                        {{-- Content --}}
                        <div class="features-overlap-content">
                            <h3 class="features-overlap-title">{{ $feature['title'] }}</h3>
                            <p class="features-overlap-desc">{{ $feature['description'] }}</p>
                        </div>

                        {{-- Decorative Circle --}}
                        <div class="features-overlap-circle"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    /* ===== Features Overlap Section ===== */
    .features-overlap-section {
        position: relative;
        padding: 6rem 0;
        overflow: hidden;
    }

    .features-overlap-white {
        background: #ffffff;
    }

    .features-overlap-gray {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 50%, #e2e8f0 100%);
    }

    .dark .features-overlap-white {
        background: var(--color-bg-secondary);
    }

    .dark .features-overlap-gray {
        background: linear-gradient(135deg, var(--color-bg-secondary) 0%, var(--color-bg-primary) 50%, var(--color-bg-secondary) 100%);
    }

    /* ===== Background Waves ===== */
    .features-overlap-waves {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 150px;
        overflow: hidden;
        pointer-events: none;
    }

    .features-overlap-wave {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        fill: var(--color-primary-100);
        opacity: 0.3;
    }

    .dark .features-overlap-wave {
        fill: var(--color-primary-900);
        opacity: 0.2;
    }

    /* ===== Container ===== */
    .features-overlap-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 2rem;
        margin-top: 2rem;
    }

    /* ===== Item ===== */
    .features-overlap-item {
        position: relative;
    }

    .features-overlap-card {
        position: relative;
        background: white;
        border-radius: 1.25rem;
        padding: 2rem 1.5rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        overflow: hidden;
    }

    .features-overlap-item:hover .features-overlap-card {
        transform: translateY(-10px) scale(1.02);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    .dark .features-overlap-card {
        background: var(--color-card-bg);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    }

    .dark .features-overlap-item:hover .features-overlap-card {
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5);
    }

    /* ===== Gradient Bar ===== */
    .features-overlap-bar {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s ease;
    }

    .features-overlap-item:hover .features-overlap-bar {
        transform: scaleX(1);
    }

    /* ===== Badge ===== */
    .features-overlap-badge {
        display: inline-flex;
        margin-bottom: 1.5rem;
        position: relative;
    }

    .features-overlap-icon {
        width: 3rem;
        height: 3rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        color: white;
        border-radius: 0.875rem;
        transition: all 0.4s ease;
        position: relative;
        z-index: 1;
    }

    .features-overlap-item:hover .features-overlap-icon {
        transform: rotate(360deg) scale(1.1);
    }

    .features-overlap-badge::before {
        content: '';
        position: absolute;
        inset: -4px;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        border-radius: 1rem;
        opacity: 0.2;
        transition: all 0.4s ease;
    }

    .features-overlap-item:hover .features-overlap-badge::before {
        inset: -8px;
        opacity: 0.3;
    }

    /* ===== Content ===== */
    .features-overlap-content {
        position: relative;
        z-index: 1;
    }

    .features-overlap-title {
        font-family: var(--font-heading);
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--color-gray-900);
        margin-bottom: 0.5rem;
    }

    .dark .features-overlap-title {
        color: var(--color-text-primary);
    }

    .features-overlap-desc {
        font-size: 0.9375rem;
        color: var(--color-gray-600);
        line-height: 1.6;
    }

    .dark .features-overlap-desc {
        color: var(--color-text-tertiary);
    }

    /* ===== Decorative Circle ===== */
    .features-overlap-circle {
        position: absolute;
        bottom: -30px;
        right: -30px;
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, var(--color-primary-200), var(--color-secondary-200));
        border-radius: 50%;
        opacity: 0.2;
        transition: all 0.4s ease;
    }

    .features-overlap-item:hover .features-overlap-circle {
        transform: scale(1.5);
        opacity: 0.3;
    }

    .dark .features-overlap-circle {
        background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
        opacity: 0.15;
    }

    /* ===== RTL Support ===== */
    [dir="rtl"] .features-overlap-section {
        direction: rtl;
    }

    [dir="rtl"] .features-overlap-bar {
        transform-origin: right;
    }

    [dir="rtl"] .features-overlap-content {
        text-align: right;
    }

    [dir="rtl"] .features-overlap-circle {
        right: auto;
        left: -30px;
    }

    [dir="rtl"] .features-overlap-wave {
        transform: scaleX(-1);
    }

    [dir="rtl"] .features-overlap-item:hover .features-overlap-icon {
        transform: rotate(-360deg) scale(1.1);
    }

    /* ===== Responsive ===== */
    @media (max-width: 640px) {
        .features-overlap-section {
            padding: 4rem 0;
        }

        .features-overlap-container {
            grid-template-columns: 1fr;
            gap: 1.5rem;
        }

        .features-overlap-card {
            padding: 1.5rem 1.25rem;
        }

        .features-overlap-waves {
            height: 100px;
        }
    }
</style>
</div>
