<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->section = $section;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props, fallback to defaults
        $this->items = !empty($items) ? $items : [
            ['icon' => 'heroicons:leaf', 'title' => 'Eco-Friendly', 'description' => '100% biodegradable detergents.'],
            ['icon' => 'heroicons:clock', 'title' => 'On-Time Delivery', 'description' => 'Guaranteed delivery within promised timeframe.'],
            ['icon' => 'heroicons:shield-check', 'title' => 'Fully Insured', 'description' => 'Your garments are protected.'],
            ['icon' => 'heroicons:heart', 'title' => 'Care & Quality', 'description' => 'Every item treated with attention.'],
        ];
    }

    /**
     * Get inline padding style for the section
     * Returns CSS style string if custom padding is set, otherwise empty string
     */
    public function getPaddingStyle(): string
    {
        $styles = [];

        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }

        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }

        return !empty($styles) ? implode('; ', $styles) : '';
    }

    /**
     * Get default padding classes (used when custom padding is not set)
     */
    public function getDefaultPaddingClasses(): string
    {
        $classes = [];

        if ($this->paddingTop === null) {
            $classes[] = 'pt-12'; // default padding for this section
        }

        if ($this->paddingBottom === null) {
            $classes[] = 'pb-12'; // default padding for this section
        }

        return implode(' ', $classes);
    }
};
?>

<section class="{{ $this->getDefaultPaddingClasses() }} {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            @foreach ($items as $index => $feature)
                <div class="scroll-animate flex items-center gap-4">
                    <div
                        class="w-14 h-14 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-7 h-7 text-primary-600" />
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-900 dark:text-white">{{ $feature['title'] }}</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $feature['description'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
