<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null,
        ?array $sampleData = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default items fallback
        $defaultItems = [
            ['image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600', 'alt' => 'Modern laundry facility'],
            ['image' => 'https://images.unsplash.com/photo-1582735689369-4fe89db7114c?w=600', 'alt' => 'Fresh folded clothes'],
            ['image' => 'https://images.unsplash.com/photo-1517677208171-0bc6725a3e60?w=600', 'alt' => 'Professional ironing'],
            ['image' => 'https://images.unsplash.com/photo-1489274495757-95c7c837b101?w=600', 'alt' => 'Clean white shirts'],
            ['image' => 'https://images.unsplash.com/photo-1604335399105-a0c585fd81a1?w=600', 'alt' => 'Eco-friendly products'],
            ['image' => 'https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?w=600', 'alt' => 'Delivery service'],
        ];

        // Merge sample_data items with passed items, prioritizing sample_data
        // Priority: sampleData['items'] > items > defaultItems (dummy images)
        if (!empty($sampleData['items']) && is_array($sampleData['items'])) {
            $this->items = $sampleData['items'];
        } elseif (!empty($items) && is_array($items)) {
            $this->items = $items;
        } else {
            // When gallery is null or empty, show dummy images from URLs
            $this->items = $defaultItems;
        }

        $this->section = array_merge([
            'badge' => 'Gallery',
            'title' => 'Our Facility & Work',
            'subtitle' => 'Take a look at our state-of-the-art facility.',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Gallery Grid --}}
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            @foreach ($items as $index => $item)
                <div class="scroll-animate gallery-item {{ $index === 0 ? 'md:col-span-2 md:row-span-2' : '' }}">
                    <img src="{{ $item['image_url'] ?? $item['image'] }}" alt="{{ $item['alt'] }}"
                        class="w-full h-full object-cover {{ $index === 0 ? 'aspect-square md:aspect-auto md:h-full' : 'aspect-square' }}"
                        loading="lazy">
                    <div class="gallery-overlay">
                        <p class="text-white font-medium">{{ $item['alt'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
