<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public array $hero = [];
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->section = $section;
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->hero = array_merge(
            [
                'badge' => '#1 Rated Laundry Service in Town',
                'title' => 'Fresh & Clean Laundry',
                'subtitle' => 'Every Time, On Time',
                'description' => 'Experience premium laundry services with free pickup & delivery.',
                'hero_image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop',
                'buttons' => [['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'heroicons:arrow-right', 'is_transparent' => false], ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => 'heroicons:play-circle', 'is_transparent' => true]],
                'floating_cards' => [['icon' => 'heroicons:clock', 'title' => 'Express', 'subtitle' => '24h Service'], ['icon' => 'heroicons:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery']],
                'stats' => [],
            ],
            $this->section,
        );

        if (!empty($this->items)) {
            $this->hero['stats'] = $this->items;
        }
    }

    /**
     * Get custom padding style if set
     */
    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section class="hero5-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Shapes --}}
        <div class="hero5-bg-shape hero5-bg-shape-1"></div>
        <div class="hero5-bg-shape hero5-bg-shape-2"></div>

        <div class="hero5-container">
            {{-- Content --}}
            <div class="hero5-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero5-badge">
                    <svg class="hero5-badge-star w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                        </path>
                    </svg>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero5-title">
                    <span class="hero5-title-line">{{ $hero['title'] }}</span>
                    <span class="hero5-title-line"><span
                            class="hero5-title-highlight">{{ $hero['subtitle'] }}</span></span>
                </h1>

                {{-- Description --}}
                <p class="hero5-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero5-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero5-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero5-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero5-stats">
                        @foreach (array_slice($hero['stats'], 0, 3) as $stat)
                            <div class="hero5-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero5-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                    </div>
                                @endif
                                <div class="hero5-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero5-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Image Section --}}
            <div class="hero5-image-section">
                <div class="hero5-image-stack animate-fade-in-up delay-200">
                    {{-- Decorative Ring --}}
                    <div class="hero5-deco-ring"></div>

                    {{-- Main Image --}}
                    <div class="hero5-image-main">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                    </div>

                    {{-- Floating Cards --}}
                    @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                        @if ($index === 0)
                            <div class="hero5-float-badge animate-bounce-soft">
                                <div class="hero5-float-badge-icon">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:clock' }}" class="w-5 h-5" />
                                </div>
                                <div>
                                    <p class="hero5-float-badge-text">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero5-float-badge-sub">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @else
                            <div class="hero5-float-card animate-bounce-soft delay-300">
                                <div class="hero5-float-card-icon">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}"
                                        class="w-6 h-6 text-white" />
                                </div>
                                <div>
                                    <p class="hero5-float-card-title">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero5-float-card-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    <style>
        /* ===== Hero Section Style 5 - Asymmetric Layout ===== */

        .hero5-section {
            position: relative;
            min-height: 100vh;
            background: var(--color-bg-primary);
            overflow: hidden;
        }

        .dark .hero5-section {
            background: var(--color-bg-primary);
        }

        /* Background Shapes */
        .hero5-bg-shape {
            position: absolute;
            z-index: 0;
        }

        .hero5-bg-shape-1 {
            top: 0;
            right: 0;
            width: 60%;
            height: 100%;
            background: linear-gradient(180deg, var(--color-primary-50) 0%, var(--color-primary-100) 100%);
            clip-path: polygon(30% 0, 100% 0, 100% 100%, 0 100%);
        }

        .dark .hero5-bg-shape-1 {
            background: linear-gradient(180deg, var(--color-bg-secondary) 0%, var(--color-bg-tertiary) 100%);
        }

        .hero5-bg-shape-2 {
            bottom: 0;
            left: 0;
            width: 200px;
            height: 200px;
            background: var(--color-secondary-100);
            border-radius: 50%;
            transform: translate(-50%, 50%);
        }

        .dark .hero5-bg-shape-2 {
            background: var(--color-secondary-900);
            opacity: 0.3;
        }

        /* Container */
        .hero5-container {
            position: relative;
            z-index: 1;
            max-width: 1280px;
            margin: 0 auto;
            padding: 8rem 2rem;
            display: grid;
            grid-template-columns: 1fr;
            gap: 4rem;
            align-items: center;
        }

        @media (min-width: 1024px) {
            .hero5-container {
                grid-template-columns: 1fr 1.2fr;
                padding: 6rem 4rem;
                min-height: 100vh;
            }
        }

        /* Content */
        .hero5-content {
            order: 2;
        }

        @media (min-width: 1024px) {
            .hero5-content {
                order: 1;
            }
        }

        /* Badge */
        .hero5-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: white;
            border: 1px solid var(--color-gray-200);
            border-radius: 0.5rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--color-gray-700);
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .dark .hero5-badge {
            background: var(--color-card-bg);
            border-color: var(--color-border);
            color: var(--color-text-secondary);
        }

        .hero5-badge-star {
            color: #f59e0b;
        }

        /* Title */
        .hero5-title {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.15;
            color: var(--color-gray-900);
            margin-bottom: 1.5rem;
        }

        @media (min-width: 640px) {
            .hero5-title {
                font-size: 3rem;
            }
        }

        @media (min-width: 1024px) {
            .hero5-title {
                font-size: 3.5rem;
            }
        }

        .dark .hero5-title {
            color: var(--color-text-primary);
        }

        .hero5-title-line {
            display: block;
        }

        .hero5-title-highlight {
            position: relative;
            color: var(--color-primary-600);
        }

        .hero5-title-highlight::after {
            content: '';
            position: absolute;
            bottom: 0.1em;
            left: 0;
            right: 0;
            height: 0.3em;
            background: var(--color-primary-200);
            z-index: -1;
        }

        .dark .hero5-title-highlight {
            color: var(--color-primary-400);
        }

        .dark .hero5-title-highlight::after {
            background: var(--color-primary-900);
        }

        /* Description */
        .hero5-description {
            font-size: 1.125rem;
            line-height: 1.75;
            color: var(--color-gray-600);
            margin-bottom: 2rem;
            max-width: 480px;
        }

        .dark .hero5-description {
            color: var(--color-text-tertiary);
        }

        /* CTA Group */
        .hero5-cta-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 3rem;
        }

        .hero5-btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem 1.75rem;
            background: var(--color-primary-600);
            color: white;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .hero5-btn-primary:hover {
            background: var(--color-primary-700);
            transform: translateX(4px);
        }

        .hero5-btn-primary svg,
        .hero5-btn-secondary svg {
            color: inherit;
            flex-shrink: 0;
        }

        .hero5-btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 1.75rem;
            background: transparent;
            color: var(--color-gray-700);
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .hero5-btn-secondary:hover {
            color: var(--color-primary-600);
        }

        .dark .hero5-btn-secondary {
            color: var(--color-text-secondary);
        }

        .dark .hero5-btn-secondary:hover {
            color: var(--color-primary-400);
        }

        /* Stats Row */
        .hero5-stats {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
        }

        .hero5-stat-item {
            display: flex;
            flex-direction: column;
        }

        .hero5-stat-icon {
            color: var(--color-primary-500);
            margin-bottom: 0.25rem;
        }

        .dark .hero5-stat-icon {
            color: var(--color-primary-400);
        }

        .hero5-stat-value {
            font-family: var(--font-heading);
            font-size: 2rem;
            font-weight: 800;
            color: var(--color-gray-900);
        }

        .dark .hero5-stat-value {
            color: var(--color-text-primary);
        }

        .hero5-stat-label {
            font-size: 0.875rem;
            color: var(--color-gray-500);
        }

        .dark .hero5-stat-label {
            color: var(--color-text-tertiary);
        }

        /* Image Section */
        .hero5-image-section {
            position: relative;
            order: 1;
        }

        @media (min-width: 1024px) {
            .hero5-image-section {
                order: 2;
            }
        }

        .hero5-image-stack {
            position: relative;
            max-width: 600px;
            margin: 0 auto;
        }

        .hero5-image-main {
            position: relative;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
        }

        .dark .hero5-image-main {
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.4);
        }

        .hero5-image-main img {
            width: 100%;
            height: auto;
            display: block;
        }

        /* Floating Elements */
        .hero5-float-badge {
            position: absolute;
            top: -1rem;
            right: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            background: white;
            border-radius: 0.75rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        @media (min-width: 640px) {
            .hero5-float-badge {
                top: 1rem;
                right: -2rem;
            }
        }

        .dark .hero5-float-badge {
            background: var(--color-card-bg);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        .hero5-float-badge-icon {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.5rem;
            background: var(--color-primary-100);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--color-primary-600);
        }

        .dark .hero5-float-badge-icon {
            background: var(--color-primary-900);
            color: var(--color-primary-400);
        }

        .hero5-float-badge-text {
            font-weight: 700;
            font-size: 0.875rem;
            color: var(--color-gray-900);
        }

        .dark .hero5-float-badge-text {
            color: var(--color-text-primary);
        }

        .hero5-float-badge-sub {
            font-size: 0.75rem;
            color: var(--color-gray-500);
        }

        .dark .hero5-float-badge-sub {
            color: var(--color-text-tertiary);
        }

        .hero5-float-card {
            position: absolute;
            bottom: -1rem;
            left: 1rem;
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem 1.25rem;
            background: white;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        @media (min-width: 640px) {
            .hero5-float-card {
                bottom: 2rem;
                left: -2rem;
            }
        }

        .dark .hero5-float-card {
            background: var(--color-card-bg);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        .hero5-float-card-icon {
            width: 3rem;
            height: 3rem;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-success-500, #10b981), var(--color-success-600, #059669));
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero5-float-card-icon svg {
            color: white;
        }

        .dark .hero5-float-card-icon {
            background: linear-gradient(135deg, var(--color-success-400, #34d399), var(--color-success-500, #10b981));
        }

        .hero5-float-card-title {
            font-weight: 700;
            font-size: 0.9375rem;
            color: var(--color-gray-900);
        }

        .dark .hero5-float-card-title {
            color: var(--color-text-primary);
        }

        .hero5-float-card-subtitle {
            font-size: 0.8125rem;
            color: var(--color-gray-500);
        }

        .dark .hero5-float-card-subtitle {
            color: var(--color-text-tertiary);
        }

        /* Decorative Ring */
        .hero5-deco-ring {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 120%;
            height: 120%;
            border: 2px dashed var(--color-primary-200);
            border-radius: 50%;
            opacity: 0.5;
            z-index: -1;
        }

        .dark .hero5-deco-ring {
            border-color: var(--color-primary-800);
            opacity: 0.3;
        }

        /* RTL Support */
        [dir="rtl"] .hero5-bg-shape-1 {
            right: auto;
            left: 0;
            clip-path: polygon(0 0, 70% 0, 100% 100%, 0 100%);
        }

        [dir="rtl"] .hero5-btn-primary:hover {
            transform: translateX(-4px);
        }

        [dir="rtl"] .hero5-float-badge {
            right: auto;
            left: 1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero5-float-badge {
                left: -2rem;
                right: auto;
            }
        }

        [dir="rtl"] .hero5-float-card {
            left: auto;
            right: 1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero5-float-card {
                right: -2rem;
                left: auto;
            }
        }
    </style>
</div>
