<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public array $hero = [];
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->section = $section;
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->hero = array_merge(
            [
                'badge' => '#1 Rated Laundry Service in Town',
                'title' => 'Fresh & Clean Laundry',
                'subtitle' => 'Every Time, On Time',
                'description' => 'Experience premium laundry services with free pickup & delivery.',
                'hero_image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop',
                'buttons' => [['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'heroicons:calendar', 'is_transparent' => false], ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => 'heroicons:arrow-right', 'is_transparent' => true]],
                'floating_cards' => [['icon' => 'heroicons:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery'], ['icon' => 'heroicons:clock', 'title' => 'Express', 'subtitle' => '24h Service']],
                'stats' => [],
            ],
            $this->section,
        );

        if (!empty($this->items)) {
            $this->hero['stats'] = $this->items;
        }
    }

    /**
     * Get custom padding style if set
     */
    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section class="hero6-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Grid --}}
        <div class="hero6-bg-grid"></div>

        {{-- Floating Orbs --}}
        <div class="hero6-orb hero6-orb-1"></div>
        <div class="hero6-orb hero6-orb-2"></div>
        <div class="hero6-orb hero6-orb-3"></div>

        <div class="hero6-container">
            {{-- Content Area --}}
            <div class="hero6-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero6-badge">
                    <span class="hero6-badge-icon">
                        <svg class="w-3 h-3 text-primary-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </span>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero6-title">
                    {{ $hero['title'] }}
                    <span class="hero6-subtitle">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero6-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero6-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero6-btn-secondary">
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero6-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero6-stats">
                        @foreach ($hero['stats'] as $stat)
                            <div class="hero6-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero6-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                    </div>
                                @endif
                                <div>
                                    <div class="hero6-stat-value">{{ $stat['value'] }}</div>
                                    <div class="hero6-stat-label">{{ $stat['label'] }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Card Stack --}}
            <div class="hero6-card-stack animate-fade-in-up delay-200">
                {{-- Background Card --}}
                <div class="hero6-bg-card"></div>

                {{-- Main Card --}}
                <div class="hero6-main-card">
                    <div class="hero6-card-image">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                        <div class="hero6-card-badge">
                            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            {{ $hero['badge'] }}
                        </div>
                    </div>
                    <div class="hero6-card-content">
                        <h3 class="hero6-card-title">{{ $hero['title'] }}</h3>
                        <p class="hero6-card-subtitle">{{ $hero['subtitle'] }}</p>
                        @if (!empty($hero['floating_cards']))
                            <div class="hero6-card-features">
                                @foreach ($hero['floating_cards'] as $card)
                                    <div class="hero6-card-feature">
                                        <span class="hero6-card-feature-icon">
                                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-3 h-3" />
                                        </span>
                                        {{ $card['title'] ?? '' }} {{ $card['subtitle'] ?? '' }}
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Floating Cards --}}
                @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                    <div
                        class="hero6-float-card hero6-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                        <div class="hero6-float-icon {{ $index === 0 ? 'green' : 'blue' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-5 h-5 text-white" />
                        </div>
                        <div>
                            <p class="hero6-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero6-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Wave Bottom --}}
        <div class="hero6-wave">
            <svg viewBox="0 0 1440 120" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <path
                    d="M0 120L48 108C96 96 192 72 288 60C384 48 480 48 576 54C672 60 768 72 864 78C960 84 1056 84 1152 78C1248 72 1344 60 1392 54L1440 48V120H1392C1344 120 1248 120 1152 120C1056 120 960 120 864 120C768 120 672 120 576 120C480 120 384 120 288 120C192 120 96 120 48 120H0Z"
                    class="hero6-wave-fill" />
            </svg>
        </div>
    </section>


    <style>
        /* ===== Hero Section Style 6 - Card-Based Hero ===== */

        .hero6-section {
            position: relative;
            min-height: 100vh;
            background: linear-gradient(135deg, var(--color-primary-600) 0%, var(--color-primary-800) 50%, var(--color-secondary-700) 100%);
            overflow: hidden;
            display: flex;
            align-items: center;
        }

        /* Animated Background Grid */
        .hero6-bg-grid {
            position: absolute;
            inset: 0;
            background-image:
                linear-gradient(rgba(255, 255, 255, 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(255, 255, 255, 0.03) 1px, transparent 1px);
            background-size: 60px 60px;
        }

        /* Floating Orbs */
        .hero6-orb {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.05);
            animation: orb-float 15s ease-in-out infinite;
        }

        .hero6-orb-1 {
            width: 400px;
            height: 400px;
            top: -100px;
            right: 10%;
            animation-delay: 0s;
        }

        .hero6-orb-2 {
            width: 300px;
            height: 300px;
            bottom: -50px;
            left: 5%;
            animation-delay: -5s;
        }

        .hero6-orb-3 {
            width: 200px;
            height: 200px;
            top: 40%;
            left: 30%;
            animation-delay: -10s;
        }

        @keyframes orb-float {

            0%,
            100% {
                transform: translate(0, 0);
            }

            25% {
                transform: translate(20px, -20px);
            }

            50% {
                transform: translate(-10px, 10px);
            }

            75% {
                transform: translate(15px, 15px);
            }
        }

        /* Container */
        .hero6-container {
            position: relative;
            z-index: 1;
            max-width: 1280px;
            margin: 0 auto;
            padding: 6rem 2rem;
            display: grid;
            grid-template-columns: 1fr;
            gap: 3rem;
        }

        @media (min-width: 1024px) {
            .hero6-container {
                grid-template-columns: 1fr 1fr;
                gap: 4rem;
                align-items: center;
            }
        }

        /* Content Area */
        .hero6-content {
            color: white;
        }

        /* Badge */
        .hero6-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 500;
            color: white;
            margin-bottom: 1.5rem;
        }

        .hero6-badge-icon {
            width: 1.25rem;
            height: 1.25rem;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Title */
        .hero6-title {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.1;
            color: white;
            margin-bottom: 1.5rem;
        }

        @media (min-width: 640px) {
            .hero6-title {
                font-size: 3rem;
            }
        }

        @media (min-width: 1024px) {
            .hero6-title {
                font-size: 3.75rem;
            }
        }

        .hero6-subtitle {
            display: block;
            color: var(--color-secondary-300);
        }

        /* Description */
        .hero6-description {
            font-size: 1.125rem;
            line-height: 1.75;
            color: rgba(255, 255, 255, 0.85);
            margin-bottom: 2rem;
            max-width: 500px;
        }

        /* CTA Group */
        .hero6-cta-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 3rem;
        }

        .hero6-btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 2rem;
            background: white;
            color: var(--color-primary-700);
            font-weight: 700;
            font-size: 1rem;
            border-radius: 0.75rem;
            transition: all 0.3s ease;
        }

        .hero6-btn-primary:hover {
            background: var(--color-gray-100);
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .hero6-btn-primary svg,
        .hero6-btn-secondary svg {
            color: inherit;
            flex-shrink: 0;
        }

        .hero6-btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 2rem;
            background: transparent;
            color: white;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.75rem;
            border: 2px solid rgba(255, 255, 255, 0.3);
            transition: all 0.3s ease;
        }

        .hero6-btn-secondary:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.5);
        }

        /* Stats Inline */
        .hero6-stats {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
        }

        .hero6-stat-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .hero6-stat-icon {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.5rem;
            background: rgba(255, 255, 255, 0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero6-stat-icon svg {
            color: white;
        }

        .hero6-stat-value {
            font-family: var(--font-heading);
            font-size: 1.25rem;
            font-weight: 800;
            color: white;
        }

        .hero6-stat-label {
            font-size: 0.75rem;
            color: rgba(255, 255, 255, 0.7);
        }

        /* Card Stack Area */
        .hero6-card-stack {
            position: relative;
            display: flex;
            justify-content: center;
        }

        /* Main Card */
        .hero6-main-card {
            position: relative;
            width: 100%;
            max-width: 450px;
            background: white;
            border-radius: 1.5rem;
            padding: 1.5rem;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3);
        }

        .dark .hero6-main-card {
            background: var(--color-card-bg);
        }

        .hero6-card-image {
            position: relative;
            border-radius: 1rem;
            overflow: hidden;
            margin-bottom: 1.5rem;
        }

        .hero6-card-image img {
            width: 100%;
            height: auto;
            display: block;
        }

        .hero6-card-badge {
            position: absolute;
            top: 1rem;
            left: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(10px);
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
            color: white;
        }

        .hero6-card-content {
            text-align: center;
        }

        .hero6-card-title {
            font-family: var(--font-heading);
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--color-gray-900);
            margin-bottom: 0.5rem;
        }

        .dark .hero6-card-title {
            color: var(--color-text-primary);
        }

        .hero6-card-subtitle {
            font-size: 1rem;
            color: var(--color-gray-500);
            margin-bottom: 1.5rem;
        }

        .dark .hero6-card-subtitle {
            color: var(--color-text-tertiary);
        }

        .hero6-card-features {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 1rem;
        }

        .hero6-card-feature {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.875rem;
            color: var(--color-gray-600);
        }

        .dark .hero6-card-feature {
            color: var(--color-text-secondary);
        }

        .hero6-card-feature-icon {
            width: 1.25rem;
            height: 1.25rem;
            border-radius: 50%;
            background: var(--color-primary-100);
            color: var(--color-primary-600);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .dark .hero6-card-feature-icon {
            background: var(--color-primary-900);
            color: var(--color-primary-400);
        }

        .hero6-card-feature-icon svg {
            color: inherit;
        }

        /* Floating Mini Cards */
        .hero6-float-card {
            position: absolute;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.875rem 1rem;
            background: white;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .hero6-float-card-1 {
            top: 0;
            right: -1rem;
            transform: translateY(-50%);
        }

        @media (min-width: 640px) {
            .hero6-float-card-1 {
                right: -3rem;
            }
        }

        .hero6-float-card-2 {
            bottom: 2rem;
            left: -1rem;
        }

        @media (min-width: 640px) {
            .hero6-float-card-2 {
                left: -3rem;
            }
        }

        .hero6-float-icon {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.625rem;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero6-float-icon svg {
            color: white;
        }

        .hero6-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-500, #10b981), var(--color-success-600, #059669));
        }

        .hero6-float-icon.blue {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
        }

        .dark .hero6-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-400, #34d399), var(--color-success-500, #10b981));
        }

        .dark .hero6-float-icon.blue {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-500));
        }

        .hero6-float-title {
            font-weight: 700;
            font-size: 0.875rem;
            color: var(--color-gray-900);
        }

        .dark .hero6-float-title {
            color: var(--color-text-primary);
        }

        .hero6-float-subtitle {
            font-size: 0.75rem;
            color: var(--color-gray-500);
        }

        .dark .hero6-float-subtitle {
            color: var(--color-text-tertiary);
        }

        /* Dark mode for floating cards */
        .dark .hero6-float-card {
            background: var(--color-card-bg);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Background Card Effect */
        .hero6-bg-card {
            position: absolute;
            width: 100%;
            max-width: 450px;
            height: 100%;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 1.5rem;
            top: 1rem;
            left: 50%;
            transform: translateX(-50%) rotate(3deg);
            z-index: -1;
        }

        /* Wave Bottom */
        .hero6-wave {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            line-height: 0;
        }

        .hero6-wave svg {
            width: 100%;
            height: 60px;
        }

        @media (min-width: 768px) {
            .hero6-wave svg {
                height: 100px;
            }
        }

        .hero6-wave-fill {
            fill: white;
        }

        .dark .hero6-wave-fill {
            fill: var(--color-bg-primary);
        }

        /* RTL Support */
        [dir="rtl"] .hero6-float-card-1 {
            right: auto;
            left: -1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero6-float-card-1 {
                left: -3rem;
            }
        }

        [dir="rtl"] .hero6-float-card-2 {
            left: auto;
            right: -1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero6-float-card-2 {
                right: -3rem;
            }
        }
    </style>

</div>
