<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public array $hero = [];
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->section = $section;
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->hero = array_merge(
            [
                'badge' => '#1 Rated Laundry Service in Town',
                'title' => 'Fresh & Clean Laundry',
                'subtitle' => 'Every Time, On Time',
                'description' => 'Experience premium laundry services with free pickup & delivery.',
                'hero_image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop',
                'buttons' => [['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'heroicons:arrow-right', 'is_transparent' => false], ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => '', 'is_transparent' => true]],
                'floating_cards' => [['icon' => 'heroicons:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery'], ['icon' => 'heroicons:clock', 'title' => 'Express', 'subtitle' => '24h Service']],
                'stats' => [],
            ],
            $this->section,
        );

        if (!empty($this->items)) {
            $this->hero['stats'] = $this->items;
        }
    }

    /**
     * Get custom padding style if set
     */
    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section class="hero4-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Blobs --}}
        <div class="hero4-blob hero4-blob-1"></div>
        <div class="hero4-blob hero4-blob-2"></div>
        <div class="hero4-blob hero4-blob-3"></div>

        {{-- Container --}}
        <div class="hero4-container">
            {{-- Main Content --}}
            <div class="hero4-content">
                {{-- Badge --}}
                <div class="hero4-badge animate-fade-in-down">
                    <div class="hero4-badge-icon">
                        <svg class="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <span class="hero4-badge-text">{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero4-title animate-fade-in-up">
                    {{ $hero['title'] }}
                    <span class="hero4-title-gradient">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero4-description animate-fade-in-up delay-200">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero4-cta-group animate-fade-in-up delay-300">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero4-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero4-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Image with Float Cards --}}
                <div class="hero4-image-container animate-fade-in-up delay-400">
                    <div class="hero4-image-wrapper">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                    </div>

                    {{-- Floating Cards --}}
                    @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                        <div
                            class="hero4-float-card hero4-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                            <div class="hero4-float-icon {{ $index === 0 ? 'green' : 'purple' }}">
                                <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-5 h-5 text-white" />
                            </div>
                            <div>
                                <p class="hero4-float-title">{{ $card['title'] ?? '' }}</p>
                                <p class="hero4-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        {{-- Stats Bar --}}
        @if (!empty($hero['stats']))
            <div class="hero4-stats-bar">
                <div class="hero4-stats">
                    @foreach ($hero['stats'] as $stat)
                        <div class="hero4-stat-item">
                            @if (!empty($stat['icon']))
                                <div class="hero4-stat-icon">
                                    <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                </div>
                            @endif
                            <div>
                                <div class="hero4-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero4-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </section>

    <style>
        /* ===== Hero Section Style 4 - Centered Minimal ===== */

        .hero4-section {
            position: relative;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            background: var(--color-bg-primary);
            overflow: hidden;
        }

        .dark .hero4-section {
            background: var(--color-bg-primary);
        }

        /* Animated Background Blobs */
        .hero4-blob {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.5;
            animation: blob-float 20s ease-in-out infinite;
        }

        .hero4-blob-1 {
            width: 500px;
            height: 500px;
            background: var(--color-primary-200);
            top: -200px;
            right: -100px;
            animation-delay: 0s;
        }

        .hero4-blob-2 {
            width: 400px;
            height: 400px;
            background: var(--color-secondary-200);
            bottom: -150px;
            left: -100px;
            animation-delay: -5s;
        }

        .hero4-blob-3 {
            width: 300px;
            height: 300px;
            background: var(--color-primary-300);
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            animation-delay: -10s;
        }

        .dark .hero4-blob-1 {
            background: var(--color-primary-900);
            opacity: 0.3;
        }

        .dark .hero4-blob-2 {
            background: var(--color-secondary-900);
            opacity: 0.3;
        }

        .dark .hero4-blob-3 {
            background: var(--color-primary-800);
            opacity: 0.2;
        }

        @keyframes blob-float {

            0%,
            100% {
                transform: translate(0, 0) scale(1);
            }

            25% {
                transform: translate(30px, -30px) scale(1.1);
            }

            50% {
                transform: translate(-20px, 20px) scale(0.9);
            }

            75% {
                transform: translate(20px, 30px) scale(1.05);
            }
        }

        /* Container */
        .hero4-container {
            position: relative;
            z-index: 1;
            width: 100%;
            max-width: 1280px;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            flex-direction: column;
            flex: 1;
        }

        @media (min-width: 640px) {
            .hero4-container {
                padding: 0 1.5rem;
            }
        }

        @media (min-width: 1024px) {
            .hero4-container {
                padding: 0 2rem;
            }
        }

        /* Main Content */
        .hero4-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 6rem 0 2rem;
            text-align: center;
        }

        /* Badge */
        .hero4-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 0.75rem 0.5rem 0.5rem;
            background: white;
            border-radius: 9999px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            margin-bottom: 2rem;
        }

        .dark .hero4-badge {
            background: var(--color-card-bg);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        }

        .hero4-badge-icon {
            width: 2rem;
            height: 2rem;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .hero4-badge-text {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--color-gray-700);
        }

        .dark .hero4-badge-text {
            color: var(--color-text-secondary);
        }

        /* Title */
        .hero4-title {
            font-family: var(--font-heading);
            font-size: 3rem;
            font-weight: 800;
            line-height: 1.1;
            color: var(--color-gray-900);
            margin-bottom: 1rem;
            max-width: 800px;
        }

        @media (min-width: 640px) {
            .hero4-title {
                font-size: 4rem;
            }
        }

        @media (min-width: 1024px) {
            .hero4-title {
                font-size: 5rem;
            }
        }

        .dark .hero4-title {
            color: var(--color-text-primary);
        }

        .hero4-title-gradient {
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Description */
        .hero4-description {
            font-size: 1.25rem;
            line-height: 1.75;
            color: var(--color-gray-600);
            max-width: 600px;
            margin-bottom: 2.5rem;
        }

        .dark .hero4-description {
            color: var(--color-text-tertiary);
        }

        /* CTA Group */
        .hero4-cta-group {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            margin-bottom: 3rem;
        }

        @media (min-width: 640px) {
            .hero4-cta-group {
                flex-direction: row;
            }
        }

        .hero4-btn-primary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 1rem 2.5rem;
            background: var(--color-gray-900);
            color: white;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .hero4-btn-primary:hover {
            background: var(--color-gray-800);
            transform: translateY(-2px);
        }

        .hero4-btn-primary svg,
        .hero4-btn-secondary svg {
            color: inherit;
            flex-shrink: 0;
        }

        .dark .hero4-btn-primary {
            background: white;
            color: var(--color-gray-900);
        }

        .dark .hero4-btn-primary:hover {
            background: var(--color-gray-100);
        }

        .hero4-btn-secondary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 1rem 2.5rem;
            background: transparent;
            color: var(--color-gray-700);
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.5rem;
            border: 1px solid var(--color-gray-300);
            transition: all 0.3s ease;
        }

        .hero4-btn-secondary:hover {
            border-color: var(--color-gray-400);
            background: var(--color-gray-50);
        }

        .dark .hero4-btn-secondary {
            color: var(--color-text-secondary);
            border-color: var(--color-border);
        }

        .dark .hero4-btn-secondary:hover {
            background: var(--color-bg-secondary);
        }

        /* Image with Float Cards */
        .hero4-image-container {
            position: relative;
            width: 100%;
            max-width: 700px;
            margin: 0 auto;
        }

        .hero4-image-wrapper {
            position: relative;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.15);
        }

        .dark .hero4-image-wrapper {
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.4);
        }

        .hero4-image-wrapper img {
            width: 100%;
            height: auto;
            display: block;
        }

        /* Floating Elements */
        .hero4-float-card {
            position: absolute;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.875rem 1.25rem;
            background: white;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
        }

        .dark .hero4-float-card {
            background: var(--color-card-bg);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        .hero4-float-card-1 {
            top: -1rem;
            left: -1rem;
        }

        @media (min-width: 640px) {
            .hero4-float-card-1 {
                top: 2rem;
                left: -3rem;
            }
        }

        .hero4-float-card-2 {
            bottom: -1rem;
            right: -1rem;
        }

        @media (min-width: 640px) {
            .hero4-float-card-2 {
                bottom: 2rem;
                right: -3rem;
            }
        }

        .hero4-float-icon {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.625rem;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero4-float-icon svg {
            color: white;
        }

        .hero4-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-500, #10b981), var(--color-success-600, #059669));
        }

        .hero4-float-icon.purple {
            background: linear-gradient(135deg, var(--color-secondary-500), var(--color-secondary-600));
        }

        .dark .hero4-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-400, #34d399), var(--color-success-500, #10b981));
        }

        .dark .hero4-float-icon.purple {
            background: linear-gradient(135deg, var(--color-secondary-400), var(--color-secondary-500));
        }

        .hero4-float-title {
            font-weight: 600;
            font-size: 0.875rem;
            color: var(--color-gray-900);
        }

        .dark .hero4-float-title {
            color: var(--color-text-primary);
        }

        .hero4-float-subtitle {
            font-size: 0.75rem;
            color: var(--color-gray-500);
        }

        .dark .hero4-float-subtitle {
            color: var(--color-text-tertiary);
        }

        /* Stats Bar */
        .hero4-stats-bar {
            position: relative;
            z-index: 1;
            background: white;
            border-top: 1px solid var(--color-gray-100);
            padding: 1.5rem 0;
        }

        .dark .hero4-stats-bar {
            background: var(--color-bg-secondary);
            border-color: var(--color-border);
        }

        .hero4-stats {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 2rem;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        @media (min-width: 768px) {
            .hero4-stats {
                gap: 4rem;
            }
        }

        .hero4-stat-item {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .hero4-stat-icon {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.5rem;
            background: var(--color-primary-100);
            color: var(--color-primary-600);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .dark .hero4-stat-icon {
            background: var(--color-primary-900);
            color: var(--color-primary-400);
        }

        .hero4-stat-value {
            font-family: var(--font-heading);
            font-size: 1.75rem;
            font-weight: 800;
            color: var(--color-primary-600);
        }

        .dark .hero4-stat-value {
            color: var(--color-primary-400);
        }

        .hero4-stat-label {
            font-size: 0.875rem;
            color: var(--color-gray-500);
            max-width: 80px;
            line-height: 1.3;
        }

        .dark .hero4-stat-label {
            color: var(--color-text-tertiary);
        }

        /* RTL Support */
        [dir="rtl"] .hero4-float-card-1 {
            left: auto;
            right: -1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero4-float-card-1 {
                right: -3rem;
                left: auto;
            }
        }

        [dir="rtl"] .hero4-float-card-2 {
            right: auto;
            left: -1rem;
        }

        @media (min-width: 640px) {
            [dir="rtl"] .hero4-float-card-2 {
                left: -3rem;
                right: auto;
            }
        }
    </style>
</div>
