<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public array $hero = [];
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->section = $section;
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->hero = array_merge(
            [
                'badge' => '#1 Rated Laundry Service in Town',
                'title' => 'Fresh & Clean Laundry',
                'subtitle' => 'Every Time, On Time',
                'description' => 'Experience premium laundry services with free pickup & delivery.',
                'hero_image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop',
                'buttons' => [['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'heroicons:calendar', 'is_transparent' => false], ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => 'heroicons:play-circle', 'is_transparent' => true]],
                'floating_cards' => [['icon' => 'heroicons:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery'], ['icon' => 'heroicons:clock', 'title' => 'Express', 'subtitle' => '24h Service']],
                'stats' => [],
            ],
            $this->section,
        );

        if (!empty($this->items)) {
            $this->hero['stats'] = $this->items;
        }
    }

    /**
     * Get custom padding style if set
     */
    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section class="hero3-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Image --}}
        <div class="hero3-bg-image">
            <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                alt="Professional Laundry Service" loading="lazy">
        </div>

        {{-- Overlay --}}
        <div class="hero3-overlay"></div>

        {{-- Container --}}
        <div class="hero3-container">
            {{-- Main Content --}}
            <div class="hero3-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero3-badge">
                    <span class="hero3-badge-dot"></span>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero3-title">
                    {{ $hero['title'] }}
                    <span class="hero3-subtitle">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero3-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero3-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero3-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero3-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero3-stats">
                        @foreach ($hero['stats'] as $stat)
                            <div class="hero3-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero3-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-6 h-6" />
                                    </div>
                                @endif
                                <div class="hero3-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero3-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Floating Cards --}}
            @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                <div
                    class="{{ $index === 0 ? 'hero3-float-left' : 'hero3-float-right' }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                    <div class="hero3-float-card">
                        <div class="hero3-float-icon {{ $index === 0 ? 'green' : 'blue' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <p class="hero3-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero3-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                </div>
            @endforeach

            {{-- Scroll Indicator --}}
            <div class="hero3-scroll-indicator">
                <div class="hero3-scroll-mouse">
                    <div class="hero3-scroll-wheel"></div>
                </div>
                <span>Scroll</span>
            </div>
        </div>
    </section>

    <style>
        /* ===== Hero Section Style 3 - Full Background Image ===== */

        .hero3-section {
            position: relative;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .hero3-bg-image {
            position: absolute;
            inset: 0;
            z-index: 0;
        }

        .hero3-bg-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .hero3-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg,
                    rgba(15, 23, 42, 0.85) 0%,
                    rgba(30, 41, 59, 0.75) 50%,
                    rgba(15, 23, 42, 0.85) 100%);
            z-index: 1;
        }

        .hero3-container {
            position: relative;
            z-index: 2;
            width: 100%;
            max-width: 1280px;
            margin: 0 auto;
            padding: 6rem 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }

        @media (min-width: 640px) {
            .hero3-container {
                padding: 6rem 1.5rem 0;
            }
        }

        @media (min-width: 1024px) {
            .hero3-container {
                padding: 6rem 2rem 0;
            }
        }

        .hero3-content {
            max-width: 900px;
            text-align: center;
            padding: 2rem 0;
        }

        /* Badge */
        .hero3-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 500;
            color: white;
            margin-bottom: 2rem;
        }

        .hero3-badge-dot {
            width: 8px;
            height: 8px;
            background: var(--color-primary-400);
            border-radius: 50%;
            animation: pulse-soft 2s ease-in-out infinite;
        }

        /* Title */
        .hero3-title {
            font-family: var(--font-heading);
            font-size: 3rem;
            font-weight: 800;
            line-height: 1.1;
            color: white;
            margin-bottom: 1rem;
        }

        @media (min-width: 640px) {
            .hero3-title {
                font-size: 4rem;
            }
        }

        @media (min-width: 1024px) {
            .hero3-title {
                font-size: 5rem;
            }
        }

        .hero3-subtitle {
            display: block;
            color: var(--color-primary-400);
        }

        /* Description */
        .hero3-description {
            font-size: 1.25rem;
            line-height: 1.75;
            color: rgba(255, 255, 255, 0.8);
            max-width: 600px;
            margin: 0 auto 2.5rem;
        }

        /* CTA Group */
        .hero3-cta-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            justify-content: center;
            margin-bottom: 4rem;
        }

        .hero3-btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1.25rem 2.5rem;
            background: var(--color-primary-500);
            color: white;
            font-weight: 700;
            font-size: 1.125rem;
            border-radius: 0.75rem;
            transition: all 0.3s ease;
        }

        .hero3-btn-primary:hover {
            background: var(--color-primary-400);
            transform: scale(1.05);
        }

        .hero3-btn-primary svg,
        .hero3-btn-secondary svg {
            color: inherit;
            flex-shrink: 0;
        }

        .hero3-btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1.25rem 2.5rem;
            background: transparent;
            color: white;
            font-weight: 700;
            font-size: 1.125rem;
            border-radius: 0.75rem;
            border: 2px solid rgba(255, 255, 255, 0.3);
            transition: all 0.3s ease;
        }

        .hero3-btn-secondary:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.5);
        }

        /* Stats */
        .hero3-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
            max-width: 800px;
            margin: 0 auto;
        }

        @media (min-width: 768px) {
            .hero3-stats {
                grid-template-columns: repeat(4, 1fr);
            }
        }

        .hero3-stat-item {
            text-align: center;
        }

        .hero3-stat-icon {
            display: flex;
            justify-content: center;
            margin-bottom: 0.5rem;
            color: var(--color-primary-400);
        }

        .hero3-stat-value {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 800;
            color: white;
            margin-bottom: 0.5rem;
        }

        .hero3-stat-label {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.6);
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        /* Floating Cards */
        .hero3-float-left {
            position: absolute;
            left: 2rem;
            bottom: 15%;
            z-index: 3;
            display: none;
        }

        @media (min-width: 1280px) {
            .hero3-float-left {
                display: block;
            }
        }

        .hero3-float-right {
            position: absolute;
            right: 2rem;
            top: 20%;
            z-index: 3;
            display: none;
        }

        @media (min-width: 1280px) {
            .hero3-float-right {
                display: block;
            }
        }

        .hero3-float-card {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem 1.5rem;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 1rem;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }

        .hero3-float-icon {
            width: 3rem;
            height: 3rem;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero3-float-icon svg {
            color: white;
        }

        .hero3-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-500, #10b981), var(--color-success-600, #059669));
        }

        .hero3-float-icon.blue {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
        }

        .dark .hero3-float-icon.green {
            background: linear-gradient(135deg, var(--color-success-400, #34d399), var(--color-success-500, #10b981));
        }

        .dark .hero3-float-icon.blue {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-500));
        }

        .hero3-float-title {
            font-weight: 700;
            font-size: 0.875rem;
            color: var(--color-gray-900);
        }

        .hero3-float-subtitle {
            font-size: 0.75rem;
            color: var(--color-gray-500);
        }

        /* Scroll Indicator */
        .hero3-scroll-indicator {
            position: absolute;
            bottom: 2rem;
            left: 50%;
            transform: translateX(-50%);
            z-index: 3;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.5rem;
            color: rgba(255, 255, 255, 0.6);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .hero3-scroll-mouse {
            width: 24px;
            height: 40px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            position: relative;
        }

        .hero3-scroll-wheel {
            width: 4px;
            height: 8px;
            background: rgba(255, 255, 255, 0.6);
            border-radius: 2px;
            position: absolute;
            top: 6px;
            left: 50%;
            transform: translateX(-50%);
            animation: scroll-wheel 2s ease-in-out infinite;
        }

        @keyframes scroll-wheel {

            0%,
            100% {
                opacity: 1;
                transform: translateX(-50%) translateY(0);
            }

            50% {
                opacity: 0.3;
                transform: translateX(-50%) translateY(10px);
            }
        }

        /* RTL Support */
        [dir="rtl"] .hero3-float-left {
            left: auto;
            right: 2rem;
        }

        [dir="rtl"] .hero3-float-right {
            right: auto;
            left: 2rem;
        }
    </style>
</div>
