<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public array $hero = [];
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->section = $section;
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->hero = array_merge(
            [
                'badge' => '#1 Rated Laundry Service in Town',
                'title' => 'Fresh & Clean Laundry',
                'subtitle' => 'Every Time, On Time',
                'description' => 'Experience premium laundry services with free pickup & delivery.',
                'hero_image' => 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop',
                'buttons' => [['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'heroicons:arrow-right', 'is_transparent' => false], ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => '', 'is_transparent' => true]],
                'floating_cards' => [['icon' => 'heroicons:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery']],
                'stats' => [],
            ],
            $this->section,
        );

        if (!empty($this->items)) {
            $this->hero['stats'] = $this->items;
        }
    }

    /**
     * Get custom padding style if set
     */
    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section class="hero2-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="hero2-container">
            {{-- Content Side --}}
            <div class="hero2-content-side">
                <div class="hero2-content-inner animate-fade-in-up">
                    {{-- Badge --}}
                    <div class="hero2-badge">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <span>{{ $hero['badge'] }}</span>
                    </div>

                    {{-- Title --}}
                    <h1 class="hero2-title">{{ $hero['title'] }}</h1>
                    <p class="hero2-subtitle">{{ $hero['subtitle'] }}</p>

                    {{-- Description --}}
                    <p class="hero2-description">{{ $hero['description'] }}</p>

                    {{-- CTA Buttons --}}
                    <div class="hero2-cta-group">
                        @foreach ($hero['buttons'] ?? [] as $index => $button)
                            @if ($button['is_transparent'] ?? false)
                                <a href="{{ $button['url'] ?? '#' }}" class="hero2-btn-secondary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @else
                                <a href="{{ $button['url'] ?? '#' }}" class="hero2-btn-primary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    </div>

                    {{-- Stats --}}
                    @if (!empty($hero['stats']))
                        <div class="hero2-stats">
                            @foreach ($hero['stats'] as $stat)
                                <div class="hero2-stat-item">
                                    @if (!empty($stat['icon']))
                                        <div class="hero2-stat-icon">
                                            <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                        </div>
                                    @endif
                                    <div class="hero2-stat-value">{{ $stat['value'] }}</div>
                                    <div class="hero2-stat-label">{{ $stat['label'] }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            {{-- Image Side --}}
            <div class="hero2-image-side">
                <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                    alt="Professional Laundry Service" loading="lazy">
                <div class="hero2-image-overlay"></div>

                {{-- Decorative Dots --}}
                <div class="hero2-deco-dots"></div>

                {{-- Floating Cards --}}
                @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                    <div
                        class="hero2-float-card hero2-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                        <div
                            class="hero2-float-icon {{ $index === 0 ? 'hero2-float-icon-primary' : 'hero2-float-icon-secondary' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-6 h-6" />
                        </div>
                        <div>
                            <p class="hero2-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero2-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <style>
        /* ===== Hero Section Style 2 - Split Screen ===== */

        .hero2-section {
            min-height: 100vh;
            background: var(--color-bg-primary);
        }

        .hero2-container {
            display: flex;
            max-width: 1280px;
            margin: 0 auto;
            min-height: 100vh;
            padding: 6rem 1rem 0;
        }

        @media (min-width: 640px) {
            .hero2-container {
                padding: 6rem 1.5rem 0;
            }
        }

        @media (min-width: 1024px) {
            .hero2-container {
                padding: 6rem 2rem 0;
            }
        }

        .hero2-content-side {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 4rem 0;
            background: var(--color-bg-primary);
        }

        @media (min-width: 1024px) {
            .hero2-content-side {
                padding: 4rem 2rem 4rem 0;
            }
        }

        .dark .hero2-content-side {
            background: var(--color-bg-primary);
        }

        .hero2-image-side {
            display: none;
            flex: 1;
            position: relative;
            overflow: hidden;
        }

        @media (min-width: 1024px) {
            .hero2-image-side {
                display: block;
            }
        }

        .hero2-image-side img {
            position: absolute;
            inset: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .hero2-image-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--color-primary-600) 0%, var(--color-secondary-600) 100%);
            opacity: 0.3;
        }

        .hero2-content-inner {
            max-width: 540px;
        }

        @media (min-width: 1024px) {
            .hero2-content-inner {
                margin-left: auto;
                padding-right: 3rem;
            }
        }

        /* Badge */
        .hero2-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            background: linear-gradient(135deg, var(--color-primary-100), var(--color-secondary-100));
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--color-primary-700);
            margin-bottom: 1.5rem;
        }

        .dark .hero2-badge {
            background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
            color: var(--color-primary-300);
        }

        /* Title */
        .hero2-title {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.1;
            color: var(--color-gray-900);
            margin-bottom: 0.5rem;
        }

        @media (min-width: 640px) {
            .hero2-title {
                font-size: 3rem;
            }
        }

        @media (min-width: 1024px) {
            .hero2-title {
                font-size: 3.5rem;
            }
        }

        .dark .hero2-title {
            color: var(--color-text-primary);
        }

        .hero2-subtitle {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.1;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 1.5rem;
        }

        @media (min-width: 640px) {
            .hero2-subtitle {
                font-size: 3rem;
            }
        }

        @media (min-width: 1024px) {
            .hero2-subtitle {
                font-size: 3.5rem;
            }
        }

        /* Description */
        .hero2-description {
            font-size: 1.125rem;
            line-height: 1.75;
            color: var(--color-gray-600);
            margin-bottom: 2rem;
        }

        .dark .hero2-description {
            color: var(--color-text-tertiary);
        }

        /* CTA Group */
        .hero2-cta-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 3rem;
        }

        .hero2-btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 2rem;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
            color: white;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 9999px;
            box-shadow: 0 4px 14px rgba(37, 99, 235, 0.4);
            transition: all 0.3s ease;
        }

        .hero2-btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(37, 99, 235, 0.5);
        }

        .hero2-btn-primary svg,
        .hero2-btn-secondary svg {
            color: inherit;
            flex-shrink: 0;
        }

        .hero2-btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 2rem;
            background: transparent;
            color: var(--color-gray-700);
            font-weight: 600;
            font-size: 1rem;
            border-radius: 9999px;
            border: 2px solid var(--color-gray-300);
            transition: all 0.3s ease;
        }

        .hero2-btn-secondary:hover {
            border-color: var(--color-primary-500);
            color: var(--color-primary-600);
        }

        .dark .hero2-btn-secondary {
            color: var(--color-text-secondary);
            border-color: var(--color-border);
        }

        .dark .hero2-btn-secondary:hover {
            border-color: var(--color-primary-500);
            color: var(--color-primary-400);
        }

        /* Stats */
        .hero2-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
        }

        @media (min-width: 640px) {
            .hero2-stats {
                grid-template-columns: repeat(4, 1fr);
            }
        }

        .hero2-stat-item {
            text-align: center;
            padding: 1rem;
            background: var(--color-gray-50);
            border-radius: 1rem;
        }

        .dark .hero2-stat-item {
            background: var(--color-bg-secondary);
        }

        .hero2-stat-icon {
            display: flex;
            justify-content: center;
            margin-bottom: 0.5rem;
            color: var(--color-primary-500);
        }

        .dark .hero2-stat-icon {
            color: var(--color-primary-400);
        }

        .hero2-stat-value {
            font-family: var(--font-heading);
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--color-primary-600);
            margin-bottom: 0.25rem;
        }

        .dark .hero2-stat-value {
            color: var(--color-primary-400);
        }

        .hero2-stat-label {
            font-size: 0.75rem;
            color: var(--color-gray-500);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .dark .hero2-stat-label {
            color: var(--color-text-tertiary);
        }

        /* Floating Card on Image */
        .hero2-float-card {
            position: absolute;
            display: flex;
            align-items: center;
            gap: 0.875rem;
            padding: 1rem 1.25rem;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 1rem;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            z-index: 10;
        }

        .hero2-float-card-1 {
            bottom: 2rem;
            left: 2rem;
        }

        .hero2-float-card-2 {
            top: 2rem;
            right: 2rem;
        }

        .hero2-float-icon {
            width: 3rem;
            height: 3rem;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .hero2-float-icon svg {
            color: white;
        }

        .hero2-float-icon-primary {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
        }

        .hero2-float-icon-secondary {
            background: linear-gradient(135deg, var(--color-success-500, #10b981), var(--color-success-600, #059669));
        }

        .dark .hero2-float-icon-primary {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-500));
        }

        .dark .hero2-float-icon-secondary {
            background: linear-gradient(135deg, var(--color-success-400, #34d399), var(--color-success-500, #10b981));
        }

        .hero2-float-title {
            font-weight: 700;
            font-size: 0.9375rem;
            color: var(--color-gray-900);
            line-height: 1.3;
        }

        .hero2-float-subtitle {
            font-size: 0.8125rem;
            color: var(--color-gray-500);
        }

        /* Dark mode for floating cards */
        .dark .hero2-float-card {
            background: rgba(30, 41, 59, 0.95);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .dark .hero2-float-title {
            color: var(--color-text-primary);
        }

        .dark .hero2-float-subtitle {
            color: var(--color-text-tertiary);
        }

        /* RTL Support for floating cards */
        [dir="rtl"] .hero2-float-card-1 {
            left: auto;
            right: 2rem;
        }

        [dir="rtl"] .hero2-float-card-2 {
            right: auto;
            left: 2rem;
        }

        /* Decorative Elements */
        .hero2-deco-dots {
            position: absolute;
            top: 2rem;
            right: 2rem;
            width: 100px;
            height: 100px;
            background-image: radial-gradient(white 2px, transparent 2px);
            background-size: 15px 15px;
            opacity: 0.5;
        }

        /* RTL Support */
        [dir="rtl"] .hero2-content-inner {
            margin-left: 0;
            margin-right: auto;
            padding-right: 0;
            padding-left: 3rem;
        }

        @media (min-width: 1024px) {
            [dir="rtl"] .hero2-content-side {
                padding: 4rem 0 4rem 2rem;
            }
        }
    </style>
</div>
