<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'mdi:calendar-clock'], ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'heroicons:truck'], ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'heroicons:sparkles'], ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'heroicons:home']];

        $this->section = array_merge(
            [
                'badge' => 'How It Works',
                'title' => 'Simple 4-Step Process',
                'subtitle' => 'Getting your laundry done has never been easier.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="how-it-works"
    class="section hiw-compact-light {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="hiw-compact-layout">
            {{-- Left: Header --}}
            <div class="hiw-compact-header">
                <span class="hiw-compact-badge">{{ $section['badge'] }}</span>
                <h2 class="hiw-compact-title">{{ $section['title'] }}</h2>
                <p class="hiw-compact-subtitle">{{ $section['subtitle'] }}</p>
            </div>

            {{-- Right: Steps Grid --}}
            <div class="hiw-compact-grid">
                @foreach ($items as $index => $step)
                    <div class="scroll-animate hiw-compact-item">
                        <div class="hiw-compact-num">{{ $step['step'] }}</div>
                        <div class="hiw-compact-icon">
                            <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}" class="w-6 h-6" />
                        </div>
                        <h3 class="hiw-compact-item-title">{{ $step['title'] }}</h3>
                        <p class="hiw-compact-item-desc">{{ $step['description'] }}</p>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

<style>
        /* Layout */
        .hiw-compact-layout {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 4rem;
            align-items: center;
        }

        [dir="rtl"] .hiw-compact-layout {
            direction: rtl;
        }

        /* Header */
        .hiw-compact-header {
            color: #fff;
        }

        .hiw-compact-badge {
            display: inline-block;
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-bottom: 1rem;
        }

        .dark .hiw-compact-badge {
            background: rgba(255, 255, 255, 0.1);
        }

        .hiw-compact-title {
            font-family: var(--font-heading);
            font-size: 2.5rem;
            font-weight: 700;
            line-height: 1.2;
            margin-bottom: 1rem;
        }

        .hiw-compact-subtitle {
            font-size: 1.125rem;
            opacity: 0.9;
            line-height: 1.6;
        }

        /* Grid */
        .hiw-compact-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
        }

        /* Item */
        .hiw-compact-item {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 1rem;
            padding: 1.5rem;
            position: relative;
            transition: all 0.3s ease;
        }

        .dark .hiw-compact-item {
            background: rgba(0, 0, 0, 0.2);
            border-color: rgba(255, 255, 255, 0.1);
        }

        .hiw-compact-item:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.2);
        }

        .dark .hiw-compact-item:hover {
            background: rgba(0, 0, 0, 0.3);
        }

        /* Number */
        .hiw-compact-num {
            position: absolute;
            top: 1rem;
            right: 1rem;
            font-size: 2rem;
            font-weight: 800;
            color: rgba(255, 255, 255, 0.15);
            line-height: 1;
        }

        [dir="rtl"] .hiw-compact-num {
            right: auto;
            left: 1rem;
        }

        /* Icon */
        .hiw-compact-icon {
            width: 3rem;
            height: 3rem;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }

        .hiw-compact-icon svg {
            color: #fff !important;
            fill: #fff !important;
        }

        .hiw-compact-item:hover .hiw-compact-icon {
            background: #fff;
            transform: scale(1.1);
        }

        .hiw-compact-item:hover .hiw-compact-icon svg {
            color: var(--color-primary-600) !important;
            fill: var(--color-primary-600) !important;
        }

        /* Title & Desc */
        .hiw-compact-item-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: #fff;
            margin-bottom: 0.5rem;
        }

        .hiw-compact-item-desc {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.5;
        }

        /* ===== Light/White Background Mode ===== */
        .hiw-compact-light .hiw-compact-header {
            color: #111827;
        }

        .hiw-compact-light .hiw-compact-badge {
            background: linear-gradient(135deg, var(--color-primary-100, #e0f2fe), var(--color-secondary-100, #fae8ff));
            color: var(--color-primary-700, #0369a1);
        }

        .hiw-compact-light .hiw-compact-subtitle {
            color: #4b5563;
            opacity: 1;
        }

        .hiw-compact-light .hiw-compact-item {
            background: #f9fafb;
            border-color: #e5e7eb;
            backdrop-filter: none;
        }

        .hiw-compact-light .hiw-compact-item:hover {
            background: #fff;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .hiw-compact-light .hiw-compact-num {
            color: var(--color-primary-200, #bae6fd);
        }

        .hiw-compact-light .hiw-compact-icon {
            background: linear-gradient(135deg, var(--color-primary-100, #e0f2fe), var(--color-secondary-100, #fae8ff));
        }

        .hiw-compact-light .hiw-compact-icon svg {
            color: var(--color-primary-600, #0284c7) !important;
            fill: var(--color-primary-600, #0284c7) !important;
        }

        .hiw-compact-light .hiw-compact-item:hover .hiw-compact-icon {
            background: linear-gradient(135deg, var(--color-primary-600, #0284c7), var(--color-secondary-500, #d946ef));
        }

        .hiw-compact-light .hiw-compact-item:hover .hiw-compact-icon svg {
            color: #fff !important;
            fill: #fff !important;
        }

        .hiw-compact-light .hiw-compact-item-title {
            color: #111827;
        }

        .hiw-compact-light .hiw-compact-item-desc {
            color: #4b5563;
        }

        /* Dark mode overrides for light background variant */
        .dark.hiw-compact-light .hiw-compact-header,
        .dark .hiw-compact-light .hiw-compact-header {
            color: #f9fafb;
        }

        .dark.hiw-compact-light .hiw-compact-badge,
        .dark .hiw-compact-light .hiw-compact-badge {
            background: linear-gradient(135deg, var(--color-primary-900, #0c4a6e), var(--color-secondary-900, #701a75));
            color: var(--color-primary-300, #7dd3fc);
        }

        .dark.hiw-compact-light .hiw-compact-subtitle,
        .dark .hiw-compact-light .hiw-compact-subtitle {
            color: #9ca3af;
        }

        .dark.hiw-compact-light .hiw-compact-item,
        .dark .hiw-compact-light .hiw-compact-item {
            background: #1f2937;
            border-color: #374151;
        }

        .dark.hiw-compact-light .hiw-compact-item:hover,
        .dark .hiw-compact-light .hiw-compact-item:hover {
            background: #374151;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }

        .dark.hiw-compact-light .hiw-compact-num,
        .dark .hiw-compact-light .hiw-compact-num {
            color: var(--color-primary-800, #075985);
        }

        .dark.hiw-compact-light .hiw-compact-icon,
        .dark .hiw-compact-light .hiw-compact-icon {
            background: linear-gradient(135deg, var(--color-primary-900, #0c4a6e), var(--color-secondary-900, #701a75));
        }

        .dark.hiw-compact-light .hiw-compact-icon svg,
        .dark .hiw-compact-light .hiw-compact-icon svg {
            color: var(--color-primary-400, #38bdf8) !important;
            fill: var(--color-primary-400, #38bdf8) !important;
        }

        .dark.hiw-compact-light .hiw-compact-item-title,
        .dark .hiw-compact-light .hiw-compact-item-title {
            color: #f9fafb;
        }

        .dark.hiw-compact-light .hiw-compact-item-desc,
        .dark .hiw-compact-light .hiw-compact-item-desc {
            color: #9ca3af;
        }

        /* Mobile Responsive */
        @media (max-width: 1024px) {
            .hiw-compact-layout {
                grid-template-columns: 1fr;
                gap: 3rem;
            }

            .hiw-compact-header {
                text-align: center;
            }

            .hiw-compact-title {
                font-size: 2rem;
            }
        }

        @media (max-width: 640px) {
            .hiw-compact-grid {
                grid-template-columns: 1fr;
            }

            .hiw-compact-item {
                padding: 1.25rem;
            }
        }
    </style>
</div>
