<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'mdi:calendar-clock'], ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'heroicons:truck'], ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'heroicons:sparkles'], ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'heroicons:home']];

        $this->section = array_merge(
            [
                'badge' => 'How It Works',
                'title' => 'Simple 4-Step Process',
                'subtitle' => 'Getting your laundry done has never been easier.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <section id="how-it-works"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }} overflow-hidden"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16">
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                <h2 class="section-title">{{ $section['title'] }}</h2>
                <p class="section-subtitle">{{ $section['subtitle'] }}</p>
            </div>

            {{-- Numbered Steps Container --}}
            <div class="hiw-numbered">
                {{-- Progress Line --}}
                <div class="hiw-numbered-line">
                    <div class="hiw-numbered-line-fill"></div>
                </div>

                {{-- Steps --}}
                <div class="hiw-numbered-steps">
                    @foreach ($items as $index => $step)
                        <div class="scroll-animate hiw-numbered-item">
                            {{-- Number Circle --}}
                            <div class="hiw-numbered-circle">
                                <span class="hiw-numbered-num">{{ $step['step'] }}</span>
                            </div>

                            {{-- Card --}}
                            <div class="hiw-numbered-card">
                                {{-- Icon --}}
                                <div class="hiw-numbered-icon">
                                    <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}"
                                        class="hiw-numbered-icon-svg w-6 h-6" />
                                </div>

                                {{-- Content --}}
                                <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">
                                    {{ $step['title'] }}
                                </h3>
                                <p class="text-gray-600 dark:text-gray-400 text-sm">
                                    {{ $step['description'] }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    <style>
        /* Numbered Container */
        .hiw-numbered {
            position: relative;
            padding-top: 3rem;
        }

        /* Progress Line */
        .hiw-numbered-line {
            position: absolute;
            top: 4.25rem;
            left: 10%;
            right: 10%;
            height: 4px;
            background: var(--color-gray-200);
            border-radius: 2px;
            overflow: hidden;
        }

        .dark .hiw-numbered-line {
            background: var(--color-gray-700);
        }

        /* Progress Line Fill - Animated */
        .hiw-numbered-line-fill {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            border-radius: 2px;
        }

        /* Steps Grid */
        .hiw-numbered-steps {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1.5rem;
        }

        /* Step Item */
        .hiw-numbered-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        /* Number Circle */
        .hiw-numbered-circle {
            position: relative;
            width: 3.5rem;
            height: 3.5rem;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            z-index: 1;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.35);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .hiw-numbered-item:hover .hiw-numbered-circle {
            transform: scale(1.08);
            box-shadow: 0 6px 25px rgba(37, 99, 235, 0.5);
        }

        .hiw-numbered-num {
            color: #fff;
            font-size: 1.125rem;
            font-weight: 700;
        }

        /* Card */
        .hiw-numbered-card {
            background: var(--color-card-bg, #fff);
            border-radius: 1rem;
            padding: 1.5rem;
            width: 100%;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            border: 1px solid transparent;
        }

        .dark .hiw-numbered-card {
            background: var(--color-bg-secondary);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .hiw-numbered-item:hover .hiw-numbered-card {
            transform: translateY(-5px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.1);
            border-color: var(--color-primary-200);
        }

        .dark .hiw-numbered-item:hover .hiw-numbered-card {
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.3);
            border-color: var(--color-primary-700);
        }

        /* Icon */
        .hiw-numbered-icon {
            width: 3rem;
            height: 3rem;
            background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            transition: all 0.3s ease;
        }

        .dark .hiw-numbered-icon {
            background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
        }

        .hiw-numbered-item:hover .hiw-numbered-icon {
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
        }

        /* Icon SVG colors */
        .hiw-numbered-icon-svg,
        .hiw-numbered-icon-svg svg {
            color: var(--color-primary-600);
            fill: var(--color-primary-600);
            transition: color 0.3s ease, fill 0.3s ease;
        }

        .dark .hiw-numbered-icon-svg,
        .dark .hiw-numbered-icon-svg svg {
            color: var(--color-primary-400);
            fill: var(--color-primary-400);
        }

        .hiw-numbered-item:hover .hiw-numbered-icon-svg,
        .hiw-numbered-item:hover .hiw-numbered-icon-svg svg,
        .hiw-numbered-item:hover .hiw-numbered-icon svg {
            color: #fff !important;
            fill: #fff !important;
        }

        /* Mobile Responsive */
        @media (max-width: 1024px) {
            .hiw-numbered-steps {
                grid-template-columns: repeat(2, 1fr);
            }

            .hiw-numbered-line {
                display: none;
            }
        }

        @media (max-width: 640px) {
            .hiw-numbered-steps {
                grid-template-columns: 1fr;
                max-width: 300px;
                margin: 0 auto;
            }
        }
    </style>
</div>
