<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'mdi:calendar-clock'], ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'heroicons:truck'], ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'heroicons:sparkles'], ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'heroicons:home']];

        $this->section = array_merge(
            [
                'badge' => 'How It Works',
                'title' => 'Simple 4-Step Process',
                'subtitle' => 'Getting your laundry done has never been easier.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="how-it-works" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="hiw-split-container">
            {{-- Left Side: Section Header --}}
            <div class="hiw-split-header">
                <div class="hiw-split-header-content">
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                    <h2 class="hiw-split-title">{{ $section['title'] }}</h2>
                    <p class="hiw-split-subtitle">{{ $section['subtitle'] }}</p>

                    {{-- Decorative Element --}}
                    <div class="hiw-split-decoration">
                        <div class="hiw-split-line"></div>
                        <div class="hiw-split-dots">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Right Side: Steps --}}
            <div class="hiw-split-steps">
                @foreach ($items as $index => $step)
                    <div class="scroll-animate hiw-split-step">
                        {{-- Step Number --}}
                        <div class="hiw-split-step-num">
                            {{ $step['step'] }}
                        </div>

                        {{-- Step Content --}}
                        <div class="hiw-split-step-content">
                            <div class="hiw-split-step-icon">
                                <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}" class="w-6 h-6" />
                            </div>
                            <div class="hiw-split-step-text">
                                <h3 class="hiw-split-step-title">{{ $step['title'] }}</h3>
                                <p class="hiw-split-step-desc">{{ $step['description'] }}</p>
                            </div>
                        </div>

                        {{-- Connector --}}
                        @if (!$loop->last)
                            <div class="hiw-split-connector"></div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

<style>
/* Split Container */
.hiw-split-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 4rem;
    align-items: start;
}

[dir="rtl"] .hiw-split-container {
    direction: rtl;
}

/* Header Section */
.hiw-split-header {
    position: sticky;
    top: 6rem;
}

.hiw-split-header-content {
    max-width: 400px;
}

[dir="rtl"] .hiw-split-header-content {
    margin-left: auto;
    margin-right: 0;
}

.hiw-split-title {
    font-family: var(--font-heading);
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--color-gray-900);
    margin-bottom: 1rem;
    line-height: 1.2;
}

.dark .hiw-split-title {
    color: var(--color-text-primary);
}

.hiw-split-subtitle {
    font-size: 1.125rem;
    color: var(--color-gray-600);
    line-height: 1.6;
}

.dark .hiw-split-subtitle {
    color: var(--color-text-tertiary);
}

/* Decoration */
.hiw-split-decoration {
    margin-top: 2rem;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.hiw-split-line {
    width: 60px;
    height: 3px;
    background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
    border-radius: 2px;
}

.hiw-split-dots {
    display: flex;
    gap: 0.5rem;
}

.hiw-split-dots span {
    width: 8px;
    height: 8px;
    background: var(--color-primary-400);
    border-radius: 50%;
    opacity: 0.6;
}

.hiw-split-dots span:first-child {
    opacity: 1;
}

/* Steps Section */
.hiw-split-steps {
    display: flex;
    flex-direction: column;
    gap: 0;
}

/* Single Step */
.hiw-split-step {
    position: relative;
    padding-left: 4rem;
    padding-bottom: 2.5rem;
}

[dir="rtl"] .hiw-split-step {
    padding-left: 0;
    padding-right: 4rem;
}

/* Step Number */
.hiw-split-step-num {
    position: absolute;
    left: 0;
    top: 0;
    width: 3rem;
    height: 3rem;
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
    color: #fff;
    font-size: 1rem;
    font-weight: 700;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
    z-index: 1;
}

[dir="rtl"] .hiw-split-step-num {
    left: auto;
    right: 0;
}

/* Step Content */
.hiw-split-step-content {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    background: var(--color-card-bg, #fff);
    border-radius: 1rem;
    padding: 1.25rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
}

.dark .hiw-split-step-content {
    background: var(--color-bg-secondary);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

.hiw-split-step:hover .hiw-split-step-content {
    transform: translateX(5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
}

[dir="rtl"] .hiw-split-step:hover .hiw-split-step-content {
    transform: translateX(-5px);
}

.dark .hiw-split-step:hover .hiw-split-step-content {
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
}

/* Step Icon */
.hiw-split-step-icon {
    width: 2.5rem;
    height: 2.5rem;
    min-width: 2.5rem;
    background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.dark .hiw-split-step-icon {
    background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
}

.hiw-split-step-icon svg {
    color: var(--color-primary-600);
    fill: var(--color-primary-600);
    transition: all 0.3s ease;
}

.dark .hiw-split-step-icon svg {
    color: var(--color-primary-400);
    fill: var(--color-primary-400);
}

.hiw-split-step:hover .hiw-split-step-icon {
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
}

.hiw-split-step:hover .hiw-split-step-icon svg {
    color: #fff !important;
    fill: #fff !important;
}

/* Step Text */
.hiw-split-step-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: var(--color-gray-900);
    margin-bottom: 0.25rem;
}

.dark .hiw-split-step-title {
    color: var(--color-text-primary);
}

.hiw-split-step-desc {
    font-size: 0.875rem;
    color: var(--color-gray-600);
}

.dark .hiw-split-step-desc {
    color: var(--color-text-tertiary);
}

/* Connector Line */
.hiw-split-connector {
    position: absolute;
    left: 1.4375rem;
    top: 3rem;
    bottom: 0;
    width: 3px;
    background: linear-gradient(180deg, var(--color-primary-300), var(--color-secondary-300));
    border-radius: 2px;
}

[dir="rtl"] .hiw-split-connector {
    left: auto;
    right: 1.4375rem;
}

.dark .hiw-split-connector {
    background: linear-gradient(180deg, var(--color-primary-700), var(--color-secondary-700));
}

/* Mobile Responsive */
@media (max-width: 1024px) {
    .hiw-split-container {
        grid-template-columns: 1fr;
        gap: 3rem;
    }

    .hiw-split-header {
        position: static;
        text-align: center;
    }

    .hiw-split-header-content {
        max-width: 100%;
        margin: 0 auto;
    }

    [dir="rtl"] .hiw-split-header-content {
        margin: 0 auto;
    }

    .hiw-split-decoration {
        justify-content: center;
    }

    .hiw-split-title {
        font-size: 2rem;
    }
}

@media (max-width: 640px) {
    .hiw-split-step {
        padding-left: 3.5rem;
    }

    [dir="rtl"] .hiw-split-step {
        padding-right: 3.5rem;
    }

    .hiw-split-step-num {
        width: 2.5rem;
        height: 2.5rem;
        font-size: 0.875rem;
    }

    .hiw-split-connector {
        left: 1.1875rem;
    }

    [dir="rtl"] .hiw-split-connector {
        right: 1.1875rem;
    }
}
</style>
</div>
