<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'mdi:calendar-clock'], ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'heroicons:truck'], ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'heroicons:sparkles'], ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'heroicons:home']];

        $this->section = array_merge(
            [
                'badge' => 'How It Works',
                'title' => 'Simple 4-Step Process',
                'subtitle' => 'Getting your laundry done has never been easier.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="how-it-works" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header - Left Aligned --}}
        <div class="hiw-stacked-header">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle hiw-stacked-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Stacked Steps --}}
        <div class="hiw-stacked-list">
            @foreach ($items as $index => $step)
                <div class="scroll-animate hiw-stacked-item {{ $index % 2 === 0 ? '' : 'hiw-stacked-item-alt' }}">
                    {{-- Left Side --}}
                    <div class="hiw-stacked-left">
                        <div class="hiw-stacked-number">
                            <span>{{ $step['step'] }}</span>
                        </div>
                    </div>

                    {{-- Center Divider --}}
                    <div class="hiw-stacked-divider">
                        <div class="hiw-stacked-dot"></div>
                        @if (!$loop->last)
                            <div class="hiw-stacked-line"></div>
                        @endif
                    </div>

                    {{-- Right Side --}}
                    <div class="hiw-stacked-right">
                        <div class="hiw-stacked-card">
                            <div class="hiw-stacked-card-header">
                                <div class="hiw-stacked-icon">
                                    <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}" class="w-6 h-6" />
                                </div>
                                <h3 class="hiw-stacked-title">{{ $step['title'] }}</h3>
                            </div>
                            <p class="hiw-stacked-desc">{{ $step['description'] }}</p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<style>
/* Header */
.hiw-stacked-header {
    margin-bottom: 3rem;
    text-align: center;
}

.hiw-stacked-subtitle {
    margin: 0 auto;
    max-width: 500px;
}

/* List */
.hiw-stacked-list {
    display: flex;
    flex-direction: column;
    max-width: 700px;
    margin-left: auto;
    margin-right: auto;
}

/* Item */
.hiw-stacked-item {
    display: grid;
    grid-template-columns: 100px 60px 1fr;
    min-height: 120px;
}

[dir="rtl"] .hiw-stacked-item {
    grid-template-columns: 1fr 60px 100px;
}

/* Alternate layout - swap sides */
.hiw-stacked-item-alt {
    grid-template-columns: 1fr 60px 100px;
}

[dir="rtl"] .hiw-stacked-item-alt {
    grid-template-columns: 100px 60px 1fr;
}

.hiw-stacked-item-alt .hiw-stacked-left {
    order: 3;
    justify-content: flex-start;
}

[dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-left {
    order: 1;
    justify-content: flex-end;
}

.hiw-stacked-item-alt .hiw-stacked-right {
    order: 1;
    justify-content: flex-end;
}

[dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-right {
    order: 3;
    justify-content: flex-start;
}

.hiw-stacked-item-alt .hiw-stacked-divider {
    order: 2;
}

/* Left Side */
.hiw-stacked-left {
    display: flex;
    justify-content: flex-end;
    padding-top: 0.5rem;
}

[dir="rtl"] .hiw-stacked-left {
    justify-content: flex-start;
}

/* Number */
.hiw-stacked-number {
    width: 3.5rem;
    height: 3.5rem;
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
    color: #fff;
    font-size: 1.125rem;
    font-weight: 700;
    border-radius: 0.75rem;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
    transition: all 0.3s ease;
}

.hiw-stacked-item:hover .hiw-stacked-number {
    transform: scale(1.1) rotate(5deg);
}

/* Divider */
.hiw-stacked-divider {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding-top: 1rem;
}

.hiw-stacked-dot {
    width: 12px;
    height: 12px;
    background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
    border-radius: 50%;
    position: relative;
    z-index: 1;
}

.hiw-stacked-line {
    width: 2px;
    flex: 1;
    min-height: 80px;
    background: linear-gradient(180deg, var(--color-primary-300), var(--color-secondary-300));
}

.dark .hiw-stacked-line {
    background: linear-gradient(180deg, var(--color-primary-700), var(--color-secondary-700));
}

/* Right Side */
.hiw-stacked-right {
    display: flex;
    padding-top: 0.25rem;
    padding-bottom: 1.5rem;
}

/* Card */
.hiw-stacked-card {
    background: var(--color-card-bg, #fff);
    border-radius: 1rem;
    padding: 1.25rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    border: 1px solid var(--color-gray-100);
    max-width: 400px;
    transition: all 0.3s ease;
}

.dark .hiw-stacked-card {
    background: var(--color-bg-secondary);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    border-color: var(--color-border);
}

.hiw-stacked-item:hover .hiw-stacked-card {
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    border-color: var(--color-primary-200);
}

.dark .hiw-stacked-item:hover .hiw-stacked-card {
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
    border-color: var(--color-primary-700);
}

/* Card Header */
.hiw-stacked-card-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 0.5rem;
}

/* Icon */
.hiw-stacked-icon {
    width: 2.5rem;
    height: 2.5rem;
    min-width: 2.5rem;
    background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.dark .hiw-stacked-icon {
    background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
}

.hiw-stacked-icon svg {
    color: var(--color-primary-600);
    fill: var(--color-primary-600);
    transition: all 0.3s ease;
}

.dark .hiw-stacked-icon svg {
    color: var(--color-primary-400);
    fill: var(--color-primary-400);
}

.hiw-stacked-item:hover .hiw-stacked-icon {
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
}

.hiw-stacked-item:hover .hiw-stacked-icon svg {
    color: #fff !important;
    fill: #fff !important;
}

/* Title & Desc */
.hiw-stacked-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: var(--color-gray-900);
}

.dark .hiw-stacked-title {
    color: var(--color-text-primary);
}

.hiw-stacked-desc {
    font-size: 0.875rem;
    color: var(--color-gray-600);
    line-height: 1.5;
}

.dark .hiw-stacked-desc {
    color: var(--color-text-tertiary);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .hiw-stacked-item,
    .hiw-stacked-item-alt,
    [dir="rtl"] .hiw-stacked-item,
    [dir="rtl"] .hiw-stacked-item-alt {
        grid-template-columns: 50px 40px 1fr;
    }

    /* Reset alternate layout on mobile - all items same direction */
    .hiw-stacked-item-alt .hiw-stacked-left,
    .hiw-stacked-item-alt .hiw-stacked-right,
    .hiw-stacked-item-alt .hiw-stacked-divider,
    [dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-left,
    [dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-right,
    [dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-divider {
        order: unset;
    }

    .hiw-stacked-item-alt .hiw-stacked-left,
    [dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-left,
    [dir="rtl"] .hiw-stacked-left {
        justify-content: flex-end;
    }

    .hiw-stacked-item-alt .hiw-stacked-right,
    [dir="rtl"] .hiw-stacked-item-alt .hiw-stacked-right {
        justify-content: flex-start;
    }

    .hiw-stacked-number {
        width: 2.5rem;
        height: 2.5rem;
        font-size: 0.875rem;
        border-radius: 0.5rem;
    }

    .hiw-stacked-card {
        max-width: 100%;
    }
}
</style>
</div>
