<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'mdi:calendar-clock'], ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'heroicons:truck'], ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'heroicons:sparkles'], ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'heroicons:home']];

        $this->section = array_merge(
            [
                'badge' => 'How It Works',
                'title' => 'Simple 4-Step Process',
                'subtitle' => 'Getting your laundry done has never been easier.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="how-it-works" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Timeline Layout --}}
        <div class="hiw-timeline">
            @foreach ($items as $index => $step)
                <div class="scroll-animate hiw-timeline-item {{ $index % 2 === 0 ? 'hiw-timeline-left' : 'hiw-timeline-right' }}">
                    {{-- Timeline Content --}}
                    <div class="hiw-timeline-content">
                        {{-- Step Number Badge --}}
                        <div class="hiw-timeline-step">
                            {{ $step['step'] }}
                        </div>

                        {{-- Icon --}}
                        <div class="hiw-timeline-icon">
                            <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}" class="hiw-timeline-icon-svg w-8 h-8" />
                        </div>

                        {{-- Text Content --}}
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">{{ $step['title'] }}</h3>
                        <p class="text-gray-600 dark:text-gray-400">{{ $step['description'] }}</p>
                    </div>

                    {{-- Timeline Node --}}
                    <div class="hiw-timeline-node">
                        <div class="hiw-timeline-node-inner"></div>
                    </div>
                </div>
            @endforeach

            {{-- Timeline Line --}}
            <div class="hiw-timeline-line"></div>
        </div>
    </div>
</section>

<style>
/* Timeline Container */
.hiw-timeline {
    position: relative;
    padding: 2rem 0;
}

/* Timeline Line */
.hiw-timeline-line {
    position: absolute;
    top: 0;
    bottom: 0;
    left: 50%;
    width: 3px;
    background: linear-gradient(180deg, var(--color-primary-500), var(--color-secondary-500));
    transform: translateX(-50%);
}

/* Timeline Item */
.hiw-timeline-item {
    position: relative;
    display: flex;
    align-items: center;
    margin-bottom: 3rem;
    width: 100%;
}

.hiw-timeline-item:last-child {
    margin-bottom: 0;
}

/* Left/Right Positioning */
.hiw-timeline-left {
    justify-content: flex-start;
    padding-right: calc(50% + 2rem);
}

.hiw-timeline-right {
    justify-content: flex-end;
    padding-left: calc(50% + 2rem);
}

/* RTL Support */
[dir="rtl"] .hiw-timeline-left {
    justify-content: flex-end;
    padding-right: 0;
    padding-left: calc(50% + 2rem);
}

[dir="rtl"] .hiw-timeline-right {
    justify-content: flex-start;
    padding-left: 0;
    padding-right: calc(50% + 2rem);
}

/* Timeline Content Box */
.hiw-timeline-content {
    background: var(--color-card-bg, #fff);
    border-radius: 1rem;
    padding: 1.5rem;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    position: relative;
    transition: all 0.3s ease;
    max-width: 100%;
}

.dark .hiw-timeline-content {
    background: var(--color-bg-secondary);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.3);
}

.hiw-timeline-content:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}

.dark .hiw-timeline-content:hover {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.4);
}

/* Timeline Node */
.hiw-timeline-node {
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    width: 1.5rem;
    height: 1.5rem;
    background: var(--color-primary-600);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1;
}

.hiw-timeline-node-inner {
    width: 0.75rem;
    height: 0.75rem;
    background: #fff;
    border-radius: 50%;
}

/* Step Number */
.hiw-timeline-step {
    position: absolute;
    top: -0.75rem;
    left: 1rem;
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
    color: #fff;
    font-size: 0.75rem;
    font-weight: 700;
    padding: 0.25rem 0.75rem;
    border-radius: 9999px;
}

[dir="rtl"] .hiw-timeline-step {
    left: auto;
    right: 1rem;
}

/* Icon Container */
.hiw-timeline-icon {
    width: 4rem;
    height: 4rem;
    background: linear-gradient(135deg, var(--color-primary-100), var(--color-secondary-100));
    border-radius: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
}

.dark .hiw-timeline-icon {
    background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
}

.hiw-timeline-content:hover .hiw-timeline-icon {
    background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-500));
}

/* Icon SVG colors */
.hiw-timeline-icon-svg,
.hiw-timeline-icon-svg svg {
    color: var(--color-primary-600);
    fill: var(--color-primary-600);
    transition: color 0.3s ease, fill 0.3s ease;
}

.dark .hiw-timeline-icon-svg,
.dark .hiw-timeline-icon-svg svg {
    color: var(--color-primary-400);
    fill: var(--color-primary-400);
}

.hiw-timeline-content:hover .hiw-timeline-icon-svg,
.hiw-timeline-content:hover .hiw-timeline-icon-svg svg,
.hiw-timeline-content:hover .hiw-timeline-icon svg {
    color: #fff !important;
    fill: #fff !important;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .hiw-timeline-line {
        left: 1rem;
    }

    .hiw-timeline-left,
    .hiw-timeline-right {
        justify-content: flex-start;
        padding-left: 3rem;
        padding-right: 0;
    }

    [dir="rtl"] .hiw-timeline-left,
    [dir="rtl"] .hiw-timeline-right {
        justify-content: flex-start;
        padding-right: 3rem;
        padding-left: 0;
    }

    [dir="rtl"] .hiw-timeline-line {
        left: auto;
        right: 1rem;
    }

    .hiw-timeline-node {
        left: 1rem;
    }

    [dir="rtl"] .hiw-timeline-node {
        left: auto;
        right: 1rem;
    }
}
</style>
</div>
